/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.vertx;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.api.models.PathItemImpl;
import io.smallrye.openapi.api.util.ListUtil;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.io.operation.OperationConstant;
import io.smallrye.openapi.runtime.io.parameter.ParameterReader;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.ResourceParameters;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.scanner.spi.AbstractAnnotationScanner;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.Annotations;
import io.smallrye.openapi.runtime.util.ModelUtil;
import io.smallrye.openapi.vertx.VertxConstants;
import io.smallrye.openapi.vertx.VertxLogging;
import io.smallrye.openapi.vertx.VertxParameter;
import io.smallrye.openapi.vertx.VertxParameterProcessor;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class VertxAnnotationScanner
extends AbstractAnnotationScanner {
    private static final String VERTX_PACKAGE = "io.vertx.ext.web";

    public String getName() {
        return "Vert.x";
    }

    public boolean isAsyncResponse(MethodInfo method) {
        return false;
    }

    public boolean isPostMethod(MethodInfo method) {
        return this.hasRouteMethod(method, "POST");
    }

    public boolean isDeleteMethod(MethodInfo method) {
        return this.hasRouteMethod(method, "DELETE");
    }

    public boolean containsScannerAnnotations(List<AnnotationInstance> instances, List<AnnotationScannerExtension> extensions) {
        for (AnnotationInstance instance : instances) {
            if (VertxParameter.isParameter(instance.name())) {
                return true;
            }
            if (instance.name().toString().startsWith(VERTX_PACKAGE) && !instance.name().equals((Object)VertxConstants.REQUEST_BODY)) {
                return true;
            }
            for (AnnotationScannerExtension extension : extensions) {
                if (!extension.isScannerAnnotationExtension(instance)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isScannerInternalParameter(Type parameterType) {
        return VertxConstants.INTERNAL_PARAMETERS.contains(parameterType.name());
    }

    public OpenAPI scan(AnnotationScannerContext context, OpenAPI openApi) {
        this.processRoutes(context, openApi);
        return openApi;
    }

    private boolean hasRouteMethod(MethodInfo method, String httpMethod) {
        if (method.hasAnnotation(VertxConstants.ROUTE)) {
            AnnotationInstance annotation = method.annotation(VertxConstants.ROUTE);
            AnnotationValue value = annotation.value("methods");
            return value != null && value.asEnumArray().length > 0 && Arrays.asList(value.asEnumArray()).contains(httpMethod);
        }
        return false;
    }

    private void processRoutes(AnnotationScannerContext context, OpenAPI openApi) {
        Collection routeAnnotations = context.getIndex().getAnnotations(VertxConstants.ROUTE);
        LinkedHashSet<ClassInfo> applications = new LinkedHashSet<ClassInfo>();
        for (AnnotationInstance annotationInstance : routeAnnotations) {
            if (annotationInstance.target().kind().equals((Object)AnnotationTarget.Kind.METHOD)) {
                ClassInfo classInfo = annotationInstance.target().asMethod().declaringClass();
                applications.add(classInfo);
                continue;
            }
            VertxLogging.log.ignoringAnnotation(VertxConstants.ROUTE.withoutPackagePrefix());
        }
        this.processScannerExtensions(context, applications);
        for (ClassInfo controller : applications) {
            OpenAPI applicationOpenApi = this.processRouteClass(context, controller);
            openApi = MergeUtil.merge((OpenAPI)openApi, (OpenAPI)applicationOpenApi);
        }
    }

    private OpenAPI processRouteClass(AnnotationScannerContext context, ClassInfo routeClass) {
        VertxLogging.log.processingRouteClass(routeClass.simpleName());
        TypeResolver resolver = TypeResolver.forClass((AnnotationScannerContext)context, (ClassInfo)routeClass, null);
        context.getResolverStack().push(resolver);
        OpenAPIImpl openApi = new OpenAPIImpl();
        openApi.setOpenapi("3.0.3");
        AnnotationInstance routeBaseAnnotation = Annotations.getAnnotation((AnnotationTarget)routeClass, (DotName)VertxConstants.ROUTE_BASE);
        this.currentAppPath = routeBaseAnnotation != null ? routeBaseAnnotation.value("path").asString() : "/";
        this.processDefinitionAnnotation(context, routeClass, (OpenAPI)openApi);
        this.processSecuritySchemeAnnotation(context, routeClass, (OpenAPI)openApi);
        this.processServerAnnotation(context, routeClass, (OpenAPI)openApi);
        this.processJavaSecurity(context, routeClass, (OpenAPI)openApi);
        this.processRouteMethods(context, routeClass, (OpenAPI)openApi, null);
        context.getResolverStack().pop();
        return openApi;
    }

    private void processRouteMethods(AnnotationScannerContext context, ClassInfo resourceClass, OpenAPI openApi, List<Parameter> locatorPathParameters) {
        Set tagRefs = this.processTags(context, (AnnotationTarget)resourceClass, openApi, false);
        this.getResourceMethods(context, resourceClass).stream().filter(m -> m.hasAnnotation(VertxConstants.ROUTE)).filter(this::shouldScan).forEach(methodInfo -> Optional.ofNullable((String[])Annotations.getAnnotationValue((AnnotationTarget)methodInfo, (DotName)VertxConstants.ROUTE, (String)"methods")).map(methods -> Arrays.stream(methods).map(PathItem.HttpMethod::valueOf)).orElseGet(() -> Arrays.stream(PathItem.HttpMethod.values())).forEach(httpMethod -> this.processRouteMethod(context, resourceClass, (MethodInfo)methodInfo, (PathItem.HttpMethod)httpMethod, openApi, tagRefs, locatorPathParameters)));
    }

    private void processRouteMethod(AnnotationScannerContext context, ClassInfo resourceClass, MethodInfo method, PathItem.HttpMethod methodType, OpenAPI openApi, Set<String> resourceTags, List<Parameter> locatorPathParameters) {
        VertxLogging.log.processingMethod(method.toString());
        String[] defaultConsumes = this.getDefaultConsumes(context, method);
        context.setCurrentConsumes((String[])VertxAnnotationScanner.getMediaTypes(method, "consumes", defaultConsumes).orElse(null));
        String[] defaultProduces = this.getDefaultProduces(context, method);
        context.setCurrentProduces((String[])VertxAnnotationScanner.getMediaTypes(method, "produces", defaultProduces).orElse(null));
        Optional maybeOperation = this.processOperation(context, resourceClass, method);
        if (!maybeOperation.isPresent()) {
            return;
        }
        Operation operation = (Operation)maybeOperation.get();
        this.processOperationTags(context, method, openApi, resourceTags, operation);
        PathItemImpl pathItem = new PathItemImpl();
        Function<AnnotationInstance, Parameter> reader = t -> ParameterReader.readParameter((AnnotationScannerContext)context, (AnnotationInstance)t);
        ResourceParameters params = VertxParameterProcessor.process(context, this.currentAppPath, resourceClass, method, reader, context.getExtensions());
        operation.setParameters(params.getOperationParameters());
        pathItem.setParameters(ListUtil.mergeNullableLists((List[])new List[]{locatorPathParameters, params.getPathItemParameters()}));
        RequestBody requestBody = this.processRequestBody(context, method, params);
        if (requestBody != null) {
            operation.setRequestBody(requestBody);
        }
        this.processResponse(context, resourceClass, method, operation, null);
        this.processSecurityRequirementAnnotation(resourceClass, method, operation);
        this.processCallback(context, method, operation);
        this.processServerAnnotation(context, method, operation);
        this.processExtensions(context, method, operation);
        context.getJavaSecurityProcessor().processSecurityRoles(method, operation);
        this.setOperationOnPathItem(methodType, (PathItem)pathItem, operation);
        if (!VertxAnnotationScanner.processProfiles((OpenApiConfig)context.getConfig(), (Extensible)operation)) {
            return;
        }
        String path = super.makePath(params.getOperationPath());
        PathItem existingPath = ModelUtil.paths((OpenAPI)openApi).getPathItem(path);
        if (existingPath == null) {
            ModelUtil.paths((OpenAPI)openApi).addPathItem(path, (PathItem)pathItem);
        } else {
            MergeUtil.mergeObjects((Object)existingPath, (Object)pathItem);
        }
    }

    boolean shouldScan(MethodInfo resourceMethod) {
        AnnotationInstance route = resourceMethod.annotation(VertxConstants.ROUTE);
        if ("FAILURE".equals(Annotations.value((AnnotationInstance)route, (String)"type"))) {
            return false;
        }
        if (Annotations.value((AnnotationInstance)route, (String)"regex") != null) {
            return resourceMethod.hasAnnotation(OperationConstant.DOTNAME_OPERATION);
        }
        return true;
    }

    static Optional<String[]> getMediaTypes(MethodInfo resourceMethod, String property, String[] defaultValue) {
        DotName annotationName = VertxConstants.ROUTE;
        AnnotationInstance annotation = resourceMethod.annotation(annotationName);
        if (annotation == null || annotation.value(property) == null) {
            annotation = Annotations.getAnnotation((AnnotationTarget)resourceMethod.declaringClass(), (DotName)VertxConstants.ROUTE_BASE);
        }
        if (annotation != null) {
            AnnotationValue annotationValue = annotation.value(property);
            if (annotationValue != null) {
                return Optional.of(annotationValue.asStringArray());
            }
            return Optional.of(defaultValue);
        }
        return Optional.empty();
    }
}

