package io.vertx.mutiny.ext.web.sstore;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * A session store which stores sessions in a distributed map so they are available across the cluster.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.sstore.ClusteredSessionStore original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.sstore.ClusteredSessionStore.class)
public class ClusteredSessionStore extends io.vertx.mutiny.ext.web.sstore.SessionStore {

  public static final io.smallrye.mutiny.vertx.TypeArg<ClusteredSessionStore> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new ClusteredSessionStore((io.vertx.ext.web.sstore.ClusteredSessionStore) obj),
    ClusteredSessionStore::getDelegate
  );

  private final io.vertx.ext.web.sstore.ClusteredSessionStore delegate;
  
  public ClusteredSessionStore(io.vertx.ext.web.sstore.ClusteredSessionStore delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public ClusteredSessionStore(Object delegate) {
    super((io.vertx.ext.web.sstore.ClusteredSessionStore)delegate);
    this.delegate = (io.vertx.ext.web.sstore.ClusteredSessionStore)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  ClusteredSessionStore() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.ext.web.sstore.ClusteredSessionStore getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClusteredSessionStore that = (ClusteredSessionStore) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx the Vert.x instance
   * @param sessionMapName the session map name
   * @return the session store
   */
  public static io.vertx.mutiny.ext.web.sstore.ClusteredSessionStore create(io.vertx.mutiny.core.Vertx vertx, String sessionMapName) { 
    io.vertx.mutiny.ext.web.sstore.ClusteredSessionStore ret = io.vertx.mutiny.ext.web.sstore.ClusteredSessionStore.newInstance((io.vertx.ext.web.sstore.ClusteredSessionStore)io.vertx.ext.web.sstore.ClusteredSessionStore.create(vertx.getDelegate(), sessionMapName));
    return ret;
  }

  /**
   * @param vertx the Vert.x instance
   * @param sessionMapName the session map name
   * @param retryTimeout the store retry timeout, in ms
   * @return the session store
   */
  public static io.vertx.mutiny.ext.web.sstore.ClusteredSessionStore create(io.vertx.mutiny.core.Vertx vertx, String sessionMapName, long retryTimeout) { 
    io.vertx.mutiny.ext.web.sstore.ClusteredSessionStore ret = io.vertx.mutiny.ext.web.sstore.ClusteredSessionStore.newInstance((io.vertx.ext.web.sstore.ClusteredSessionStore)io.vertx.ext.web.sstore.ClusteredSessionStore.create(vertx.getDelegate(), sessionMapName, retryTimeout));
    return ret;
  }

  /**
   * @param vertx the Vert.x instance
   * @return the session store
   */
  public static io.vertx.mutiny.ext.web.sstore.ClusteredSessionStore create(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.web.sstore.ClusteredSessionStore ret = io.vertx.mutiny.ext.web.sstore.ClusteredSessionStore.newInstance((io.vertx.ext.web.sstore.ClusteredSessionStore)io.vertx.ext.web.sstore.ClusteredSessionStore.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param vertx the Vert.x instance
   * @param retryTimeout the store retry timeout, in ms
   * @return the session store
   */
  public static io.vertx.mutiny.ext.web.sstore.ClusteredSessionStore create(io.vertx.mutiny.core.Vertx vertx, long retryTimeout) { 
    io.vertx.mutiny.ext.web.sstore.ClusteredSessionStore ret = io.vertx.mutiny.ext.web.sstore.ClusteredSessionStore.newInstance((io.vertx.ext.web.sstore.ClusteredSessionStore)io.vertx.ext.web.sstore.ClusteredSessionStore.create(vertx.getDelegate(), retryTimeout));
    return ret;
  }

  /**
   * Default length for a session id.
   * More info: https://www.owasp.org/index.php/Session_Management_Cheat_Sheet
   */
  public static final int DEFAULT_SESSIONID_LENGTH = io.vertx.ext.web.sstore.ClusteredSessionStore.DEFAULT_SESSIONID_LENGTH;
  /**
   * The default name used for the session map
   */
  public static final String DEFAULT_SESSION_MAP_NAME = io.vertx.ext.web.sstore.ClusteredSessionStore.DEFAULT_SESSION_MAP_NAME;
  /**
   * Default retry time out, in ms, for a session not found in this store.
   */
  public static final long DEFAULT_RETRY_TIMEOUT = io.vertx.ext.web.sstore.ClusteredSessionStore.DEFAULT_RETRY_TIMEOUT;
  public static  ClusteredSessionStore newInstance(io.vertx.ext.web.sstore.ClusteredSessionStore arg) {
    return arg != null ? new ClusteredSessionStore(arg) : null;
  }

}
