package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Handler;

/**
 * This handler adds a CSRF token to requests which mutate state. In order change the state a (XSRF-TOKEN) cookie is set
 * with a unique token, that is expected to be sent back in a (X-XSRF-TOKEN) header.
 *
 * The behavior is to check the request body header and cookie for validity.
 *
 * This Handler requires session support, thus should be added somewhere below Session and Body handlers.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.CSRFHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.CSRFHandler.class)
public class CSRFHandler implements io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  public static final io.smallrye.mutiny.vertx.TypeArg<CSRFHandler> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new CSRFHandler((io.vertx.ext.web.handler.CSRFHandler) obj),
    CSRFHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.CSRFHandler delegate;
  
  public CSRFHandler(io.vertx.ext.web.handler.CSRFHandler delegate) {
    this.delegate = delegate;
  }

  public CSRFHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.CSRFHandler)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  CSRFHandler() {
    this.delegate = null;
  }

  public io.vertx.ext.web.handler.CSRFHandler getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CSRFHandler that = (CSRFHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * @param vertx 
   * @param secret server secret to sign the token.
   * @return 
   */
  public static io.vertx.mutiny.ext.web.handler.CSRFHandler create(io.vertx.mutiny.core.Vertx vertx, String secret) { 
    io.vertx.mutiny.ext.web.handler.CSRFHandler ret = io.vertx.mutiny.ext.web.handler.CSRFHandler.newInstance((io.vertx.ext.web.handler.CSRFHandler)io.vertx.ext.web.handler.CSRFHandler.create(vertx.getDelegate(), secret));
    return ret;
  }

  /**
   * @param origin the origin for this server e.g.: <code>https://www.foo.com</code>.
   * @return fluent
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.CSRFHandler setOrigin(String origin) { 
    delegate.setOrigin(origin);
    return this;
  }

  /**
   * @param name a new name for the cookie.
   * @return fluent
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.CSRFHandler setCookieName(String name) { 
    delegate.setCookieName(name);
    return this;
  }

  /**
   * @param path a new path for the cookie.
   * @return fluent
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.CSRFHandler setCookiePath(String path) { 
    delegate.setCookiePath(path);
    return this;
  }

  /**
   * @param httpOnly a new name for the header.
   * @return fluent
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.CSRFHandler setCookieHttpOnly(boolean httpOnly) { 
    delegate.setCookieHttpOnly(httpOnly);
    return this;
  }

  /**
   * @param name a new name for the header.
   * @return fluent
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.CSRFHandler setHeaderName(String name) { 
    delegate.setHeaderName(name);
    return this;
  }

  /**
   * @param nag true to nag
   * @return fluent
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.CSRFHandler setNagHttps(boolean nag) { 
    delegate.setNagHttps(nag);
    return this;
  }

  /**
   * @param timeout token timeout
   * @return fluent
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.CSRFHandler setTimeout(long timeout) { 
    delegate.setTimeout(timeout);
    return this;
  }

  public static final String DEFAULT_COOKIE_NAME = io.vertx.ext.web.handler.CSRFHandler.DEFAULT_COOKIE_NAME;
  public static final String DEFAULT_COOKIE_PATH = io.vertx.ext.web.handler.CSRFHandler.DEFAULT_COOKIE_PATH;
  public static final String DEFAULT_HEADER_NAME = io.vertx.ext.web.handler.CSRFHandler.DEFAULT_HEADER_NAME;
  public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  CSRFHandler newInstance(io.vertx.ext.web.handler.CSRFHandler arg) {
    return arg != null ? new CSRFHandler(arg) : null;
  }

}
