package io.vertx.mutiny.ext.web.multipart;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * A form data part of a {@link io.vertx.mutiny.ext.web.multipart.MultipartForm}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.multipart.FormDataPart original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.multipart.FormDataPart.class)
public class FormDataPart implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<FormDataPart> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new FormDataPart((io.vertx.ext.web.multipart.FormDataPart) obj),
    FormDataPart::getDelegate
  );

  private final io.vertx.ext.web.multipart.FormDataPart delegate;
  
  public FormDataPart(io.vertx.ext.web.multipart.FormDataPart delegate) {
    this.delegate = delegate;
  }

  public FormDataPart(Object delegate) {
    this.delegate = (io.vertx.ext.web.multipart.FormDataPart)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  FormDataPart() {
    this.delegate = null;
  }

  @Override
  public io.vertx.ext.web.multipart.FormDataPart getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FormDataPart that = (FormDataPart) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the name
   */
  public String name() { 
    if (cached_0 != null) {
      return cached_0;
    }
    String ret = delegate.name();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return <code>true</code> when this part is an attribute
   */
  public boolean isAttribute() { 
    if (cached_1 != null) {
      return cached_1;
    }
    boolean ret = delegate.isAttribute();
    cached_1 = ret;
    return ret;
  }

  /**
   * @return <code>true</code> when this part is a file upload
   */
  public boolean isFileUpload() { 
    if (cached_2 != null) {
      return cached_2;
    }
    boolean ret = delegate.isFileUpload();
    cached_2 = ret;
    return ret;
  }

  /**
   * @return the value when the part for a form attribute otherwise <code>null</code>
   */
  public String value() { 
    if (cached_3 != null) {
      return cached_3;
    }
    String ret = delegate.value();
    cached_3 = ret;
    return ret;
  }

  /**
   * @return the filename when this part is a file upload otherwise <code>null</code>
   */
  public String filename() { 
    if (cached_4 != null) {
      return cached_4;
    }
    String ret = delegate.filename();
    cached_4 = ret;
    return ret;
  }

  /**
   * @return the pathname when this part is a file upload created with a pathname otherwise <code>null</code>
   */
  public String pathname() { 
    if (cached_5 != null) {
      return cached_5;
    }
    String ret = delegate.pathname();
    cached_5 = ret;
    return ret;
  }

  /**
   * @return the content when this part is a file upload created with a buffer otherwise <code>null</code>
   */
  public io.vertx.mutiny.core.buffer.Buffer content() { 
    if (cached_6 != null) {
      return cached_6;
    }
    io.vertx.mutiny.core.buffer.Buffer ret = io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.content());
    cached_6 = ret;
    return ret;
  }

  /**
   * @return the media type when this part is a file upload otherwise <code>null</code>
   */
  public String mediaType() { 
    if (cached_7 != null) {
      return cached_7;
    }
    String ret = delegate.mediaType();
    cached_7 = ret;
    return ret;
  }

  /**
   * @return whether the file upload is text or binary when this part is a file upload otherwise <code>null</code>
   */
  public Boolean isText() { 
    if (cached_8 != null) {
      return cached_8;
    }
    Boolean ret = delegate.isText();
    cached_8 = ret;
    return ret;
  }

  private String cached_0;
  private java.lang.Boolean cached_1;
  private java.lang.Boolean cached_2;
  private String cached_3;
  private String cached_4;
  private String cached_5;
  private io.vertx.mutiny.core.buffer.Buffer cached_6;
  private String cached_7;
  private Boolean cached_8;
  public static  FormDataPart newInstance(io.vertx.ext.web.multipart.FormDataPart arg) {
    return arg != null ? new FormDataPart(arg) : null;
  }

}
