package io.vertx.mutiny.ext.web.codec;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.function.Function;

/**
 * A codec for encoding and decoding HTTP bodies.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.codec.BodyCodec original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.codec.BodyCodec.class)
public class BodyCodec<T> {

  public static final io.smallrye.mutiny.vertx.TypeArg<BodyCodec> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new BodyCodec((io.vertx.ext.web.codec.BodyCodec) obj),
    BodyCodec::getDelegate
  );

  private final io.vertx.ext.web.codec.BodyCodec<T> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_0;
  
  public BodyCodec(io.vertx.ext.web.codec.BodyCodec delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public BodyCodec(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.ext.web.codec.BodyCodec)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public BodyCodec(io.vertx.ext.web.codec.BodyCodec delegate, io.smallrye.mutiny.vertx.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  BodyCodec() {
    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public io.vertx.ext.web.codec.BodyCodec getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BodyCodec that = (BodyCodec) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the UTF-8 string codec
   */
  public static io.vertx.mutiny.ext.web.codec.BodyCodec<String> string() { 
    io.vertx.mutiny.ext.web.codec.BodyCodec<String> ret = io.vertx.mutiny.ext.web.codec.BodyCodec.newInstance((io.vertx.ext.web.codec.BodyCodec)io.vertx.ext.web.codec.BodyCodec.string(), TypeArg.unknown());
    return ret;
  }

  /**
   * @param encoding the encoding
   * @return the codec
   */
  public static io.vertx.mutiny.ext.web.codec.BodyCodec<String> string(String encoding) { 
    io.vertx.mutiny.ext.web.codec.BodyCodec<String> ret = io.vertx.mutiny.ext.web.codec.BodyCodec.newInstance((io.vertx.ext.web.codec.BodyCodec)io.vertx.ext.web.codec.BodyCodec.string(encoding), TypeArg.unknown());
    return ret;
  }

  /**
   * @return the  codec
   */
  public static io.vertx.mutiny.ext.web.codec.BodyCodec<io.vertx.mutiny.core.buffer.Buffer> buffer() { 
    io.vertx.mutiny.ext.web.codec.BodyCodec<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.codec.BodyCodec.newInstance((io.vertx.ext.web.codec.BodyCodec)io.vertx.ext.web.codec.BodyCodec.buffer(), TYPE_ARG_0);
    return ret;
  }

  /**
   * @return the  codec
   */
  public static io.vertx.mutiny.ext.web.codec.BodyCodec<JsonObject> jsonObject() { 
    io.vertx.mutiny.ext.web.codec.BodyCodec<JsonObject> ret = io.vertx.mutiny.ext.web.codec.BodyCodec.newInstance((io.vertx.ext.web.codec.BodyCodec)io.vertx.ext.web.codec.BodyCodec.jsonObject(), TypeArg.unknown());
    return ret;
  }

  /**
   * @return the  codec
   */
  public static io.vertx.mutiny.ext.web.codec.BodyCodec<JsonArray> jsonArray() { 
    io.vertx.mutiny.ext.web.codec.BodyCodec<JsonArray> ret = io.vertx.mutiny.ext.web.codec.BodyCodec.newInstance((io.vertx.ext.web.codec.BodyCodec)io.vertx.ext.web.codec.BodyCodec.jsonArray(), TypeArg.unknown());
    return ret;
  }

  /**
   * @param type 
   * @return a codec for mapping POJO to Json
   */
  public static <U> io.vertx.mutiny.ext.web.codec.BodyCodec<U> json(java.lang.Class<U> type) { 
    io.vertx.mutiny.ext.web.codec.BodyCodec<U> ret = io.vertx.mutiny.ext.web.codec.BodyCodec.newInstance((io.vertx.ext.web.codec.BodyCodec)io.vertx.ext.web.codec.BodyCodec.json(io.smallrye.mutiny.vertx.MutinyHelper.unwrap(type)), io.smallrye.mutiny.vertx.TypeArg.of(type));
    return ret;
  }

  /**
   * @return a codec that simply discards the response
   */
  public static io.vertx.mutiny.ext.web.codec.BodyCodec<Void> none() { 
    io.vertx.mutiny.ext.web.codec.BodyCodec<Void> ret = io.vertx.mutiny.ext.web.codec.BodyCodec.newInstance((io.vertx.ext.web.codec.BodyCodec)io.vertx.ext.web.codec.BodyCodec.none(), TypeArg.unknown());
    return ret;
  }

  /**
   * @param decode the decode function
   * @return the created codec
   */
  public static <T> io.vertx.mutiny.ext.web.codec.BodyCodec<T> create(Function<io.vertx.mutiny.core.buffer.Buffer, T> decode) { 
    io.vertx.mutiny.ext.web.codec.BodyCodec<T> ret = io.vertx.mutiny.ext.web.codec.BodyCodec.newInstance((io.vertx.ext.web.codec.BodyCodec)io.vertx.ext.web.codec.BodyCodec.create(new java.util.function.Function<io.vertx.core.buffer.Buffer,T>() {
      public T apply(io.vertx.core.buffer.Buffer arg) {
        T ret = decode.apply(io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)arg));
        return ret;
      }
    }), TypeArg.unknown());
    return ret;
  }

  /**
   * @param stream the destination stream
   * @return the body codec for a write stream
   */
  public static io.vertx.mutiny.ext.web.codec.BodyCodec<Void> pipe(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> stream) { 
    io.vertx.mutiny.ext.web.codec.BodyCodec<Void> ret = io.vertx.mutiny.ext.web.codec.BodyCodec.newInstance((io.vertx.ext.web.codec.BodyCodec)io.vertx.ext.web.codec.BodyCodec.pipe(stream.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * @param stream the destination stream
   * @param close whether the destination stream should be closed
   * @return the body codec for a write stream
   */
  public static io.vertx.mutiny.ext.web.codec.BodyCodec<Void> pipe(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> stream, boolean close) { 
    io.vertx.mutiny.ext.web.codec.BodyCodec<Void> ret = io.vertx.mutiny.ext.web.codec.BodyCodec.newInstance((io.vertx.ext.web.codec.BodyCodec)io.vertx.ext.web.codec.BodyCodec.pipe(stream.getDelegate(), close), TypeArg.unknown());
    return ret;
  }

  /**
   * @param parser the non-null JSON parser to emits the JSON object. The parser must be configured for the stream. Not e that you need to keep a reference on the parser to retrieved the JSON events.
   * @return the body codec for a write stream
   */
  public static io.vertx.mutiny.ext.web.codec.BodyCodec<Void> jsonStream(io.vertx.mutiny.core.parsetools.JsonParser parser) { 
    io.vertx.mutiny.ext.web.codec.BodyCodec<Void> ret = io.vertx.mutiny.ext.web.codec.BodyCodec.newInstance((io.vertx.ext.web.codec.BodyCodec)io.vertx.ext.web.codec.BodyCodec.jsonStream(parser.getDelegate()), TypeArg.unknown());
    return ret;
  }

  public static <T>BodyCodec<T> newInstance(io.vertx.ext.web.codec.BodyCodec arg) {
    return arg != null ? new BodyCodec<T>(arg) : null;
  }


  public static <T>BodyCodec<T> newInstance(io.vertx.ext.web.codec.BodyCodec arg, io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_T) {
    return arg != null ? new BodyCodec<T>(arg, __typeArg_T) : null;
  }

}
