/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.classloader.ClassDefiner;
import io.smallrye.config.ConfigMappingContext;
import io.smallrye.config.ConfigMappingInterface;
import io.smallrye.config.ConfigMappingMetadata;
import io.smallrye.config.ConfigMappingObject;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;

public final class ConfigMappingLoader {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final ClassValue<ConfigMappingObjectHolder> CACHE = new ClassValue<ConfigMappingObjectHolder>(){

        @Override
        protected ConfigMappingObjectHolder computeValue(Class<?> type) {
            return new ConfigMappingObjectHolder(ConfigMappingLoader.getImplementationClass(type));
        }
    };

    public static List<ConfigMappingMetadata> getConfigMappingsMetadata(Class<?> type) {
        ArrayList<ConfigMappingMetadata> mappings = new ArrayList<ConfigMappingMetadata>();
        ConfigMappingInterface configurationInterface = ConfigMappingInterface.getConfigurationInterface(type);
        mappings.add(configurationInterface);
        mappings.addAll(configurationInterface.getNested());
        return mappings;
    }

    static ConfigMappingInterface getConfigMappingInterface(Class<?> type) {
        return ConfigMappingInterface.getConfigurationInterface(type);
    }

    static <T> T configMappingObject(Class<T> interfaceType, ConfigMappingContext configMappingContext) {
        ConfigMappingObject instance;
        try {
            Constructor<? extends ConfigMappingObject> constructor = CACHE.get(interfaceType).getImplementationClass().getDeclaredConstructor(ConfigMappingContext.class);
            instance = constructor.newInstance(configMappingContext);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new InstantiationError(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            try {
                throw e.getCause();
            }
            catch (Error | RuntimeException e2) {
                throw e2;
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        }
        return interfaceType.cast(instance);
    }

    static <T> Class<? extends ConfigMappingObject> getImplementationClass(Class<T> type) {
        ConfigMappingInterface mappingMetadata = ConfigMappingInterface.getConfigurationInterface(type);
        return ConfigMappingLoader.loadClass(type, mappingMetadata);
    }

    static Class<?> loadClass(Class<?> parent, ConfigMappingMetadata configMappingMetadata) {
        try {
            return parent.getClassLoader().loadClass(configMappingMetadata.getClassName());
        }
        catch (ClassNotFoundException e) {
            return ConfigMappingLoader.defineClass(parent, configMappingMetadata.getClassName(), configMappingMetadata.getClassBytes());
        }
    }

    private static Class<?> defineClass(Class<?> parent, String className, byte[] classBytes) {
        return ClassDefiner.defineClass((MethodHandles.Lookup)LOOKUP, parent, (String)className, (byte[])classBytes);
    }

    private static final class ConfigMappingObjectHolder {
        private final Class<? extends ConfigMappingObject> implementationClass;

        ConfigMappingObjectHolder(Class<? extends ConfigMappingObject> implementationClass) {
            this.implementationClass = implementationClass;
        }

        public Class<? extends ConfigMappingObject> getImplementationClass() {
            return this.implementationClass;
        }
    }
}

