/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.Converters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Priority;

@Priority(value=3200)
public class ProfileConfigSourceInterceptor
implements ConfigSourceInterceptor {
    private static final long serialVersionUID = -6305289277993917313L;
    private final String[] profiles;

    public ProfileConfigSourceInterceptor(String profile) {
        this(profile != null ? ProfileConfigSourceInterceptor.convertProfile(profile) : new ArrayList<String>());
    }

    public ProfileConfigSourceInterceptor(List<String> profiles) {
        ArrayList<String> reverseProfiles = new ArrayList<String>(profiles);
        Collections.reverse(reverseProfiles);
        this.profiles = reverseProfiles.toArray(new String[0]);
    }

    public ProfileConfigSourceInterceptor(ConfigSourceInterceptorContext context) {
        this(ProfileConfigSourceInterceptor.convertProfile(context));
    }

    @Override
    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        String normalizeName;
        ConfigValue profileValue;
        if (this.profiles.length > 0 && (profileValue = this.getProfileValue(context, normalizeName = this.normalizeName(name))) != null) {
            try {
                ConfigValue originalValue = context.proceed(normalizeName);
                if (originalValue != null && ConfigValue.CONFIG_SOURCE_COMPARATOR.compare(originalValue, profileValue) > 0) {
                    return originalValue;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return profileValue.withName(normalizeName);
        }
        return context.proceed(name);
    }

    public ConfigValue getProfileValue(ConfigSourceInterceptorContext context, String normalizeName) {
        for (String profile : this.profiles) {
            ConfigValue profileValue = context.proceed("%" + profile + "." + normalizeName);
            if (profileValue == null) continue;
            return profileValue.withProfile(profile);
        }
        return null;
    }

    @Override
    public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
        HashSet<String> names = new HashSet<String>();
        Iterator<String> namesIterator = context.iterateNames();
        while (namesIterator.hasNext()) {
            names.add(this.normalizeName(namesIterator.next()));
        }
        return names.iterator();
    }

    @Override
    public Iterator<ConfigValue> iterateValues(ConfigSourceInterceptorContext context) {
        HashSet<ConfigValue> values = new HashSet<ConfigValue>();
        Iterator<ConfigValue> valuesIterator = context.iterateValues();
        while (valuesIterator.hasNext()) {
            ConfigValue value = valuesIterator.next();
            values.add(value.withName(this.normalizeName(value.getName())));
        }
        return values.iterator();
    }

    public String[] getProfiles() {
        return this.profiles;
    }

    private String normalizeName(String name) {
        for (String profile : this.profiles) {
            if (!name.startsWith("%" + profile + ".")) continue;
            return name.substring(profile.length() + 2);
        }
        return name;
    }

    public static List<String> convertProfile(String profile) {
        return (List)Converters.newCollectionConverter(Converters.newTrimmingConverter(Converters.STRING_CONVERTER), ArrayList::new).convert(profile);
    }

    private static List<String> convertProfile(ConfigSourceInterceptorContext context) {
        ArrayList<String> profiles = new ArrayList<String>();
        ConfigValue profile = context.proceed("smallrye.config.profile");
        if (profile != null) {
            List<String> convertedProfiles;
            ConfigValue parentProfile = context.proceed("smallrye.config.profile.parent");
            if (parentProfile != null) {
                profiles.add(parentProfile.getValue());
            }
            if ((convertedProfiles = ProfileConfigSourceInterceptor.convertProfile(profile.getValue())) != null) {
                profiles.addAll(convertedProfiles);
            }
        }
        return profiles;
    }
}

