/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.AuthenticationRedirectException;
import io.quarkus.security.ForbiddenException;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.AuthorizationController;
import io.quarkus.security.spi.runtime.AuthorizationFailureEvent;
import io.quarkus.security.spi.runtime.AuthorizationSuccessEvent;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.quarkus.security.spi.runtime.SecurityEvent;
import io.quarkus.security.spi.runtime.SecurityEventHelper;
import io.quarkus.vertx.http.runtime.security.AbstractPathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.spi.BeanManager;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

abstract class AbstractHttpAuthorizer {
    private static final Logger log = Logger.getLogger(AbstractHttpAuthorizer.class);
    private final IdentityProviderManager identityProviderManager;
    private final AuthorizationController controller;
    private final List<HttpSecurityPolicy> policies;
    private final SecurityEventHelper<AuthorizationSuccessEvent, AuthorizationFailureEvent> securityEventHelper;
    private final HttpSecurityPolicy.AuthorizationRequestContext context;

    AbstractHttpAuthorizer(IdentityProviderManager identityProviderManager, AuthorizationController controller, List<HttpSecurityPolicy> policies, BeanManager beanManager, BlockingSecurityExecutor blockingExecutor, Event<AuthorizationFailureEvent> authZFailureEvent, Event<AuthorizationSuccessEvent> authZSuccessEvent, boolean securityEventsEnabled) {
        this.identityProviderManager = identityProviderManager;
        this.controller = controller;
        this.policies = policies;
        this.context = new HttpSecurityPolicy.DefaultAuthorizationRequestContext(blockingExecutor);
        this.securityEventHelper = new SecurityEventHelper(authZSuccessEvent, authZFailureEvent, (SecurityEvent)SecurityEventHelper.AUTHORIZATION_SUCCESS, (SecurityEvent)SecurityEventHelper.AUTHORIZATION_FAILURE, beanManager, securityEventsEnabled);
    }

    public void checkPermission(final RoutingContext routingContext) {
        if (!this.controller.isAuthorizationEnabled() || this.policies.isEmpty()) {
            routingContext.next();
            return;
        }
        this.doPermissionCheck(routingContext, QuarkusHttpUser.getSecurityIdentity(routingContext, this.identityProviderManager), 0, null).subscribe().with((Consumer)new Consumer<HttpSecurityPolicy.CheckResult>(){

            @Override
            public void accept(HttpSecurityPolicy.CheckResult checkResult) {
                if (routingContext.response().ended() || routingContext.failed()) {
                    return;
                }
                if (checkResult.isPermitted()) {
                    routingContext.next();
                } else {
                    routingContext.fail((Throwable)new IllegalStateException("Received unhandled HttpSecurityPolicy.CheckResult"));
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            @Override
            public void accept(Throwable throwable) {
                if (!routingContext.response().ended() && !throwable.equals(routingContext.failure())) {
                    if (throwable instanceof DoDenyException) {
                        DoDenyException doDenyException = (DoDenyException)throwable;
                        AbstractHttpAuthorizer.this.doDeny(doDenyException.augmentedIdentityUni, routingContext, doDenyException.policyWhichForbiddenAccess, doDenyException.augmentedIdentity);
                    } else {
                        routingContext.fail(throwable);
                    }
                } else if (throwable instanceof AuthenticationFailedException) {
                    log.debug((Object)"Authentication challenge is required");
                } else if (throwable instanceof AuthenticationRedirectException) {
                    log.debugf("Completing authentication with a redirect to %s", (Object)((AuthenticationRedirectException)throwable).getRedirectUri());
                } else {
                    log.error((Object)"Exception occurred during authorization", throwable);
                }
            }
        });
    }

    private Uni<HttpSecurityPolicy.CheckResult> doPermissionCheck(RoutingContext routingContext, Uni<SecurityIdentity> identityUni, int index, SecurityIdentity identity) {
        return this.policies.get(index).checkPermission(routingContext, identityUni, this.context).onItem().transformToUni(checkResult -> {
            Uni<SecurityIdentity> augmentedIdentityUni;
            SecurityIdentity augmentedIdentity;
            if (checkResult.getAugmentedIdentity() != null) {
                augmentedIdentity = checkResult.getAugmentedIdentity();
                augmentedIdentityUni = checkResult.getAugmentedIdentityAsUni();
            } else {
                augmentedIdentity = identity;
                augmentedIdentityUni = identityUni;
            }
            if (!checkResult.isPermitted()) {
                DoDenyException failure = new DoDenyException(this.policies.get(index), augmentedIdentity, augmentedIdentityUni);
                return Uni.createFrom().failure((Throwable)failure);
            }
            if (index + 1 == this.policies.size()) {
                QuarkusHttpUser currentUser = (QuarkusHttpUser)routingContext.user();
                if (augmentedIdentity != null) {
                    if (!(augmentedIdentity.isAnonymous() || currentUser != null && currentUser.getSecurityIdentity() == augmentedIdentity)) {
                        QuarkusHttpUser.setIdentity(augmentedIdentity, routingContext);
                    }
                    if (this.securityEventHelper.fireEventOnSuccess()) {
                        this.securityEventHelper.fireSuccessEvent((SecurityEvent)new AuthorizationSuccessEvent(augmentedIdentity, Map.of(RoutingContext.class.getName(), routingContext)));
                    }
                } else if (this.securityEventHelper.fireEventOnSuccess() && AbstractHttpAuthorizer.permissionCheckPerformed(this.policies, routingContext, index)) {
                    this.securityEventHelper.fireSuccessEvent((SecurityEvent)new AuthorizationSuccessEvent(currentUser == null ? null : currentUser.getSecurityIdentity(), Map.of(RoutingContext.class.getName(), routingContext)));
                }
                return Uni.createFrom().item(checkResult);
            }
            return this.doPermissionCheck(routingContext, augmentedIdentityUni, index + 1, augmentedIdentity);
        });
    }

    private void doDeny(final SecurityIdentity identity, final RoutingContext routingContext, final HttpSecurityPolicy policy) {
        if (identity.isAnonymous()) {
            HttpAuthenticator httpAuthenticator = (HttpAuthenticator)routingContext.get(HttpAuthenticator.class.getName());
            httpAuthenticator.sendChallenge(routingContext).subscribe().withSubscriber((UniSubscriber)new UniSubscriber<Boolean>(){

                public void onSubscribe(UniSubscription subscription) {
                }

                public void onItem(Boolean item) {
                    if (!routingContext.response().ended()) {
                        routingContext.response().end();
                    }
                    AbstractHttpAuthorizer.this.fireAuthZFailureEvent(routingContext, policy, null, identity);
                }

                public void onFailure(Throwable failure) {
                    AbstractHttpAuthorizer.this.fireAuthZFailureEvent(routingContext, policy, failure, identity);
                    if (!routingContext.response().ended()) {
                        routingContext.fail(failure);
                    } else if (!(failure instanceof IOException)) {
                        log.error((Object)"Failed to send challenge", failure);
                    } else {
                        log.debug((Object)"Failed to send challenge", failure);
                    }
                }
            });
        } else {
            ForbiddenException forbiddenException = new ForbiddenException();
            this.fireAuthZFailureEvent(routingContext, policy, (Throwable)forbiddenException, identity);
            routingContext.fail((Throwable)new ForbiddenException());
        }
    }

    private void doDeny(Uni<SecurityIdentity> identity, final RoutingContext routingContext, final HttpSecurityPolicy policy, SecurityIdentity augmentedIdentity) {
        if (augmentedIdentity == null) {
            identity.subscribe().withSubscriber((UniSubscriber)new UniSubscriber<SecurityIdentity>(){

                public void onSubscribe(UniSubscription subscription) {
                }

                public void onItem(SecurityIdentity identity) {
                    AbstractHttpAuthorizer.this.doDeny(identity, routingContext, policy);
                }

                public void onFailure(Throwable failure) {
                    AbstractHttpAuthorizer.this.fireAuthZFailureEvent(routingContext, policy, failure, null);
                    routingContext.fail(failure);
                }
            });
        } else {
            this.doDeny(augmentedIdentity, routingContext, policy);
        }
    }

    private void fireAuthZFailureEvent(RoutingContext routingContext, HttpSecurityPolicy policy, Throwable failure, SecurityIdentity identity) {
        if (this.securityEventHelper.fireEventOnFailure()) {
            String context = policy != null ? policy.getClass().getName() : null;
            AuthorizationFailureEvent event = new AuthorizationFailureEvent(identity, failure, context, Map.of(RoutingContext.class.getName(), routingContext));
            this.securityEventHelper.fireFailureEvent((SecurityEvent)event);
        }
    }

    private static boolean permissionCheckPerformed(List<HttpSecurityPolicy> permissionCheckers, RoutingContext routingContext, int index) {
        if (index == 0 && permissionCheckers.get(0) instanceof AbstractPathMatchingHttpSecurityPolicy) {
            return AbstractPathMatchingHttpSecurityPolicy.policyApplied(routingContext);
        }
        return index > 0;
    }

    private static final class DoDenyException
    extends RuntimeException {
        private final HttpSecurityPolicy policyWhichForbiddenAccess;
        private final SecurityIdentity augmentedIdentity;
        private final Uni<SecurityIdentity> augmentedIdentityUni;

        private DoDenyException(HttpSecurityPolicy policyWhichForbiddenAccess, SecurityIdentity augmentedIdentity, Uni<SecurityIdentity> augmentedIdentityUni) {
            this.policyWhichForbiddenAccess = policyWhichForbiddenAccess;
            this.augmentedIdentity = augmentedIdentity;
            this.augmentedIdentityUni = augmentedIdentityUni;
        }
    }
}

