/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.attribute;

import io.quarkus.vertx.http.runtime.AccessLogConfig;
import io.quarkus.vertx.http.runtime.VertxHttpConfig;
import io.quarkus.vertx.http.runtime.attribute.ExchangeAttribute;
import io.quarkus.vertx.http.runtime.attribute.ExchangeAttributeBuilder;
import io.quarkus.vertx.http.runtime.attribute.ReadOnlyAttributeException;
import io.smallrye.config.SmallRyeConfig;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.ConfigProvider;

public class AllRequestHeadersAttribute
implements ExchangeAttribute {
    private static final String AUTHORIZATION_HEADER = String.valueOf(HttpHeaders.AUTHORIZATION).toLowerCase();
    private static final String COOKIE_HEADER = String.valueOf(HttpHeaders.COOKIE).toLowerCase();
    private final Set<String> maskedHeaders;
    private final Set<String> maskedCookies;

    AllRequestHeadersAttribute() {
        this(Set.of(), Set.of());
    }

    AllRequestHeadersAttribute(AccessLogConfig config) {
        this(config.maskedHeaders().orElse(Set.of()), config.maskedCookies().orElse(Set.of()));
    }

    AllRequestHeadersAttribute(Set<String> maskedHeaders, Set<String> maskedCookies) {
        this.maskedHeaders = AllRequestHeadersAttribute.toLowerCaseStringSet(maskedHeaders);
        this.maskedCookies = AllRequestHeadersAttribute.toLowerCaseStringSet(maskedCookies);
    }

    private static Set<String> toLowerCaseStringSet(Set<String> set) {
        return set.stream().map(String::toLowerCase).collect(Collectors.toSet());
    }

    @Override
    public String readAttribute(RoutingContext exchange) {
        return this.readAttribute(exchange.request().headers());
    }

    String readAttribute(MultiMap headers) {
        if (headers.isEmpty()) {
            return null;
        }
        StringJoiner joiner = new StringJoiner(System.lineSeparator());
        for (Map.Entry header : headers) {
            joiner.add((String)header.getKey() + ": " + this.maskHeaderValue((String)header.getKey(), (String)header.getValue()));
        }
        return joiner.toString();
    }

    String maskHeaderValue(String headerName, String headerValue) {
        if (headerValue == null) {
            return null;
        }
        String headerNameLowerCase = headerName.toLowerCase();
        if (AUTHORIZATION_HEADER.equals(headerNameLowerCase)) {
            return this.maskAuthorizationHeaderValue(headerValue);
        }
        if (COOKIE_HEADER.equals(headerNameLowerCase)) {
            return this.maskCookieHeaderValue(headerValue);
        }
        if (this.maskedHeaders.contains(headerNameLowerCase)) {
            return "...";
        }
        return headerValue;
    }

    private String maskAuthorizationHeaderValue(String headerValue) {
        String scheme;
        int idx = headerValue.indexOf(32);
        String string = scheme = idx > 0 ? headerValue.substring(0, idx) : null;
        if (scheme != null) {
            return scheme + " ...";
        }
        return "...";
    }

    private String maskCookieHeaderValue(String headerValue) {
        String cookieName;
        int idx = headerValue.indexOf(61);
        String string = cookieName = idx > 0 ? headerValue.substring(0, idx) : null;
        if (cookieName != null && this.maskedCookies.contains(cookieName.toLowerCase())) {
            return cookieName + "=...";
        }
        return headerValue;
    }

    @Override
    public void writeAttribute(RoutingContext exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Headers", newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Headers";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals("%{ALL_REQUEST_HEADERS}")) {
                return new AllRequestHeadersAttribute(Builder.getConfigMapping());
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }

        private static AccessLogConfig getConfigMapping() {
            SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
            return ((VertxHttpConfig)config.getConfigMapping(VertxHttpConfig.class)).accessLog();
        }
    }
}

