/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.ArrayDeque;
import java.util.Deque;

public class VertxInputStream
extends InputStream {
    private final VertxBlockingInput exchange;
    private boolean closed;
    private boolean finished;
    private ByteBuf pooled;
    private final long limit;

    public VertxInputStream(RoutingContext request) throws IOException {
        this.exchange = new VertxBlockingInput(request.request());
        Long limitObj = (Long)request.get("io.quarkus.max-request-size");
        this.limit = limitObj == null ? -1L : limitObj;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int read = this.read(b);
        if (read == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        this.readIntoBuffer();
        if (this.limit > 0L && this.exchange.request.bytesRead() > this.limit) {
            HttpServerResponse response = this.exchange.request.response();
            if (response.headWritten()) {
                this.exchange.request.connection().close();
                throw new IOException("Request too large");
            }
            response.setStatusCode(HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE.code());
            response.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)"close");
            response.endHandler((Handler)new Handler<Void>(){

                public void handle(Void event) {
                    ((VertxInputStream)VertxInputStream.this).exchange.request.connection().close();
                }
            });
            response.end();
            throw new IOException("Request too large");
        }
        if (this.finished) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        ByteBuf buffer = this.pooled;
        int copied = Math.min(len, buffer.readableBytes());
        buffer.readBytes(b, off, copied);
        if (!buffer.isReadable()) {
            this.pooled.release();
            this.pooled = null;
        }
        return copied;
    }

    private void readIntoBuffer() throws IOException {
        if (this.pooled == null && !this.finished) {
            this.pooled = this.exchange.readBlocking();
            if (this.pooled == null) {
                this.finished = true;
                this.pooled = null;
            }
        }
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.finished) {
            return -1;
        }
        return this.exchange.readBytesAvailable();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        this.closed = true;
        try {
            while (!this.finished) {
                this.readIntoBuffer();
                if (this.pooled == null) continue;
                this.pooled.release();
                this.pooled = null;
            }
        }
        catch (IOException | RuntimeException e) {
            throw e;
        }
        finally {
            if (this.pooled != null) {
                this.pooled.release();
                this.pooled = null;
            }
            this.finished = true;
        }
    }

    public static class VertxBlockingInput
    implements Handler<Buffer> {
        protected final HttpServerRequest request;
        protected Buffer input1;
        protected Deque<Buffer> inputOverflow;
        protected boolean waiting = false;
        protected boolean eof = false;

        public VertxBlockingInput(final HttpServerRequest request) throws IOException {
            this.request = request;
            if (!request.isEnded()) {
                request.handler((Handler)this);
                request.endHandler((Handler)new Handler<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handle(Void event) {
                        HttpConnection httpConnection = request.connection();
                        synchronized (httpConnection) {
                            eof = true;
                            if (waiting) {
                                request.connection().notify();
                            }
                        }
                        if (input1 == null) {
                            this.terminateRequest();
                        }
                    }
                });
                request.fetch(1L);
            } else {
                this.eof = true;
            }
        }

        public void terminateRequest() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ByteBuf readBlocking() throws IOException {
            HttpConnection httpConnection = this.request.connection();
            synchronized (httpConnection) {
                while (this.input1 == null && !this.eof) {
                    try {
                        if (Context.isOnEventLoopThread()) {
                            throw new IOException("Attempting a blocking read on io thread");
                        }
                        this.waiting = true;
                        this.request.connection().wait();
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException(e.getMessage());
                    }
                    finally {
                        this.waiting = false;
                    }
                }
                Buffer ret = this.input1;
                this.input1 = null;
                if (this.inputOverflow != null) {
                    this.input1 = this.inputOverflow.poll();
                    if (this.input1 == null) {
                        this.request.fetch(1L);
                    }
                } else {
                    this.request.fetch(1L);
                }
                if (ret == null) {
                    this.terminateRequest();
                }
                return ret == null ? null : ret.getByteBuf();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(Buffer event) {
            HttpConnection httpConnection = this.request.connection();
            synchronized (httpConnection) {
                if (this.input1 == null) {
                    this.input1 = event;
                } else {
                    if (this.inputOverflow == null) {
                        this.inputOverflow = new ArrayDeque<Buffer>();
                    }
                    this.inputOverflow.add(event);
                }
                if (this.waiting) {
                    this.request.connection().notifyAll();
                }
            }
        }

        public int readBytesAvailable() {
            if (this.input1 != null) {
                return this.input1.getByteBuf().readableBytes();
            }
            String length = this.request.getHeader(HttpHeaders.CONTENT_LENGTH);
            if (length == null) {
                return 0;
            }
            return Integer.parseInt(length);
        }
    }
}

