/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devconsole.spi;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.util.ArtifactInfoUtil;
import java.util.Map;

public final class DevConsoleTemplateInfoBuildItem
extends MultiBuildItem {
    private final String name;
    private final Object object;
    private final Class<?> callerClass;

    public DevConsoleTemplateInfoBuildItem(String name, Object object) {
        String callerClassName = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass().getCanonicalName();
        try {
            this.callerClass = Thread.currentThread().getContextClassLoader().loadClass(callerClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.name = name;
        this.object = object;
    }

    public Map.Entry<String, String> groupIdAndArtifactId(CurateOutcomeBuildItem curateOutcomeBuildItem) {
        return ArtifactInfoUtil.groupIdAndArtifactId(this.callerClass, (CurateOutcomeBuildItem)curateOutcomeBuildItem);
    }

    public String getName() {
        return this.name;
    }

    public Object getObject() {
        return this.object;
    }
}

