/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.runtime;

import io.quarkus.undertow.runtime.QuarkusUndertowAccount;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.vertx.VertxHttpExchange;
import io.vertx.ext.web.RoutingContext;

public class QuarkusAuthMechanism
implements AuthenticationMechanism {
    public static final QuarkusAuthMechanism INSTANCE = new QuarkusAuthMechanism();

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        VertxHttpExchange delegate = (VertxHttpExchange)exchange.getDelegate();
        RoutingContext context = (RoutingContext)delegate.getContext();
        if (context.user() != null) {
            QuarkusHttpUser user = (QuarkusHttpUser)context.user();
            securityContext.authenticationComplete((Account)new QuarkusUndertowAccount(user.getSecurityIdentity()), "Quarkus", false);
            return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(final HttpServerExchange exchange, SecurityContext securityContext) {
        VertxHttpExchange delegate = (VertxHttpExchange)exchange.getDelegate();
        RoutingContext context = (RoutingContext)delegate.getContext();
        HttpAuthenticator authenticator = (HttpAuthenticator)context.get(HttpAuthenticator.class.getName());
        if (authenticator == null) {
            exchange.setStatusCode(401);
            exchange.endExchange();
            return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(exchange.getStatusCode()));
        }
        authenticator.sendChallenge(context, new Runnable(){

            @Override
            public void run() {
                exchange.endExchange();
            }
        }).toCompletableFuture().join();
        return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(exchange.getStatusCode()));
    }
}

