/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.runtime;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.ExceptionLog;
import io.undertow.servlet.api.ExceptionHandler;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jboss.logging.Logger;

public class QuarkusExceptionHandler
implements ExceptionHandler {
    public static final String ERROR_ID = "quarkus.error.id";
    private static final String BASE_ID = UUID.randomUUID().toString() + "-";
    private static final AtomicLong ERROR_COUNT = new AtomicLong();

    public boolean handleThrowable(HttpServerExchange exchange, ServletRequest request, ServletResponse response, Throwable t) {
        String uid = BASE_ID + ERROR_COUNT.incrementAndGet();
        request.setAttribute(ERROR_ID, (Object)uid);
        ExceptionLog log = t.getClass().getAnnotation(ExceptionLog.class);
        if (log != null) {
            Logger.Level level = log.value();
            Logger.Level stackTraceLevel = log.stackTraceLevel();
            String category = log.category();
            this.handleCustomLog(exchange, t, level, stackTraceLevel, category, uid);
        } else if (t instanceof IOException) {
            UndertowLogger.REQUEST_IO_LOGGER.debugf(t, "Exception handling request %s to %s", (Object)uid, (Object)exchange.getRequestURI());
        } else {
            UndertowLogger.REQUEST_IO_LOGGER.errorf(t, "Exception handling request %s to %s", (Object)uid, (Object)exchange.getRequestURI());
        }
        return false;
    }

    private void handleCustomLog(HttpServerExchange exchange, Throwable t, Logger.Level level, Logger.Level stackTraceLevel, String category, String uid) {
        UndertowLogger logger = UndertowLogger.REQUEST_LOGGER;
        if (!category.isEmpty()) {
            logger = Logger.getLogger((String)category);
        }
        boolean stackTrace = true;
        if (stackTraceLevel.ordinal() > level.ordinal() && !logger.isEnabled(stackTraceLevel)) {
            stackTrace = false;
        }
        if (stackTrace) {
            logger.logf(level, t, "Exception handling request %s to %s", (Object)uid, (Object)exchange.getRequestURI());
        } else {
            logger.logf(level, "Exception handling request %s to %s: %s", (Object)uid, (Object)exchange.getRequestURI(), (Object)t.getMessage());
        }
    }
}

