/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.quarkus.test.common.DevServicesContext;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.common.QuarkusTestResourceConfigurableLifecycleManager;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManagerComparator;
import io.quarkus.test.common.ResourceArg;
import io.quarkus.test.common.TestClassIndexer;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;

public class TestResourceManager
implements Closeable {
    public static final String CLOSEABLE_NAME = TestResourceManager.class.getName() + ".closeable";
    private final List<TestResourceEntry> sequentialTestResourceEntries;
    private final List<TestResourceEntry> parallelTestResourceEntries;
    private final List<TestResourceEntry> allTestResourceEntries;
    private final Map<String, String> configProperties = new ConcurrentHashMap<String, String>();
    private boolean started = false;
    private boolean hasPerTestResources = false;

    public TestResourceManager(Class<?> testClass) {
        this(testClass, null, Collections.emptyList(), false);
    }

    public TestResourceManager(Class<?> testClass, Class<?> profileClass, List<TestResourceClassEntry> additionalTestResources, boolean disableGlobalTestResources) {
        this(testClass, profileClass, additionalTestResources, disableGlobalTestResources, Collections.emptyMap(), Optional.empty());
    }

    public TestResourceManager(Class<?> testClass, Class<?> profileClass, List<TestResourceClassEntry> additionalTestResources, boolean disableGlobalTestResources, final Map<String, String> devServicesProperties, final Optional<String> containerNetworkId) {
        this.parallelTestResourceEntries = new ArrayList<TestResourceEntry>();
        this.sequentialTestResourceEntries = new ArrayList<TestResourceEntry>();
        Set<TestResourceClassEntry> uniqueEntries = disableGlobalTestResources ? new HashSet<TestResourceClassEntry>(additionalTestResources) : this.getUniqueTestResourceClassEntries(testClass, profileClass, additionalTestResources);
        Set<TestResourceClassEntry> remainingUniqueEntries = this.initParallelTestResources(uniqueEntries);
        this.initSequentialTestResources(remainingUniqueEntries);
        this.allTestResourceEntries = new ArrayList<TestResourceEntry>(this.sequentialTestResourceEntries);
        this.allTestResourceEntries.addAll(this.parallelTestResourceEntries);
        DevServicesContext context = new DevServicesContext(){

            @Override
            public Map<String, String> devServicesProperties() {
                return devServicesProperties;
            }

            @Override
            public Optional<String> containerNetworkId() {
                return containerNetworkId;
            }
        };
        for (TestResourceEntry i : this.allTestResourceEntries) {
            if (!(i.getTestResource() instanceof DevServicesContext.ContextAware)) continue;
            ((DevServicesContext.ContextAware)((Object)i.getTestResource())).setIntegrationTestContext(context);
        }
    }

    public void init() {
        for (TestResourceEntry entry : this.allTestResourceEntries) {
            try {
                QuarkusTestResourceLifecycleManager testResource = entry.getTestResource();
                if (testResource instanceof QuarkusTestResourceConfigurableLifecycleManager && entry.getConfigAnnotation() != null) {
                    ((QuarkusTestResourceConfigurableLifecycleManager)testResource).init(entry.getConfigAnnotation());
                    continue;
                }
                testResource.init(entry.getArgs());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable initialize test resource " + entry.getTestResource(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> start() {
        this.started = true;
        ConcurrentHashMap<String, String> allProps = new ConcurrentHashMap<String, String>();
        int taskSize = this.parallelTestResourceEntries.size() + 1;
        ExecutorService executor = Executors.newFixedThreadPool(taskSize);
        ArrayList<TestResourceEntryRunnable> tasks = new ArrayList<TestResourceEntryRunnable>(taskSize);
        for (TestResourceEntry entry : this.parallelTestResourceEntries) {
            tasks.add(new TestResourceEntryRunnable(entry, allProps));
        }
        tasks.add(new TestResourceEntryRunnable(this.sequentialTestResourceEntries, allProps));
        try {
            CompletableFuture.allOf((CompletableFuture[])tasks.stream().map(task -> CompletableFuture.runAsync(task, executor)).toArray(CompletableFuture[]::new)).join();
        }
        finally {
            executor.shutdown();
        }
        this.configProperties.putAll(allProps);
        return allProps;
    }

    public void inject(Object testInstance) {
        for (TestResourceEntry entry : this.allTestResourceEntries) {
            QuarkusTestResourceLifecycleManager quarkusTestResourceLifecycleManager = entry.getTestResource();
            quarkusTestResourceLifecycleManager.inject(testInstance);
            quarkusTestResourceLifecycleManager.inject(new DefaultTestInjector(testInstance));
        }
    }

    @Override
    public void close() {
        if (!this.started) {
            return;
        }
        this.started = false;
        for (TestResourceEntry entry : this.allTestResourceEntries) {
            try {
                entry.getTestResource().stop();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to stop Quarkus test resource " + entry.getTestResource(), e);
            }
        }
        try {
            ConfigProviderResolver cpr = ConfigProviderResolver.instance();
            cpr.releaseConfig(cpr.getConfig());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.configProperties.clear();
    }

    public Map<String, String> getConfigProperties() {
        return this.configProperties;
    }

    private Set<TestResourceClassEntry> initParallelTestResources(Set<TestResourceClassEntry> uniqueEntries) {
        LinkedHashSet<TestResourceClassEntry> remainingUniqueEntries = new LinkedHashSet<TestResourceClassEntry>(uniqueEntries);
        for (TestResourceClassEntry entry : uniqueEntries) {
            if (!entry.isParallel()) continue;
            TestResourceEntry testResourceEntry = this.buildTestResourceEntry(entry);
            this.parallelTestResourceEntries.add(testResourceEntry);
            remainingUniqueEntries.remove(entry);
        }
        this.parallelTestResourceEntries.sort(new Comparator<TestResourceEntry>(){
            private final QuarkusTestResourceLifecycleManagerComparator lifecycleManagerComparator = new QuarkusTestResourceLifecycleManagerComparator();

            @Override
            public int compare(TestResourceEntry o1, TestResourceEntry o2) {
                return this.lifecycleManagerComparator.compare(o1.getTestResource(), o2.getTestResource());
            }
        });
        return remainingUniqueEntries;
    }

    private Set<TestResourceClassEntry> initSequentialTestResources(Set<TestResourceClassEntry> uniqueEntries) {
        TestResourceEntry testResourceEntry;
        LinkedHashSet<TestResourceClassEntry> remainingUniqueEntries = new LinkedHashSet<TestResourceClassEntry>(uniqueEntries);
        for (TestResourceClassEntry entry : uniqueEntries) {
            if (entry.isParallel()) continue;
            testResourceEntry = this.buildTestResourceEntry(entry);
            this.sequentialTestResourceEntries.add(testResourceEntry);
            remainingUniqueEntries.remove(entry);
        }
        for (QuarkusTestResourceLifecycleManager quarkusTestResourceLifecycleManager : ServiceLoader.load(QuarkusTestResourceLifecycleManager.class, Thread.currentThread().getContextClassLoader())) {
            testResourceEntry = new TestResourceEntry(quarkusTestResourceLifecycleManager);
            this.sequentialTestResourceEntries.add(testResourceEntry);
        }
        this.sequentialTestResourceEntries.sort(new Comparator<TestResourceEntry>(){
            private final QuarkusTestResourceLifecycleManagerComparator lifecycleManagerComparator = new QuarkusTestResourceLifecycleManagerComparator();

            @Override
            public int compare(TestResourceEntry o1, TestResourceEntry o2) {
                return this.lifecycleManagerComparator.compare(o1.getTestResource(), o2.getTestResource());
            }
        });
        return remainingUniqueEntries;
    }

    private TestResourceEntry buildTestResourceEntry(TestResourceClassEntry entry) {
        Class<? extends QuarkusTestResourceLifecycleManager> testResourceClass = entry.clazz;
        try {
            return new TestResourceEntry(testResourceClass.getConstructor(new Class[0]).newInstance(new Object[0]), entry.args, entry.configAnnotation);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Unable to instantiate the test resource " + testResourceClass.getName(), e);
        }
    }

    private Set<TestResourceClassEntry> getUniqueTestResourceClassEntries(Class<?> testClass, Class<?> profileClass, List<TestResourceClassEntry> additionalTestResources) {
        Class<?> profileClassFromTCCL;
        Class<?> testClassFromTCCL;
        Index index = TestClassIndexer.readIndex(testClass);
        LinkedHashSet<TestResourceClassEntry> uniqueEntries = new LinkedHashSet<TestResourceClassEntry>();
        try {
            testClassFromTCCL = Class.forName(testClass.getName(), false, Thread.currentThread().getContextClassLoader());
            profileClassFromTCCL = profileClass != null ? Class.forName(profileClass.getName(), false, Thread.currentThread().getContextClassLoader()) : null;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.collectMetaAnnotations(testClassFromTCCL, uniqueEntries);
        if (profileClassFromTCCL != null) {
            this.collectMetaAnnotations(profileClassFromTCCL, uniqueEntries);
        }
        for (AnnotationInstance annotation : this.findQuarkusTestResourceInstances(testClass, (IndexView)index)) {
            try {
                AnnotationValue restrict;
                Map<String, String> args;
                Class<? extends QuarkusTestResourceLifecycleManager> testResourceClass = this.loadTestResourceClassFromTCCL(annotation.value().asString());
                AnnotationValue argsAnnotationValue = annotation.value("initArgs");
                if (argsAnnotationValue == null) {
                    args = Collections.emptyMap();
                } else {
                    AnnotationInstance[] resourceArgsInstances;
                    args = new HashMap();
                    for (AnnotationInstance resourceArgsInstance : resourceArgsInstances = argsAnnotationValue.asNestedArray()) {
                        args.put(resourceArgsInstance.value("name").asString(), resourceArgsInstance.value().asString());
                    }
                }
                boolean isParallel = false;
                AnnotationValue parallelAnnotationValue = annotation.value("parallel");
                if (parallelAnnotationValue != null) {
                    isParallel = parallelAnnotationValue.asBoolean();
                }
                if ((restrict = annotation.value("restrictToAnnotatedClass")) != null && restrict.asBoolean()) {
                    this.hasPerTestResources = true;
                }
                uniqueEntries.add(new TestResourceClassEntry(testResourceClass, args, null, isParallel));
            }
            catch (IllegalArgumentException | SecurityException e) {
                throw new RuntimeException("Unable to instantiate the test resource " + annotation.value().asString(), e);
            }
        }
        uniqueEntries.addAll(additionalTestResources);
        return uniqueEntries;
    }

    private void collectMetaAnnotations(Class<?> testClassFromTCCL, Set<TestResourceClassEntry> uniqueEntries) {
        while (!testClassFromTCCL.getName().equals("java.lang.Object")) {
            block1: for (Annotation metaAnnotation : testClassFromTCCL.getAnnotations()) {
                for (Annotation ann : metaAnnotation.annotationType().getAnnotations()) {
                    if (ann.annotationType() == QuarkusTestResource.class) {
                        this.addTestResourceEntry((QuarkusTestResource)ann, metaAnnotation, uniqueEntries);
                        this.hasPerTestResources = true;
                        continue block1;
                    }
                    if (ann.annotationType() != QuarkusTestResource.List.class) continue;
                    for (QuarkusTestResource quarkusTestResource : ((QuarkusTestResource.List)ann).value()) {
                        this.addTestResourceEntry(quarkusTestResource, metaAnnotation, uniqueEntries);
                    }
                    this.hasPerTestResources = true;
                    continue block1;
                }
            }
            testClassFromTCCL = testClassFromTCCL.getSuperclass();
        }
    }

    private void addTestResourceEntry(QuarkusTestResource quarkusTestResource, Annotation originalAnnotation, Set<TestResourceClassEntry> uniqueEntries) {
        Map<String, String> args;
        Class<? extends QuarkusTestResourceLifecycleManager> testResourceClass = quarkusTestResource.value();
        ResourceArg[] argsAnnotationValue = quarkusTestResource.initArgs();
        if (argsAnnotationValue.length == 0) {
            args = Collections.emptyMap();
        } else {
            args = new HashMap();
            for (ResourceArg arg : argsAnnotationValue) {
                args.put(arg.name(), arg.value());
            }
        }
        uniqueEntries.add(new TestResourceClassEntry(testResourceClass, args, originalAnnotation, quarkusTestResource.parallel()));
    }

    private Class<? extends QuarkusTestResourceLifecycleManager> loadTestResourceClassFromTCCL(String className) {
        try {
            return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Collection<AnnotationInstance> findQuarkusTestResourceInstances(Class<?> testClass, IndexView index) {
        HashSet<String> testClasses = new HashSet<String>();
        while (testClass != Object.class) {
            testClasses.add(testClass.getName());
            testClass = testClass.getSuperclass();
        }
        LinkedHashSet<AnnotationInstance> testResourceAnnotations = new LinkedHashSet<AnnotationInstance>();
        for (AnnotationInstance annotation : index.getAnnotations(DotName.createSimple((String)QuarkusTestResource.class.getName()))) {
            if (!this.keepTestResourceAnnotation(annotation, annotation.target().asClass(), testClasses)) continue;
            testResourceAnnotations.add(annotation);
        }
        for (AnnotationInstance annotation : index.getAnnotations(DotName.createSimple((String)QuarkusTestResource.List.class.getName()))) {
            for (AnnotationInstance nestedAnnotation : annotation.value().asNestedArray()) {
                if (!this.keepTestResourceAnnotation(nestedAnnotation, annotation.target().asClass(), testClasses)) continue;
                testResourceAnnotations.add(nestedAnnotation);
            }
        }
        return testResourceAnnotations;
    }

    public boolean hasPerTestResources() {
        return this.hasPerTestResources;
    }

    private boolean keepTestResourceAnnotation(AnnotationInstance annotation, ClassInfo targetClass, Set<String> testClasses) {
        if (targetClass.isAnnotation()) {
            return false;
        }
        AnnotationValue restrict = annotation.value("restrictToAnnotatedClass");
        if (restrict != null && restrict.asBoolean()) {
            return testClasses.contains(targetClass.name().toString('.'));
        }
        return true;
    }

    static class DefaultTestInjector
    implements QuarkusTestResourceLifecycleManager.TestInjector {
        final Object testInstance;

        private DefaultTestInjector(Object testInstance) {
            this.testInstance = testInstance;
        }

        @Override
        public void injectIntoFields(Object fieldValue, Predicate<Field> predicate) {
            for (Class<?> c = this.testInstance.getClass(); c != Object.class; c = c.getSuperclass()) {
                for (Field f : c.getDeclaredFields()) {
                    if (!predicate.test(f)) continue;
                    f.setAccessible(true);
                    try {
                        f.set(this.testInstance, fieldValue);
                        return;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to set field '" + f.getName() + "' using 'QuarkusTestResourceLifecycleManager.TestInjector' ", e);
                    }
                }
            }
        }
    }

    private static class TestResourceEntry {
        private final QuarkusTestResourceLifecycleManager testResource;
        private final Map<String, String> args;
        private final Annotation configAnnotation;

        public TestResourceEntry(QuarkusTestResourceLifecycleManager testResource) {
            this(testResource, Collections.emptyMap(), null);
        }

        public TestResourceEntry(QuarkusTestResourceLifecycleManager testResource, Map<String, String> args, Annotation configAnnotation) {
            this.testResource = testResource;
            this.args = args;
            this.configAnnotation = configAnnotation;
        }

        public QuarkusTestResourceLifecycleManager getTestResource() {
            return this.testResource;
        }

        public Map<String, String> getArgs() {
            return this.args;
        }

        public Annotation getConfigAnnotation() {
            return this.configAnnotation;
        }
    }

    private static class TestResourceEntryRunnable
    implements Runnable {
        private final List<TestResourceEntry> entries;
        private final Map<String, String> allProps;

        public TestResourceEntryRunnable(TestResourceEntry entry, Map<String, String> allProps) {
            this(Collections.singletonList(entry), allProps);
        }

        public TestResourceEntryRunnable(List<TestResourceEntry> entries, Map<String, String> allProps) {
            this.entries = entries;
            this.allProps = allProps;
        }

        @Override
        public void run() {
            for (TestResourceEntry entry : this.entries) {
                try {
                    Map<String, String> start = entry.getTestResource().start();
                    if (start == null) continue;
                    this.allProps.putAll(start);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to start Quarkus test resource " + entry.getTestResource(), e);
                }
            }
        }
    }

    public static class TestResourceClassEntry {
        private Class<? extends QuarkusTestResourceLifecycleManager> clazz;
        private Map<String, String> args;
        private boolean parallel;
        private Annotation configAnnotation;

        public TestResourceClassEntry(Class<? extends QuarkusTestResourceLifecycleManager> clazz, Map<String, String> args, Annotation configAnnotation, boolean parallel) {
            this.clazz = clazz;
            this.args = args;
            this.configAnnotation = configAnnotation;
            this.parallel = parallel;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestResourceClassEntry that = (TestResourceClassEntry)o;
            return this.clazz.equals(that.clazz) && this.args.equals(that.args) && Objects.equals(this.configAnnotation, that.configAnnotation) && this.parallel == that.parallel;
        }

        public int hashCode() {
            return Objects.hash(this.clazz, this.args, this.configAnnotation, this.parallel);
        }

        public boolean isParallel() {
            return this.parallel;
        }
    }
}

