/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.quarkus.runtime.util.ClassPathUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public final class PathTestHelper {
    private static final Map<String, String> TEST_TO_MAIN_DIR_FRAGMENTS = new HashMap<String, String>();

    private PathTestHelper() {
    }

    public static Path getTestClassesLocation(Class<?> testClass) {
        String classFileName = testClass.getName().replace('.', File.separatorChar) + ".class";
        URL resource = testClass.getClassLoader().getResource(classFileName);
        if (resource.getProtocol().equals("jar")) {
            try {
                resource = URI.create(resource.getFile().substring(0, resource.getFile().indexOf(33))).toURL();
                return PathTestHelper.toPath(resource);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to resolve the location of the JAR containing " + testClass, e);
            }
        }
        if (!PathTestHelper.isInTestDir(resource)) {
            throw new RuntimeException("The test class " + testClass + " is not located in any of the directories " + TEST_TO_MAIN_DIR_FRAGMENTS.keySet());
        }
        Path path = PathTestHelper.toPath(resource);
        return path.getRoot().resolve(path.subpath(0, path.getNameCount() - Paths.get(classFileName, new String[0]).getNameCount()));
    }

    public static Path getAppClassLocation(Class<?> testClass) {
        return PathTestHelper.getAppClassLocationForTestLocation(PathTestHelper.getTestClassesLocation(testClass).toString());
    }

    public static Path getAppClassLocationForTestLocation(String testClassLocation) {
        if (testClassLocation.endsWith(".jar")) {
            if (testClassLocation.endsWith("-tests.jar")) {
                return Paths.get(new StringBuilder().append(testClassLocation, 0, testClassLocation.length() - "-tests.jar".length()).append(".jar").toString(), new String[0]);
            }
            if (testClassLocation.contains("-rpkgtests")) {
                return Paths.get(testClassLocation.replace("-rpkgtests", ""), new String[0]);
            }
            return Paths.get(testClassLocation, new String[0]);
        }
        return TEST_TO_MAIN_DIR_FRAGMENTS.entrySet().stream().filter(e -> testClassLocation.contains((CharSequence)e.getKey())).map(e -> Paths.get(testClassLocation.replace((CharSequence)e.getKey(), (CharSequence)e.getValue()), new String[0])).findFirst().orElseThrow(() -> new IllegalStateException("Unable to translate path for " + testClassLocation));
    }

    public static Path getResourcesForClassesDirOrNull(Path classesDir, String name) {
        if (!Files.isDirectory(classesDir, new LinkOption[0])) {
            return null;
        }
        Path p = classesDir.getParent();
        if (p == null) {
            return null;
        }
        if ((p = p.getParent()) == null) {
            return null;
        }
        if ((p = p.getParent()) == null) {
            return null;
        }
        if (Files.exists(p = p.resolve("resources").resolve(name), new LinkOption[0])) {
            return p;
        }
        return null;
    }

    public static boolean isTestClass(String className, ClassLoader classLoader, Path testLocation) {
        String classFileName = className.replace('.', File.separatorChar) + ".class";
        URL resource = classLoader.getResource(classFileName);
        if (resource == null) {
            return false;
        }
        if (Files.isDirectory(testLocation, new LinkOption[0])) {
            return resource.getProtocol().startsWith("file") && PathTestHelper.isInTestDir(resource);
        }
        if (!resource.getProtocol().equals("jar")) {
            return false;
        }
        String path = resource.getPath();
        if (!path.startsWith("file:")) {
            return false;
        }
        path = path.substring(5, path.lastIndexOf(33));
        return testLocation.equals(Paths.get(path, new String[0]));
    }

    private static boolean isInTestDir(URL resource) {
        String path = PathTestHelper.toPath(resource).toString();
        return TEST_TO_MAIN_DIR_FRAGMENTS.keySet().stream().anyMatch(path::contains);
    }

    private static Path toPath(URL resource) {
        return ClassPathUtils.toLocalPath((URL)resource);
    }

    static {
        TEST_TO_MAIN_DIR_FRAGMENTS.put("bin" + File.separator + "test", "bin" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "java" + File.separator + "native-test", "classes" + File.separator + "java" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "java" + File.separator + "test", "classes" + File.separator + "java" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "kotlin" + File.separator + "native-test", "classes" + File.separator + "kotlin" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "kotlin" + File.separator + "test", "classes" + File.separator + "kotlin" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "scala" + File.separator + "native-test", "classes" + File.separator + "scala" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "scala" + File.separator + "test", "classes" + File.separator + "scala" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put(File.separator + "test-classes", File.separator + "classes");
    }
}

