/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment.devservices.keycloak;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.builditem.RuntimeConfigSetupCompleteBuildItem;
import io.quarkus.devconsole.spi.DevConsoleRouteBuildItem;
import io.quarkus.devconsole.spi.DevConsoleRuntimeTemplateInfoBuildItem;
import io.quarkus.devconsole.spi.DevConsoleTemplateInfoBuildItem;
import io.quarkus.oidc.deployment.OidcBuildTimeConfig;
import io.quarkus.oidc.deployment.devservices.AbstractDevConsoleProcessor;
import io.quarkus.oidc.deployment.devservices.OidcAuthorizationCodePostHandler;
import io.quarkus.oidc.deployment.devservices.OidcPasswordClientCredHandler;
import io.quarkus.oidc.deployment.devservices.OidcTestServiceHandler;
import io.quarkus.oidc.deployment.devservices.keycloak.KeycloakBuildTimeConfig;
import io.quarkus.oidc.deployment.devservices.keycloak.KeycloakDevServicesConfigBuildItem;
import io.quarkus.oidc.deployment.devservices.keycloak.KeycloakDevServicesProcessor;
import io.quarkus.oidc.runtime.OidcConfigPropertySupplier;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class KeycloakDevConsoleProcessor
extends AbstractDevConsoleProcessor {
    private static final String CONFIG_PREFIX = "quarkus.oidc.";
    private static final String CLIENT_ID_CONFIG_KEY = "quarkus.oidc.client-id";
    private static final String CLIENT_SECRET_CONFIG_KEY = "quarkus.oidc.credentials.secret";
    KeycloakBuildTimeConfig keycloakConfig;
    OidcBuildTimeConfig oidcConfig;

    @BuildStep(onlyIf={IsDevelopment.class})
    @Consume(value=RuntimeConfigSetupCompleteBuildItem.class)
    public void setConfigProperties(BuildProducer<DevConsoleTemplateInfoBuildItem> devConsoleInfo, BuildProducer<DevConsoleRuntimeTemplateInfoBuildItem> devConsoleRuntimeInfo, Optional<KeycloakDevServicesConfigBuildItem> configProps, Capabilities capabilities) {
        if (configProps.isPresent() && configProps.get().getProperties().containsKey("keycloak.url")) {
            String keycloakUrl = (String)configProps.get().getProperties().get("keycloak.url");
            String realmUrl = keycloakUrl + "/realms/" + configProps.get().getProperties().get("keycloak.realm");
            devConsoleInfo.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("keycloakAdminUrl", (Object)keycloakUrl));
            devConsoleInfo.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("keycloakUsers", configProps.get().getProperties().get("oidc.users")));
            this.produceDevConsoleTemplateItems(capabilities, devConsoleInfo, "Keycloak", (String)configProps.get().getProperties().get("quarkus.oidc.application-type"), this.oidcConfig.devui.grant.type.isPresent() ? this.oidcConfig.devui.grant.type.get().getGrantType() : this.keycloakConfig.devservices.grant.type.getGrantType(), realmUrl + "/protocol/openid-connect/auth", realmUrl + "/protocol/openid-connect/token", realmUrl + "/protocol/openid-connect/logout", true);
            devConsoleRuntimeInfo.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("clientId", (Supplier)new OidcConfigPropertySupplier(CLIENT_ID_CONFIG_KEY)));
            devConsoleRuntimeInfo.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("clientSecret", (Supplier)new OidcConfigPropertySupplier(CLIENT_SECRET_CONFIG_KEY, "")));
        }
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void invokeEndpoint(BuildProducer<DevConsoleRouteBuildItem> devConsoleRoute, Optional<KeycloakDevServicesConfigBuildItem> configProps) {
        if (configProps.isPresent() && configProps.get().getProperties().containsKey("keycloak.url")) {
            Map users = (Map)configProps.get().getProperties().get("oidc.users");
            Duration webClientTimeout = this.oidcConfig.devui.webClienTimeout.isPresent() ? this.oidcConfig.devui.webClienTimeout.get() : KeycloakDevServicesProcessor.capturedDevServicesConfiguration.webClienTimeout;
            this.produceDevConsoleRouteItems(devConsoleRoute, new OidcTestServiceHandler(KeycloakDevServicesProcessor.vertxInstance, webClientTimeout), new OidcAuthorizationCodePostHandler(KeycloakDevServicesProcessor.vertxInstance, webClientTimeout, this.oidcConfig.devui.grantOptions), new OidcPasswordClientCredHandler(KeycloakDevServicesProcessor.vertxInstance, webClientTimeout, users, this.oidcConfig.devui.grantOptions));
        }
    }
}

