/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.builder.Json;
import io.quarkus.maven.GenerateCodeMojo;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.runtime.LaunchMode;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="generate-code-tests", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class GenerateCodeTestsMojo
extends GenerateCodeMojo {
    @Parameter(property="quarkus.generate-code.serialize-test-model", defaultValue="true")
    boolean serializeTestModel;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        this.generateCode(this.getParentDirs(this.mavenProject().getTestCompileSourceRoots()), path -> this.mavenProject().addTestCompileSourceRoot(path.toString()), true);
        if (this.isTestWithNativeAgent()) {
            this.generateNativeAgentFilters();
        }
    }

    @Override
    protected boolean isSerializeTestModel() {
        return this.serializeTestModel;
    }

    private boolean isTestWithNativeAgent() {
        String value = System.getProperty("quarkus.test.integration-test-profile");
        if ("test-with-native-agent".equals(value)) {
            return true;
        }
        Object obj = this.mavenProject().getProperties().get("quarkus.test.integration-test-profile");
        return obj != null && "test-with-native-agent".equals(obj.toString());
    }

    private void generateNativeAgentFilters() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Generate native image agent filters");
        Set<String> commonExcludePackageNames = this.getCommonExcludePackageNames();
        this.generateNativeAgentFilter(commonExcludePackageNames, Path.of(this.mavenProject().getModel().getBuild().getDirectory(), "quarkus-caller-filter.json"));
        this.generateNativeAgentFilter(commonExcludePackageNames, Path.of(this.mavenProject().getModel().getBuild().getDirectory(), "quarkus-access-filter.json"));
    }

    private Collection<String> getAccessExcludePackageNames(Collection<String> commonExcludePackageNames) {
        HashSet<String> result = new HashSet<String>(commonExcludePackageNames);
        result.add("javax.crac");
        result.add("jdk.crac");
        return result;
    }

    private void generateNativeAgentFilter(Collection<String> packageNames, Path path) throws MojoExecutionException {
        Json.JsonObjectBuilder result = Json.object();
        Json.JsonArrayBuilder rules = Json.array();
        packageNames.stream().map(packageName -> Json.object().put("excludeClasses", packageName + ".**")).forEach(arg_0 -> ((Json.JsonArrayBuilder)rules).add(arg_0));
        result.put("rules", rules);
        Json.JsonArrayBuilder regexRules = Json.array();
        regexRules.add(Json.object().put("excludeClasses", ".*_Bean"));
        result.put("regexRules", regexRules);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(path.toFile(), StandardCharsets.UTF_8));){
            result.appendTo((Appendable)writer);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write quarkus native image agent caller filter to " + String.valueOf(path), (Exception)e);
        }
    }

    private Collection<ResolvedDependency> getDependencies() throws MojoExecutionException {
        Collection collection;
        block8: {
            CuratedApplication curatedApplication = this.bootstrapApplication(LaunchMode.TEST);
            try {
                collection = curatedApplication.getApplicationModel().getDependencies();
                if (curatedApplication == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (curatedApplication != null) {
                        try {
                            curatedApplication.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception any) {
                    throw new MojoExecutionException("Quarkus native image agent filter generation phase has failed", any);
                }
            }
            curatedApplication.close();
        }
        return collection;
    }

    private Set<String> getCommonExcludePackageNames() {
        HashSet<String> packageNames = new HashSet<String>();
        packageNames.add("io.netty");
        packageNames.add("io.quarkus");
        packageNames.add("io.smallrye");
        packageNames.add("io.vertx");
        packageNames.add("jakarta");
        packageNames.add("org.jboss");
        return packageNames;
    }
}

