/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.spi;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class KubernetesDeploymentTargetBuildItem
extends MultiBuildItem
implements Comparable<KubernetesDeploymentTargetBuildItem> {
    public static final int VANILLA_KUBERNETES_PRIORITY = Integer.MIN_VALUE;
    public static final int DEFAULT_PRIORITY = 0;
    private final String name;
    private final String kind;
    private final String group;
    private final String version;
    private final int priority;
    private final boolean enabled;

    public KubernetesDeploymentTargetBuildItem(String name, String kind, String group, String version) {
        this(name, kind, group, version, 0, false);
    }

    public KubernetesDeploymentTargetBuildItem(String name, String kind, String group, String version, boolean enabled) {
        this(name, kind, group, version, 0, enabled);
    }

    public KubernetesDeploymentTargetBuildItem(String name, String kind, String group, String version, int priority, boolean enabled) {
        this.name = Objects.requireNonNull(name, "'name' must not be null");
        this.kind = Objects.requireNonNull(kind, "'kind' must not be null");
        this.version = Objects.requireNonNull(version, "'version' must not be null");
        this.group = group;
        this.priority = priority;
        this.enabled = enabled;
    }

    public String getGroup() {
        return this.group;
    }

    public String getVersion() {
        return this.version;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean nameAndKindMatch(KubernetesDeploymentTargetBuildItem other) {
        return this.name.equals(other.getName()) && this.kind.equals(other.getKind());
    }

    public boolean nameAndKindMatchButNotEquals(KubernetesDeploymentTargetBuildItem other) {
        return !this.equals(other) && this.nameAndKindMatch(other);
    }

    public Map.Entry<String, String> nameToKindEntry() {
        return new AbstractMap.SimpleEntry<String, String>(this.name, this.kind);
    }

    private KubernetesDeploymentTargetBuildItem merge(KubernetesDeploymentTargetBuildItem other) {
        if (!this.nameAndKindMatch(other)) {
            throw new IllegalArgumentException("Merging of KubernetesDeploymentTargetBuildItem having different 'name' or 'kind' fields is not allowed.");
        }
        return new KubernetesDeploymentTargetBuildItem(this.name, this.kind, this.group, this.version, Math.max(this.priority, other.getPriority()), this.enabled || other.isEnabled());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KubernetesDeploymentTargetBuildItem that = (KubernetesDeploymentTargetBuildItem)o;
        return this.priority == that.priority && this.enabled == that.enabled && this.name.equals(that.name) && this.kind.equals(that.kind) && this.version.equals(that.version);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.kind, this.version, this.priority, this.enabled);
    }

    public static List<KubernetesDeploymentTargetBuildItem> mergeList(List<KubernetesDeploymentTargetBuildItem> input) {
        ArrayList<KubernetesDeploymentTargetBuildItem> result = new ArrayList<KubernetesDeploymentTargetBuildItem>(input.size());
        HashSet<Map.Entry<String, String>> alreadyProcessedNameKindPairs = new HashSet<Map.Entry<String, String>>();
        for (KubernetesDeploymentTargetBuildItem candidate : input) {
            Map.Entry<String, String> nameToKindEntry = candidate.nameToKindEntry();
            if (alreadyProcessedNameKindPairs.contains(nameToKindEntry)) continue;
            List nameAndKindMatchButNotEqual = input.stream().filter(i -> i.nameAndKindMatchButNotEquals(candidate)).collect(Collectors.toList());
            KubernetesDeploymentTargetBuildItem merged = candidate;
            for (KubernetesDeploymentTargetBuildItem toBeMerged : nameAndKindMatchButNotEqual) {
                merged = candidate.merge(toBeMerged);
            }
            result.add(merged);
            alreadyProcessedNameKindPairs.add(nameToKindEntry);
        }
        return result;
    }

    @Override
    public int compareTo(KubernetesDeploymentTargetBuildItem o) {
        return Integer.compare(o.priority, this.priority);
    }
}

