/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.util;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusIntegrationTest;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import io.quarkus.test.junit.main.QuarkusMainTest;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import org.junit.jupiter.api.ClassDescriptor;
import org.junit.jupiter.api.ClassOrderer;
import org.junit.jupiter.api.ClassOrdererContext;
import org.junit.jupiter.api.Nested;

public class QuarkusTestProfileAwareClassOrderer
implements ClassOrderer {
    protected static final String DEFAULT_ORDER_PREFIX_QUARKUS_TEST = "20_";
    protected static final String DEFAULT_ORDER_PREFIX_QUARKUS_TEST_WITH_PROFILE = "40_";
    protected static final String DEFAULT_ORDER_PREFIX_QUARKUS_TEST_WITH_RESTRICTED_RES = "45_";
    protected static final String DEFAULT_ORDER_PREFIX_NON_QUARKUS_TEST = "60_";
    static final String CFGKEY_ORDER_PREFIX_QUARKUS_TEST = "quarkus.test.orderer.prefix.quarkus-test";
    static final String CFGKEY_ORDER_PREFIX_QUARKUS_TEST_WITH_PROFILE = "quarkus.test.orderer.prefix.quarkus-test-with-profile";
    static final String CFGKEY_ORDER_PREFIX_QUARKUS_TEST_WITH_RESTRICTED_RES = "quarkus.test.orderer.prefix.quarkus-test-with-restricted-resource";
    static final String CFGKEY_ORDER_PREFIX_NON_QUARKUS_TEST = "quarkus.test.orderer.prefix.non-quarkus-test";

    public void orderClasses(ClassOrdererContext context) {
        if (context.getClassDescriptors().size() <= 1 || ((ClassDescriptor)context.getClassDescriptors().get(0)).isAnnotated(Nested.class)) {
            return;
        }
        String prefixQuarkusTest = context.getConfigurationParameter(CFGKEY_ORDER_PREFIX_QUARKUS_TEST).orElse(DEFAULT_ORDER_PREFIX_QUARKUS_TEST);
        String prefixQuarkusTestWithProfile = context.getConfigurationParameter(CFGKEY_ORDER_PREFIX_QUARKUS_TEST_WITH_PROFILE).orElse(DEFAULT_ORDER_PREFIX_QUARKUS_TEST_WITH_PROFILE);
        String prefixQuarkusTestWithRestrictedResource = context.getConfigurationParameter(CFGKEY_ORDER_PREFIX_QUARKUS_TEST_WITH_RESTRICTED_RES).orElse(DEFAULT_ORDER_PREFIX_QUARKUS_TEST_WITH_RESTRICTED_RES);
        String prefixNonQuarkusTest = context.getConfigurationParameter(CFGKEY_ORDER_PREFIX_NON_QUARKUS_TEST).orElse(DEFAULT_ORDER_PREFIX_NON_QUARKUS_TEST);
        context.getClassDescriptors().sort(Comparator.comparing(classDescriptor -> {
            Optional<String> customOrderKey = this.getCustomOrderKey((ClassDescriptor)classDescriptor, context);
            if (customOrderKey.isPresent()) {
                return customOrderKey.get();
            }
            String testClassName = classDescriptor.getTestClass().getName();
            if (classDescriptor.isAnnotated(QuarkusTest.class) || classDescriptor.isAnnotated(QuarkusIntegrationTest.class) || classDescriptor.isAnnotated(QuarkusMainTest.class)) {
                return classDescriptor.findAnnotation(TestProfile.class).map(TestProfile::value).map(profileClass -> prefixQuarkusTestWithProfile + profileClass.getName() + "@" + testClassName).orElseGet(() -> {
                    String prefix = this.hasRestrictedResource((ClassDescriptor)classDescriptor) ? prefixQuarkusTestWithRestrictedResource : prefixQuarkusTest;
                    return prefix + testClassName;
                });
            }
            return prefixNonQuarkusTest + testClassName;
        }));
    }

    private boolean hasRestrictedResource(ClassDescriptor classDescriptor) {
        return classDescriptor.findRepeatableAnnotations(QuarkusTestResource.class).stream().anyMatch(res -> res.restrictToAnnotatedClass() || this.isMetaTestResource((QuarkusTestResource)res, classDescriptor));
    }

    private boolean isMetaTestResource(QuarkusTestResource resource, ClassDescriptor classDescriptor) {
        return Arrays.stream((QuarkusTestResource[])classDescriptor.getTestClass().getAnnotationsByType(QuarkusTestResource.class)).map(QuarkusTestResource::value).noneMatch(resource.value()::equals);
    }

    protected Optional<String> getCustomOrderKey(ClassDescriptor classDescriptor, ClassOrdererContext context) {
        return Optional.empty();
    }
}

