/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.internal;

import io.quarkus.test.InjectMock;
import io.quarkus.test.junit.callback.QuarkusTestAfterConstructCallback;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class VerifyMockitoMocksCallback
implements QuarkusTestAfterConstructCallback {
    @Override
    public void afterConstruct(Object testInstance) {
        Class<? extends Annotation> mockitoConfig = this.loadMockitoConfig();
        if (mockitoConfig == null) {
            ArrayList<Field> injectMockFields = new ArrayList<Field>();
            for (Class<?> current = testInstance.getClass(); current != null; current = current.getSuperclass()) {
                for (Field field : current.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(InjectMock.class)) continue;
                    injectMockFields.add(field);
                }
            }
            if (!injectMockFields.isEmpty()) {
                throw new IllegalStateException("@io.quarkus.test.InjectMock declared on one or more fields of a @QuarkusTest but the quarkus-junit-mockito dependency is not present: " + String.valueOf(injectMockFields.stream().map(f -> "/n/t- " + f.toString())));
            }
        }
    }

    private Class<? extends Annotation> loadMockitoConfig() {
        try {
            return Class.forName("io.quarkus.test.junit.mockito.MockitoConfig");
        }
        catch (ClassNotFoundException ignored) {
            return null;
        }
    }
}

