/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dev;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DevModeContext
implements Serializable {
    private final List<URL> classPath = new ArrayList<URL>();
    private final List<ModuleInfo> modules = new ArrayList<ModuleInfo>();
    private final Map<String, String> systemProperties = new HashMap<String, String>();
    private final Map<String, String> buildSystemProperties = new HashMap<String, String>();
    private String sourceEncoding;
    private final List<File> classesRoots = new ArrayList<File>();
    private File frameworkClassesDir;
    private File cacheDir;
    private File projectDir;
    private boolean test;
    private boolean abortOnFailedStart;
    private File devModeRunnerJarFile;
    private boolean localProjectDiscovery = true;
    private List<String> compilerOptions;
    private String sourceJavaVersion;
    private String targetJvmVersion;
    private List<String> compilerPluginArtifacts;
    private List<String> compilerPluginsOptions;

    public boolean isLocalProjectDiscovery() {
        return this.localProjectDiscovery;
    }

    public DevModeContext setLocalProjectDiscovery(boolean localProjectDiscovery) {
        this.localProjectDiscovery = localProjectDiscovery;
        return this;
    }

    public List<URL> getClassPath() {
        return this.classPath;
    }

    public List<ModuleInfo> getModules() {
        return this.modules;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public Map<String, String> getBuildSystemProperties() {
        return this.buildSystemProperties;
    }

    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    public List<File> getClassesRoots() {
        return this.classesRoots;
    }

    public File getFrameworkClassesDir() {
        return this.frameworkClassesDir;
    }

    public void setFrameworkClassesDir(File frameworkClassesDir) {
        this.frameworkClassesDir = frameworkClassesDir;
    }

    public File getCacheDir() {
        return this.cacheDir;
    }

    public void setCacheDir(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    public boolean isTest() {
        return this.test;
    }

    public void setTest(boolean test) {
        this.test = test;
    }

    public boolean isAbortOnFailedStart() {
        return this.abortOnFailedStart;
    }

    public void setAbortOnFailedStart(boolean abortOnFailedStart) {
        this.abortOnFailedStart = abortOnFailedStart;
    }

    public List<String> getCompilerOptions() {
        return this.compilerOptions;
    }

    public void setCompilerOptions(List<String> compilerOptions) {
        this.compilerOptions = compilerOptions;
    }

    public String getSourceJavaVersion() {
        return this.sourceJavaVersion;
    }

    public void setSourceJavaVersion(String sourceJavaVersion) {
        this.sourceJavaVersion = sourceJavaVersion;
    }

    public String getTargetJvmVersion() {
        return this.targetJvmVersion;
    }

    public void setTargetJvmVersion(String targetJvmVersion) {
        this.targetJvmVersion = targetJvmVersion;
    }

    public List<String> getCompilerPluginArtifacts() {
        return this.compilerPluginArtifacts;
    }

    public void setCompilerPluginArtifacts(List<String> compilerPluginArtifacts) {
        this.compilerPluginArtifacts = compilerPluginArtifacts;
    }

    public List<String> getCompilerPluginsOptions() {
        return this.compilerPluginsOptions;
    }

    public void setCompilerPluginsOptions(List<String> compilerPluginsOptions) {
        this.compilerPluginsOptions = compilerPluginsOptions;
    }

    public File getDevModeRunnerJarFile() {
        return this.devModeRunnerJarFile;
    }

    public void setDevModeRunnerJarFile(File devModeRunnerJarFile) {
        this.devModeRunnerJarFile = devModeRunnerJarFile;
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public DevModeContext setProjectDir(File projectDir) {
        this.projectDir = projectDir;
        return this;
    }

    public static class ModuleInfo
    implements Serializable {
        private final String name;
        private final String projectDirectory;
        private final Set<String> sourcePaths;
        private final String classesPath;
        private final String resourcePath;

        public ModuleInfo(String name, String projectDirectory, Set<String> sourcePaths, String classesPath, String resourcePath) {
            this.name = name;
            this.projectDirectory = projectDirectory;
            this.sourcePaths = sourcePaths == null ? new HashSet<String>() : new HashSet<String>(sourcePaths);
            this.classesPath = classesPath;
            this.resourcePath = resourcePath;
        }

        public String getName() {
            return this.name;
        }

        public String getProjectDirectory() {
            return this.projectDirectory;
        }

        public Set<String> getSourcePaths() {
            return Collections.unmodifiableSet(this.sourcePaths);
        }

        public void addSourcePaths(Collection<String> additionalPaths) {
            additionalPaths.stream().map(p -> this.projectDirectory + File.separator + p).forEach(this.sourcePaths::add);
        }

        public String getClassesPath() {
            return this.classesPath;
        }

        public String getResourcePath() {
            return this.resourcePath;
        }
    }
}

