/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime.caffeine;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.quarkus.cache.runtime.AbstractCache;
import io.quarkus.cache.runtime.CacheException;
import io.quarkus.cache.runtime.NullValueConverter;
import io.quarkus.cache.runtime.caffeine.CaffeineCacheInfo;
import io.quarkus.cache.runtime.caffeine.CaffeineComputationThrowable;
import io.smallrye.mutiny.Uni;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.jboss.logging.Logger;

public class CaffeineCache
extends AbstractCache {
    private static final Logger LOGGER = Logger.getLogger(CaffeineCache.class);
    private AsyncCache<Object, Object> cache;
    private String name;
    private Integer initialCapacity;
    private Long maximumSize;
    private Duration expireAfterWrite;
    private Duration expireAfterAccess;

    public CaffeineCache(CaffeineCacheInfo cacheInfo) {
        this.name = cacheInfo.name;
        Caffeine builder = Caffeine.newBuilder();
        if (cacheInfo.initialCapacity != null) {
            this.initialCapacity = cacheInfo.initialCapacity;
            builder.initialCapacity(cacheInfo.initialCapacity.intValue());
        }
        if (cacheInfo.maximumSize != null) {
            this.maximumSize = cacheInfo.maximumSize;
            builder.maximumSize(cacheInfo.maximumSize.longValue());
        }
        if (cacheInfo.expireAfterWrite != null) {
            this.expireAfterWrite = cacheInfo.expireAfterWrite;
            builder.expireAfterWrite(cacheInfo.expireAfterWrite);
        }
        if (cacheInfo.expireAfterAccess != null) {
            this.expireAfterAccess = cacheInfo.expireAfterAccess;
            builder.expireAfterAccess(cacheInfo.expireAfterAccess);
        }
        this.cache = builder.buildAsync();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CompletableFuture<Object> get(Object key, Function<Object, Object> valueLoader) {
        if (key == null) {
            throw new NullPointerException("Null keys are not supported by the Quarkus application data cache");
        }
        CompletableFuture<Object> newCacheValue = new CompletableFuture<Object>();
        CompletableFuture<Object> existingCacheValue = this.cache.asMap().putIfAbsent(key, newCacheValue);
        if (existingCacheValue == null) {
            try {
                Object value = valueLoader.apply(key);
                newCacheValue.complete(NullValueConverter.toCacheValue(value));
            }
            catch (Throwable t) {
                this.cache.asMap().remove(key, newCacheValue);
                newCacheValue.complete(new CaffeineComputationThrowable(t));
            }
            return this.unwrapCacheValueOrThrowable(newCacheValue);
        }
        return this.unwrapCacheValueOrThrowable(existingCacheValue);
    }

    private CompletableFuture<Object> unwrapCacheValueOrThrowable(CompletableFuture<Object> cacheValue) {
        return cacheValue.thenApply(new Function<Object, Object>(){

            @Override
            public Object apply(Object value) {
                if (value instanceof CaffeineComputationThrowable) {
                    Throwable cause = ((CaffeineComputationThrowable)value).getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    throw new CacheException(cause);
                }
                return NullValueConverter.fromCacheValue(value);
            }
        });
    }

    @Override
    public void invalidate(Object key) {
        if (key == null) {
            throw new NullPointerException("Null keys are not supported by the Quarkus application data cache");
        }
        this.cache.synchronous().invalidate(key);
    }

    @Override
    public void invalidateAll() {
        this.cache.synchronous().invalidateAll();
    }

    @Override
    public Uni<Void> replaceUniValue(Object key, Object emittedValue) {
        return Uni.createFrom().item(() -> {
            this.cache.asMap().computeIfPresent(key, (k, currentValue) -> {
                LOGGER.debugf("Replacing Uni value entry with key [%s] into cache [%s]", key, (Object)this.name);
                return CompletableFuture.completedFuture(NullValueConverter.toCacheValue(emittedValue));
            });
            return null;
        });
    }

    public Integer getInitialCapacity() {
        return this.initialCapacity;
    }

    public Long getMaximumSize() {
        return this.maximumSize;
    }

    public Duration getExpireAfterWrite() {
        return this.expireAfterWrite;
    }

    public Duration getExpireAfterAccess() {
        return this.expireAfterAccess;
    }

    public long getSize() {
        return this.cache.synchronous().estimatedSize();
    }
}

