/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.deployment;

import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.AutoInjectAnnotationBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.cache.CacheManager;
import io.quarkus.cache.deployment.AdditionalCacheNameBuildItem;
import io.quarkus.cache.deployment.CacheAnnotationsTransformer;
import io.quarkus.cache.deployment.CacheConfig;
import io.quarkus.cache.deployment.CacheDeploymentConstants;
import io.quarkus.cache.deployment.CacheNamesBuildItem;
import io.quarkus.cache.deployment.CaffeineCacheInfoBuilder;
import io.quarkus.cache.deployment.RestClientMethodEnhancer;
import io.quarkus.cache.deployment.exception.ClassTargetException;
import io.quarkus.cache.deployment.exception.PrivateMethodTargetException;
import io.quarkus.cache.deployment.exception.UnknownCacheNameException;
import io.quarkus.cache.deployment.exception.UnsupportedRepeatedAnnotationException;
import io.quarkus.cache.deployment.exception.VoidReturnTypeTargetException;
import io.quarkus.cache.runtime.CacheInvalidateAllInterceptor;
import io.quarkus.cache.runtime.CacheInvalidateInterceptor;
import io.quarkus.cache.runtime.CacheResultInterceptor;
import io.quarkus.cache.runtime.caffeine.CaffeineCacheBuildRecorder;
import io.quarkus.cache.runtime.caffeine.CaffeineCacheInfo;
import io.quarkus.cache.runtime.noop.NoOpCacheBuildRecorder;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.DeploymentException;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

class CacheProcessor {
    CacheProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.CACHE);
    }

    @BuildStep
    AutoInjectAnnotationBuildItem autoInjectCacheName() {
        return new AutoInjectAnnotationBuildItem(new DotName[]{CacheDeploymentConstants.CACHE_NAME});
    }

    @BuildStep
    AnnotationsTransformerBuildItem annotationsTransformer() {
        return new AnnotationsTransformerBuildItem((AnnotationsTransformer)new CacheAnnotationsTransformer());
    }

    @BuildStep
    void validateCacheAnnotationsAndProduceCacheNames(CombinedIndexBuildItem combinedIndex, List<AdditionalCacheNameBuildItem> additionalCacheNames, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors, BuildProducer<CacheNamesBuildItem> cacheNames) {
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        HashSet<String> names = new HashSet<String>();
        for (DotName bindingName : CacheDeploymentConstants.INTERCEPTOR_BINDINGS) {
            for (AnnotationInstance binding : combinedIndex.getIndex().getAnnotations(bindingName)) {
                throwables.addAll(this.validateInterceptorBindingTarget(binding, binding.target()));
                if (binding.target().kind() != AnnotationTarget.Kind.METHOD) continue;
                names.add(binding.value("cacheName").asString());
            }
        }
        for (DotName containerName : CacheDeploymentConstants.INTERCEPTOR_BINDING_CONTAINERS) {
            for (AnnotationInstance container : combinedIndex.getIndex().getAnnotations(containerName)) {
                MethodInfo methodInfo;
                for (AnnotationInstance binding : container.value("value").asNestedArray()) {
                    throwables.addAll(this.validateInterceptorBindingTarget(binding, container.target()));
                    names.add(binding.value("cacheName").asString());
                }
                if (container.target().kind() != AnnotationTarget.Kind.METHOD || (methodInfo = container.target().asMethod()).declaringClass().classAnnotation(CacheDeploymentConstants.REGISTER_REST_CLIENT) == null) continue;
                throwables.add(new UnsupportedRepeatedAnnotationException(methodInfo));
            }
        }
        for (AdditionalCacheNameBuildItem additionalCacheName : additionalCacheNames) {
            names.add(additionalCacheName.getName());
        }
        block11: for (AnnotationInstance qualifier : combinedIndex.getIndex().getAnnotations(CacheDeploymentConstants.CACHE_NAME)) {
            String cacheName = qualifier.value().asString();
            AnnotationTarget target = qualifier.target();
            switch (target.kind()) {
                case FIELD: {
                    if (names.contains(cacheName)) continue block11;
                    ClassInfo declaringClass = target.asField().declaringClass();
                    throwables.add(new UnknownCacheNameException(declaringClass.name(), cacheName));
                    continue block11;
                }
                case METHOD: {
                    continue block11;
                }
                case METHOD_PARAMETER: {
                    if (names.contains(cacheName)) continue block11;
                    ClassInfo declaringClass = target.asMethodParameter().method().declaringClass();
                    throwables.add(new UnknownCacheNameException(declaringClass.name(), cacheName));
                    continue block11;
                }
            }
            throw new DeploymentException("Unexpected @CacheName target: " + target.kind());
        }
        validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(throwables.toArray(new Throwable[0])));
        cacheNames.produce((BuildItem)new CacheNamesBuildItem(names));
    }

    private List<Throwable> validateInterceptorBindingTarget(AnnotationInstance binding, AnnotationTarget target) {
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        switch (target.kind()) {
            case CLASS: {
                ClassInfo classInfo = target.asClass();
                if (CacheDeploymentConstants.INTERCEPTORS.contains(classInfo.name())) break;
                throwables.add(new ClassTargetException(classInfo.name(), binding.name()));
                break;
            }
            case METHOD: {
                MethodInfo methodInfo = target.asMethod();
                if (Modifier.isPrivate(methodInfo.flags())) {
                    throwables.add(new PrivateMethodTargetException(methodInfo, binding.name()));
                }
                if (!CacheDeploymentConstants.CACHE_RESULT.equals((Object)binding.name()) || methodInfo.returnType().kind() != Type.Kind.VOID) break;
                throwables.add(new VoidReturnTypeTargetException(methodInfo));
                break;
            }
            default: {
                throw new DeploymentException("Unexpected cache interceptor binding target: " + target.kind());
            }
        }
        return throwables;
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    SyntheticBeanBuildItem configureCacheManagerSyntheticBean(CacheNamesBuildItem cacheNames, CacheConfig config, CaffeineCacheBuildRecorder caffeineRecorder, NoOpCacheBuildRecorder noOpRecorder) {
        Supplier cacheManagerSupplier;
        if (config.enabled) {
            switch (config.type) {
                case "caffeine": {
                    Set<CaffeineCacheInfo> cacheInfos = CaffeineCacheInfoBuilder.build(cacheNames.getNames(), config);
                    cacheManagerSupplier = caffeineRecorder.getCacheManagerSupplier(cacheInfos);
                    break;
                }
                default: {
                    throw new DeploymentException("Unknown cache type: " + config.type);
                }
            }
        } else {
            cacheManagerSupplier = noOpRecorder.getCacheManagerSupplier(cacheNames.getNames());
        }
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(CacheManager.class).scope(ApplicationScoped.class)).supplier(cacheManagerSupplier).done();
    }

    @BuildStep
    List<BytecodeTransformerBuildItem> enhanceRestClientMethods(CombinedIndexBuildItem combinedIndex, BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        ArrayList<BytecodeTransformerBuildItem> bytecodeTransformers = new ArrayList<BytecodeTransformerBuildItem>();
        boolean cacheInvalidate = false;
        boolean cacheResult = false;
        boolean cacheInvalidateAll = false;
        for (AnnotationInstance registerRestClientAnnotation : combinedIndex.getIndex().getAnnotations(CacheDeploymentConstants.REGISTER_REST_CLIENT)) {
            if (registerRestClientAnnotation.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            ClassInfo classInfo = registerRestClientAnnotation.target().asClass();
            for (MethodInfo methodInfo : classInfo.methods()) {
                boolean transform = false;
                if (methodInfo.hasAnnotation(CacheDeploymentConstants.CACHE_INVALIDATE) || methodInfo.hasAnnotation(CacheDeploymentConstants.CACHE_INVALIDATE_LIST)) {
                    transform = true;
                    cacheInvalidate = true;
                }
                if (methodInfo.hasAnnotation(CacheDeploymentConstants.CACHE_RESULT)) {
                    transform = true;
                    cacheResult = true;
                }
                if (methodInfo.hasAnnotation(CacheDeploymentConstants.CACHE_INVALIDATE_ALL) || methodInfo.hasAnnotation(CacheDeploymentConstants.CACHE_INVALIDATE_ALL_LIST)) {
                    cacheInvalidateAll = true;
                }
                if (!transform) continue;
                short[] cacheKeyParameterPositions = this.getCacheKeyParameterPositions(methodInfo);
                bytecodeTransformers.add(new BytecodeTransformerBuildItem(classInfo.toString(), (BiFunction)new RestClientMethodEnhancer(methodInfo.name(), cacheKeyParameterPositions)));
            }
        }
        if (cacheResult) {
            unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames((String[])new String[]{CacheResultInterceptor.class.getName()}));
        }
        if (cacheInvalidate) {
            unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames((String[])new String[]{CacheInvalidateInterceptor.class.getName()}));
        }
        if (cacheInvalidateAll) {
            unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames((String[])new String[]{CacheInvalidateAllInterceptor.class.getName()}));
        }
        return bytecodeTransformers;
    }

    private short[] getCacheKeyParameterPositions(MethodInfo methodInfo) {
        ArrayList<Short> positions = new ArrayList<Short>();
        for (AnnotationInstance annotation : methodInfo.annotations(CacheDeploymentConstants.CACHE_KEY)) {
            positions.add(annotation.target().asMethodParameter().position());
        }
        short[] result = new short[positions.size()];
        for (int i = 0; i < positions.size(); ++i) {
            result[i] = (Short)positions.get(i);
        }
        return result;
    }
}

