/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

public class AppArtifactKey {
    protected final String groupId;
    protected final String artifactId;
    protected final String classifier;
    protected final String type;

    public static AppArtifactKey fromString(String str) {
        return new AppArtifactKey(AppArtifactKey.split(str, new String[4], str.length()));
    }

    protected static String[] split(String str, String[] parts, int fromIndex) {
        int i = str.lastIndexOf(58, fromIndex - 1);
        if (i <= 0) {
            throw new IllegalArgumentException("GroupId and artifactId separating ':' is abscent or not in the right place in '" + str.substring(0, fromIndex) + "'");
        }
        parts[3] = str.substring(i + 1, fromIndex);
        fromIndex = i;
        if ((i = str.lastIndexOf(58, fromIndex - 1)) < 0) {
            parts[0] = str.substring(0, fromIndex);
            parts[1] = parts[3];
            if (parts[1].isEmpty()) {
                throw new IllegalArgumentException("ArtifactId is empty in `" + str + "`");
            }
            parts[2] = "";
            parts[3] = null;
            return parts;
        }
        if (i == 0) {
            throw new IllegalArgumentException("One of groupId or artifactId is missing from '" + str.substring(0, fromIndex) + "'");
        }
        parts[2] = i == fromIndex - 1 ? "" : str.substring(i + 1, fromIndex);
        fromIndex = i;
        if ((i = str.lastIndexOf(58, fromIndex - 1)) < 0) {
            parts[0] = str.substring(0, fromIndex);
            parts[1] = parts[2];
            if (parts[1].isEmpty()) {
                throw new IllegalArgumentException("ArtifactId is empty in `" + str + "`");
            }
            parts[2] = parts[3];
            parts[3] = null;
            return parts;
        }
        if (i == 0 || i == fromIndex - 1) {
            throw new IllegalArgumentException("One of groupId or artifactId is missing from '" + str.substring(0, fromIndex) + "'");
        }
        parts[0] = str.substring(0, i);
        parts[1] = str.substring(i + 1, fromIndex);
        if (parts[3].isEmpty()) {
            parts[3] = null;
        }
        return parts;
    }

    protected AppArtifactKey(String[] parts) {
        this.groupId = parts[0];
        this.artifactId = parts[1];
        this.classifier = parts[2];
        this.type = parts[3];
    }

    public AppArtifactKey(String groupId, String artifactId) {
        this(groupId, artifactId, null);
    }

    public AppArtifactKey(String groupId, String artifactId, String classifier) {
        this(groupId, artifactId, classifier, null);
    }

    public AppArtifactKey(String groupId, String artifactId, String classifier, String type) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.classifier = classifier == null ? "" : classifier;
        this.type = type;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AppArtifactKey other = (AppArtifactKey)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.groupId).append(':').append(this.artifactId);
        if (!this.classifier.isEmpty()) {
            buf.append(':').append(this.classifier);
        } else if (this.type != null) {
            buf.append(':');
        }
        if (this.type != null) {
            buf.append(':').append(this.type);
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        AppArtifactKey ga = AppArtifactKey.fromString("g:a:c:t");
        System.out.println(ga.getGroupId());
        System.out.println(ga.getArtifactId());
        System.out.println("'" + ga.getClassifier() + "'");
        System.out.println(ga.getType());
    }
}

