/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.httpcore;

import io.netty.buffer.ByteBuf;
import io.undertow.httpcore.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;

public class UndertowOutputStream
extends OutputStream {
    private final HttpExchange exchange;
    private ByteBuf pooledBuffer;
    private long written;
    private final long contentLength;
    private boolean closed;
    private boolean writeStarted;

    public UndertowOutputStream(HttpExchange exchange) {
        this.exchange = exchange;
        this.contentLength = exchange.getResponseContentLength();
    }

    public void resetBuffer() {
        if (this.writeStarted) {
            throw new IllegalStateException("Cannot reset buffer");
        }
        if (this.pooledBuffer != null) {
            this.pooledBuffer.release();
            this.pooledBuffer = null;
            this.written = 0L;
        }
    }

    public long getBytesWritten() {
        return this.written;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len < 1) {
            return;
        }
        if (this.exchange.getIoThread().inEventLoop()) {
            throw new IllegalStateException("Cannot do blocking IO from IO thread");
        }
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        int rem = len;
        int idx = off;
        ByteBuf buffer = this.pooledBuffer;
        try {
            if (buffer == null) {
                this.pooledBuffer = buffer = this.exchange.getBufferAllocator().allocateBuffer();
            }
            while (rem > 0) {
                int toWrite = Math.min(rem, buffer.writableBytes());
                buffer.writeBytes(b, idx, toWrite);
                rem -= toWrite;
                idx += toWrite;
                if (buffer.isWritable()) continue;
                this.writeStarted = true;
                this.exchange.getOutputChannel().writeBlocking(buffer, false);
                this.pooledBuffer = buffer = this.exchange.getBufferAllocator().allocateBuffer();
            }
        }
        catch (Exception e) {
            if (buffer != null) {
                buffer.release();
            }
            throw new IOException(e);
        }
        this.updateWritten(len);
    }

    void updateWritten(long len) throws IOException {
        this.written += len;
        if (this.contentLength != -1L && this.written >= this.contentLength) {
            this.flush();
            this.close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        try {
            if (this.pooledBuffer != null) {
                this.exchange.getOutputChannel().writeBlocking(this.pooledBuffer, false);
                this.pooledBuffer = null;
            }
        }
        catch (Exception e) {
            if (this.pooledBuffer != null) {
                this.pooledBuffer.release();
                this.pooledBuffer = null;
            }
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (!this.writeStarted) {
            if (this.pooledBuffer == null) {
                this.exchange.setResponseHeader("Content-Length", "0");
            } else {
                this.exchange.setResponseHeader("Content-Length", "" + this.pooledBuffer.readableBytes());
            }
        }
        try {
            this.exchange.getOutputChannel().writeBlocking(this.pooledBuffer, true);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            this.pooledBuffer = null;
        }
    }
}

