/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.ContextInstanceHandle;
import io.quarkus.arc.impl.ContextInstances;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanStream;
import io.quarkus.arc.processor.MethodDescs;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.Reproducibility;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.FieldVar;
import io.quarkus.gizmo2.Gizmo;
import io.quarkus.gizmo2.InstanceFieldVar;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.StaticFieldVar;
import io.quarkus.gizmo2.Var;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ClassCreator;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import java.lang.constant.ClassDesc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.jandex.DotName;

public class ContextInstancesGenerator
extends AbstractGenerator {
    static final String CONTEXT_INSTANCES_SUFFIX = "_ContextInstances";
    private final BeanDeployment beanDeployment;
    private final Map<DotName, String> scopeToGeneratedName;

    public ContextInstancesGenerator(boolean generateSources, ReflectionRegistration reflectionRegistration, BeanDeployment beanDeployment, Map<DotName, String> scopeToGeneratedName) {
        super(generateSources, reflectionRegistration);
        this.beanDeployment = beanDeployment;
        this.scopeToGeneratedName = scopeToGeneratedName;
    }

    void precomputeGeneratedName(DotName scope) {
        String generatedName = DEFAULT_PACKAGE + "." + this.beanDeployment.name + "_" + scope.toString().replace(".", "_") + CONTEXT_INSTANCES_SUFFIX;
        this.scopeToGeneratedName.put(scope, generatedName);
    }

    Collection<ResourceOutput.Resource> generate(DotName scope) {
        ResourceClassOutput classOutput = new ResourceClassOutput(true, this.generateSources);
        Gizmo gizmo = ContextInstancesGenerator.gizmo(classOutput);
        this.createContextInstances(gizmo, scope);
        return classOutput.getResources();
    }

    private void createContextInstances(Gizmo gizmo, DotName scope) {
        String generatedName = this.scopeToGeneratedName.get(scope);
        this.reflectionRegistration.registerMethod(generatedName, "<init>", new String[0]);
        List<BeanInfo> beans = new BeanStream(this.beanDeployment.getBeans()).withScope(scope).collect();
        MethodDesc newUpdater = MethodDesc.of(AtomicReferenceFieldUpdater.class, (String)"newUpdater", AtomicReferenceFieldUpdater.class, (Class[])new Class[]{Class.class, Class.class, String.class});
        gizmo.class_(generatedName, cc -> {
            cc.implements_(ContextInstances.class);
            TreeMap<String, BeanFields> beanFields = new TreeMap<String, BeanFields>();
            int fieldIndex = 0;
            for (BeanInfo bean : Reproducibility.orderedBeans(beans)) {
                String beanIdx = "" + fieldIndex++;
                FieldDesc handleField = cc.field("h" + beanIdx, fc -> {
                    fc.private_();
                    fc.volatile_();
                    fc.setType(ContextInstanceHandle.class);
                });
                FieldDesc lockField = cc.field("l" + beanIdx, fc -> {
                    fc.private_();
                    fc.volatile_();
                    fc.setType(Lock.class);
                });
                StaticFieldVar lockUpdaterField = cc.staticField("L" + beanIdx + "_UPDATER", fc -> {
                    fc.private_();
                    fc.final_();
                    fc.setType(AtomicReferenceFieldUpdater.class);
                    fc.setInitializer(bc -> bc.yield(bc.invokeStatic(newUpdater, new Expr[]{Const.of((ClassDesc)cc.type()), Const.of(Lock.class), Const.of((String)("l" + beanIdx))})));
                });
                beanFields.put(bean.getIdentifier(), new BeanFields(handleField, lockField, lockUpdaterField));
            }
            cc.defaultConstructor();
            Map<String, MethodDesc> lazyLocks = this.generateLazyLocks((ClassCreator)cc, (Map<String, BeanFields>)beanFields);
            this.generateComputeIfAbsent((ClassCreator)cc, (Map<String, BeanFields>)beanFields, lazyLocks);
            this.generateGetIfPresent((ClassCreator)cc, (Map<String, BeanFields>)beanFields);
            this.generateGetAllPresent((ClassCreator)cc, (Map<String, BeanFields>)beanFields);
            List<MethodDesc> remove = this.generateRemove((ClassCreator)cc, (Map<String, BeanFields>)beanFields, lazyLocks);
            this.generateRemoveEach((ClassCreator)cc, remove);
        });
    }

    private Map<String, MethodDesc> generateLazyLocks(ClassCreator cc, Map<String, BeanFields> beanFields) {
        MethodDesc updaterCas = MethodDesc.of(AtomicReferenceFieldUpdater.class, (String)"compareAndSet", Boolean.TYPE, (Class[])new Class[]{Object.class, Object.class, Object.class});
        HashMap<String, MethodDesc> result = new HashMap<String, MethodDesc>(beanFields.size());
        for (Map.Entry<String, BeanFields> namedFields : beanFields.entrySet()) {
            String beanId = namedFields.getKey();
            BeanFields fields = namedFields.getValue();
            MethodDesc desc = cc.method("lazy" + fields.lock().name(), mc -> {
                mc.private_();
                mc.returning(Lock.class);
                mc.body(b0 -> {
                    InstanceFieldVar lock = cc.this_().field(fields.lock());
                    b0.ifNotNull((Expr)lock, arg_0 -> ContextInstancesGenerator.lambda$generateLazyLocks$5((FieldVar)lock, arg_0));
                    LocalVar newLock = b0.localVar("newLock", b0.new_(ReentrantLock.class));
                    Expr casResult = b0.invokeVirtual(updaterCas, (Expr)fields.lockUpdater(), new Expr[]{cc.this_(), Const.ofNull(Lock.class), newLock});
                    b0.if_(casResult, b1 -> b1.return_((Expr)newLock));
                    b0.return_((Expr)lock);
                });
            });
            result.put(beanId, desc);
        }
        return result;
    }

    private void generateComputeIfAbsent(ClassCreator cc, Map<String, BeanFields> beanFields, Map<String, MethodDesc> lazyLocks) {
        HashMap<String, MethodDesc> computeMethodsByBean = new HashMap<String, MethodDesc>();
        for (Map.Entry<String, BeanFields> idToFields : beanFields.entrySet()) {
            String beanId = idToFields.getKey();
            BeanFields fields = idToFields.getValue();
            MethodDesc desc = cc.method("c" + fields.instance().name(), mc -> {
                mc.returning(ContextInstanceHandle.class);
                ParamVar supplier = mc.parameter("supplier", Supplier.class);
                mc.body(b0 -> {
                    LocalVar copy = b0.localVar("copy", (Expr)cc.this_().field(fields.instance()));
                    b0.ifNotNull((Expr)copy, b1 -> b1.return_((Expr)copy));
                    LocalVar lock = b0.localVar("lock", b0.invokeVirtual((MethodDesc)lazyLocks.get(beanId), (Expr)cc.this_()));
                    b0.locked((Expr)lock, b1 -> {
                        b1.set((Assignable)copy, (Expr)cc.this_().field(fields.instance()));
                        b1.ifNotNull((Expr)copy, b2 -> b2.return_((Expr)copy));
                        b1.set((Assignable)copy, b1.invokeInterface(MethodDescs.SUPPLIER_GET, (Expr)supplier));
                        b1.set((Assignable)cc.this_().field(fields.instance()), (Expr)copy);
                        b1.return_((Expr)copy);
                    });
                });
            });
            computeMethodsByBean.put(beanId, desc);
        }
        cc.method("computeIfAbsent", mc -> {
            mc.returning(ContextInstanceHandle.class);
            ParamVar rtBeanId = mc.parameter("beanId", String.class);
            ParamVar supplier = mc.parameter("supplier", Supplier.class);
            mc.body(b0 -> b0.return_(b0.switch_(ContextInstanceHandle.class, (Expr)rtBeanId, sc -> {
                for (String btBeanId : beanFields.keySet()) {
                    sc.caseOf(btBeanId, b1 -> b1.return_(b1.invokeVirtual((MethodDesc)computeMethodsByBean.get(btBeanId), (Expr)cc.this_(), (Expr)supplier)));
                }
                sc.default_(b1 -> b1.throw_(IllegalArgumentException.class, "Unknown bean identifier"));
            })));
        });
    }

    private void generateGetIfPresent(ClassCreator cc, Map<String, BeanFields> beanFields) {
        cc.method("getIfPresent", mc -> {
            mc.returning(ContextInstanceHandle.class);
            ParamVar rtBeanId = mc.parameter("beanId", String.class);
            mc.body(b0 -> b0.return_(b0.switch_(ContextInstanceHandle.class, (Expr)rtBeanId, sc -> {
                for (Map.Entry idToFields : beanFields.entrySet()) {
                    String btBeanId = (String)idToFields.getKey();
                    BeanFields fields = (BeanFields)idToFields.getValue();
                    sc.caseOf(btBeanId, b1 -> b1.yield((Expr)cc.this_().field(fields.instance())));
                }
                sc.default_(b1 -> b1.throw_(IllegalArgumentException.class, "Unknown bean identifier"));
            })));
        });
    }

    private void generateGetAllPresent(ClassCreator cc, Map<String, BeanFields> beanFields) {
        cc.method("getAllPresent", mc -> {
            mc.returning(Set.class);
            mc.body(b0 -> {
                ArrayList<LocalVar> handles = new ArrayList<LocalVar>(beanFields.size());
                for (BeanFields fields : beanFields.values()) {
                    handles.add(b0.localVar((Var)cc.this_().field(fields.instance)));
                }
                LocalVar result = b0.localVar("result", b0.new_(HashSet.class));
                for (LocalVar handle : handles) {
                    b0.ifNotNull((Expr)handle, b1 -> b1.withSet((Expr)result).add((Expr)handle));
                }
                b0.return_((Expr)result);
            });
        });
    }

    private List<MethodDesc> generateRemove(ClassCreator cc, Map<String, BeanFields> beanFields, Map<String, MethodDesc> lazyLocks) {
        ArrayList<MethodDesc> removeMethods = new ArrayList<MethodDesc>(beanFields.size());
        HashMap<String, MethodDesc> removeMethodsByBean = new HashMap<String, MethodDesc>();
        for (Map.Entry<String, BeanFields> idToFields : beanFields.entrySet()) {
            String beanId = idToFields.getKey();
            BeanFields fields = idToFields.getValue();
            FieldDesc instanceField = fields.instance;
            MethodDesc desc = cc.method("r" + instanceField.name(), mc -> {
                mc.returning(ContextInstanceHandle.class);
                mc.body(b0 -> {
                    LocalVar copy = b0.localVar("copy", (Expr)cc.this_().field(instanceField));
                    b0.ifNull((Expr)copy, b1 -> b1.return_((Expr)Const.ofNull(ContextInstanceHandle.class)));
                    LocalVar lock = b0.localVar("lock", b0.invokeVirtual((MethodDesc)lazyLocks.get(beanId), (Expr)cc.this_()));
                    b0.locked((Expr)lock, b1 -> {
                        b1.set((Assignable)copy, (Expr)cc.this_().field(instanceField));
                        b1.set((Assignable)cc.this_().field(instanceField), Const.ofNull(ContextInstanceHandle.class));
                    });
                    b0.return_((Expr)copy);
                });
            });
            removeMethods.add(desc);
            removeMethodsByBean.put(beanId, desc);
        }
        cc.method("remove", mc -> {
            mc.returning(ContextInstanceHandle.class);
            ParamVar rtBeanId = mc.parameter("beanId", String.class);
            mc.body(b0 -> b0.return_(b0.switch_(ContextInstanceHandle.class, (Expr)rtBeanId, sc -> {
                for (String btBeanId : beanFields.keySet()) {
                    sc.caseOf(btBeanId, b1 -> b1.return_(b1.invokeVirtual((MethodDesc)removeMethodsByBean.get(btBeanId), (Expr)cc.this_())));
                }
                sc.default_(b1 -> b1.throw_(IllegalArgumentException.class, "Unknown bean identifier"));
            })));
        });
        return removeMethods;
    }

    private void generateRemoveEach(ClassCreator cc, List<MethodDesc> removeInstances) {
        cc.method("removeEach", mc -> {
            mc.returning(Void.TYPE);
            ParamVar action = mc.parameter("action", Consumer.class);
            mc.body(b0 -> {
                int counter = 0;
                ArrayList<LocalVar> results = new ArrayList<LocalVar>(removeInstances.size());
                for (MethodDesc removeInstance : removeInstances) {
                    results.add(b0.localVar("copy" + counter, b0.invokeVirtual(removeInstance, (Expr)cc.this_())));
                    ++counter;
                }
                b0.ifNotNull((Expr)action, b1 -> {
                    for (LocalVar result : results) {
                        b1.ifNotNull((Expr)result, b2 -> b2.invokeInterface(MethodDescs.CONSUMER_ACCEPT, (Expr)action, (Expr)result));
                    }
                });
                b0.return_();
            });
        });
    }

    private static /* synthetic */ void lambda$generateLazyLocks$5(FieldVar lock, BlockCreator b1) {
        b1.return_((Expr)lock);
    }

    record BeanFields(FieldDesc instance, FieldDesc lock, StaticFieldVar lockUpdater) {
    }
}

