/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import nu.studer.java.util.OrderedProperties;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import pl.project13.core.CannotReadFileException;

public class YmlManager {
    protected static void dumpYml(OutputStream outputStream, OrderedProperties sortedLocalProperties, Charset sourceCharset) throws IOException {
        try (OutputStreamWriter outputWriter = new OutputStreamWriter(outputStream, sourceCharset);){
            DumperOptions dumperOptions = new DumperOptions();
            dumperOptions.setAllowUnicode(true);
            dumperOptions.setAllowReadOnlyProperties(true);
            dumperOptions.setPrettyFlow(true);
            dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.AUTO);
            Yaml yaml = new Yaml(dumperOptions);
            HashMap dataMap = new HashMap();
            for (Map.Entry e : sortedLocalProperties.entrySet()) {
                dataMap.put((String)e.getKey(), e.getValue());
            }
            yaml.dump(dataMap, (Writer)outputWriter);
        }
    }

    protected static Properties readYmlProperties(@Nonnull File xmlFile, Charset sourceCharset) throws CannotReadFileException {
        Properties retVal = new Properties();
        try (FileInputStream fis = new FileInputStream(xmlFile);
             InputStreamReader reader = new InputStreamReader((InputStream)fis, sourceCharset);){
            LoaderOptions loaderOptions = new LoaderOptions();
            loaderOptions.setAllowDuplicateKeys(false);
            loaderOptions.setAllowRecursiveKeys(false);
            loaderOptions.setProcessComments(false);
            Yaml yaml = new Yaml(loaderOptions);
            Map data = (Map)yaml.load((Reader)reader);
            for (Map.Entry e : data.entrySet()) {
                retVal.put(e.getKey(), e.getValue());
            }
        }
        catch (ClassCastException e) {
            throw new CannotReadFileException(e);
        }
        catch (IOException e) {
            throw new CannotReadFileException(e);
        }
        return retVal;
    }
}

