/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import nu.studer.java.util.OrderedProperties;
import pl.project13.core.CannotReadFileException;

public class XmlManager {
    protected static void dumpXml(OutputStream outputStream, OrderedProperties sortedLocalProperties, Charset sourceCharset) throws IOException {
        XMLOutputFactory fac = XMLOutputFactory.newInstance();
        try (OutputStreamWriter outputWriter = new OutputStreamWriter(outputStream, sourceCharset);){
            XMLStreamWriter writer = fac.createXMLStreamWriter(outputWriter);
            writer.writeStartDocument(StandardCharsets.UTF_8.toString(), "1.0");
            writer.writeStartElement("gitCommitIdPlugin");
            writer.writeCharacters("\n");
            for (Map.Entry e : sortedLocalProperties.entrySet()) {
                writer.writeCharacters("    ");
                writer.writeEmptyElement("property");
                writer.writeAttribute("key", e.getKey().toString());
                writer.writeAttribute("value", e.getValue().toString());
                writer.writeCharacters("\n");
            }
            writer.writeCharacters("\n");
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
            writer.close();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    protected static Properties readXmlProperties(@Nonnull File xmlFile, Charset sourceCharset) throws CannotReadFileException {
        Properties retVal = new Properties();
        try (FileInputStream fis = new FileInputStream(xmlFile);){
            try (InputStreamReader reader = new InputStreamReader((InputStream)fis, sourceCharset);){
                XMLInputFactory factory = XMLInputFactory.newInstance();
                factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
                factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
                factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                factory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
                factory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
                factory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
                XMLStreamReader xmlReader = factory.createXMLStreamReader(reader);
                while (xmlReader.hasNext()) {
                    if (xmlReader.next() != 1 || !xmlReader.getLocalName().equals("property")) continue;
                    String key = xmlReader.getAttributeValue(null, "key");
                    String value = xmlReader.getAttributeValue(null, "value");
                    retVal.setProperty(key, value);
                }
            }
            catch (XMLStreamException ex) {
                throw new CannotReadFileException(ex);
            }
        }
        catch (IOException e) {
            throw new CannotReadFileException(e);
        }
        return retVal;
    }
}

