/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.backend;

import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.core.exception.CucumberException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="7.1.0")
public final class DefaultObjectFactory
implements ObjectFactory {
    private final Map<Class<?>, Object> instances = new HashMap();

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.instances.clear();
    }

    @Override
    public boolean addClass(Class<?> clazz) {
        return true;
    }

    @Override
    public <T> T getInstance(Class<T> type) {
        T instance = type.cast(this.instances.get(type));
        if (instance == null) {
            instance = this.cacheNewInstance(type);
        }
        return instance;
    }

    private <T> T cacheNewInstance(Class<T> type) {
        try {
            Constructor<T> constructor = type.getConstructor(new Class[0]);
            T instance = constructor.newInstance(new Object[0]);
            this.instances.put(type, instance);
            return instance;
        }
        catch (NoSuchMethodException e) {
            throw new CucumberException(String.format("%s does not have a public zero-argument constructor.\n\nTo use dependency injection add an other ObjectFactory implementation such as:\n * cucumber-picocontainer\n * cucumber-spring\n * cucumber-jakarta-cdi\n * ...etc\n", type), e);
        }
        catch (Exception e) {
            throw new CucumberException(String.format("Failed to instantiate %s", type), e);
        }
    }
}

