/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.layouts;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ScrollIntoViewOption;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.TabSheet;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;

public class VTabSheet
extends TabSheet {
    private DomListenerRegistration scrollreg;

    public Tab addTab(String caption, Component component) {
        return this.add(caption, component);
    }

    public void removeTab(Tab tab) {
        this.remove(tab);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.getElement().executeJs("var self = this;var el = this.shadowRoot.querySelector(\"vaadin-tabsheet-scroller\");\n    el.addEventListener(\"scroll\", function(e) {\n        if(el.scrollTop + el.clientHeight == el.scrollHeight) {\n            self.$server.onScrollToEnd();\n        }\n    });\n", new Object[0]);
    }

    @ClientCallable
    private void onScrollToEnd() {
        this.getEventBus().fireEvent((ComponentEvent)new ScrollToEndEvent(this));
    }

    public Registration addScrollToEndListener(ComponentEventListener<ScrollToEndEvent> listener) {
        return this.addListener(ScrollToEndEvent.class, listener);
    }

    public Registration addScrollListener(ComponentEventListener<ScrollEvent> listener) {
        if (this.scrollreg == null) {
            this.getElement().executeJs("var el = this;this.shadowRoot.querySelector(\"vaadin-tabsheet-scroller\").addEventListener('scroll', e => {const event = new CustomEvent('myscroll', { detail: e.target.scrollTop + ',' + e.target.scrollLeft });\nel.dispatchEvent(event);})", new Object[0]);
            this.scrollreg = this.getElement().addEventListener("myscroll", (DomEventListener & Serializable)de -> this.getEventBus().fireEvent((ComponentEvent)new ScrollEvent(this, de.getEventData().asText("event.detail"))));
            this.scrollreg.debounce(100);
            this.scrollreg.addEventData("event.detail");
        }
        return this.addListener(ScrollEvent.class, listener);
    }

    public void scrollToTop() {
        this.setScrollTop(0);
    }

    public void scrollToBottom() {
        this.getElement().executeJs("this.scrollTop = this.scrollHeight", new Object[0]);
    }

    public void setScrollTop(int pixelsFromTop) {
        this.getElement().executeJs("this.scrollTop = $0", new Object[]{pixelsFromTop});
    }

    public void setScrollLeft(int pixelsFromLeft) {
        this.getElement().executeJs("this.scrollLeft = $0", new Object[]{pixelsFromLeft});
    }

    public void scrollIntoView(Component c) {
        c.scrollIntoView(new ScrollIntoViewOption[0]);
    }

    public static class ScrollToEndEvent
    extends ComponentEvent<VTabSheet> {
        ScrollToEndEvent(VTabSheet source) {
            super((Component)source, true);
        }
    }

    public static class ScrollEvent
    extends ComponentEvent<VTabSheet> {
        private final int scrollTop;
        private final int scrollLeft;

        ScrollEvent(VTabSheet source, String details) {
            super((Component)source, true);
            String[] split = details.split(",");
            this.scrollTop = Integer.parseInt(split[0]);
            this.scrollLeft = Integer.parseInt(split[1]);
        }

        public int getScrollLeft() {
            return this.scrollLeft;
        }

        public int getScrollTop() {
            return this.scrollTop;
        }
    }
}

