/*
 * #%L
 * MS-Access Importer
 * 
 * $Id: ImporterHelper.java 1466 2011-06-06 09:32:58Z chemit $
 * $HeadURL: https://svn.mpl.ird.fr/osiris/observe/msaccess-importer/tags/msaccess-importer-1.4/src/main/java/fr/ird/msaccess/importer/ImporterHelper.java $
 * %%
 * Copyright (C) 2010 - 2011 IRD, Codelutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package fr.ird.msaccess.importer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;

import java.io.Serializable;

/**
 * Usefull methods.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4
 */
public class ImporterHelper {

    /** Logger. */
    private static final Log log = LogFactory.getLog(ImporterHelper.class);

    /**
     * Obtain a reference key from his natural properties.
     *
     * @param type       type of entity
     * @param properties values to add in key (means natural ids in fact)
     * @return the build key
     */
    public static String getReferenceKey(Class<?> type,
                                         Serializable... properties) {


        StringBuilder result = new StringBuilder(type.toString());

        for (Serializable serializable : properties) {
            result.append(":");
            if (serializable instanceof TopiaEntity) {
                result.append(((TopiaEntity) serializable).getTopiaId());
            } else {
                result.append(serializable);
            }
        }


        if (log.isDebugEnabled()) {
            log.debug("Looking for reference " + result.toString());
        }

        return result.toString();
    }
}
