/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.wao.ui.components;

import fr.ifremer.wao.bean.ObservationType;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.bean.SamplingFilterValues;
import fr.ifremer.wao.service.ServiceSampling;
import org.apache.tapestry5.OptionModel;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.internal.OptionModelImpl;
import org.apache.tapestry5.internal.SelectModelImpl;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.util.EnumSelectModel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class SamplingFilterComponent extends FilterComponent<SamplingFilter> {

    @Parameter(required = false)
    private Boolean showObservationTypes;

    @Parameter(required = true)
    private String legendMsg;

    /*
    * Services
    */
    @Parameter(required = true)
    private ServiceSampling serviceSampling;

    @Inject
    private Messages messages;

    /*
     * Datas
     */
    @Persist
    private SamplingFilterValues possibleValuesForFilter;

    @Override
    protected boolean isAvailableDataForFiltersOnly() {
        return false;
    }

    @Override
    public Boolean getFiltersVisible() {

        // If visible on startup
        Boolean filtersVisible = super.getFiltersVisible();
        if (filtersVisible == null) {
            filtersVisible = getVisibleOnStartup();

            // If somthing is selected
            if (!filtersVisible) {
                filtersVisible = !getFilter().isPeriodFilteredOnly();
            }
        }

        return filtersVisible;
    }

    @Override
    public void resetFilter() {
        setFilter(serviceSampling.newSamplingFilter(getUser()));
    }

    @Override
    public void updateSearchFields() {
        updatePossibleValuesForFilter();
    }

    public SamplingFilterValues getPossibleValuesForFilter() {
        return getPossibleValuesForFilter(false);
    }

    public SamplingFilterValues updatePossibleValuesForFilter() {
        return getPossibleValuesForFilter(true);
    }

    protected SamplingFilterValues getPossibleValuesForFilter(boolean update) {
        if (update || possibleValuesForFilter == null) {
            possibleValuesForFilter = serviceSampling.getPossibleValuesForFilter(getFilter());
        }
        return possibleValuesForFilter;
    }

    public Boolean getShowObservationTypes() {
        if (showObservationTypes == null) {
            showObservationTypes = true;
        }
        return showObservationTypes;
    }

    public String getLegendMsg() {
        return legendMsg;
    }

    public String getFormatForPeriod() {
        String format;
        if (getUser().isObsDeb()) {
            format = "dd/MM/yyyy";
        } else {
            format = "MM/yyyy";
        }
        return format;
    }

    private SelectModel skillZoneSelectModel;

    public SelectModel getSkillZoneSelectModel() {
        if (skillZoneSelectModel == null) {
            List<OptionModel> options = new ArrayList<OptionModel>();
            Map<String, String> skillZones = getPossibleValuesForFilter().getSkillZones();
            if (skillZones != null) {
                for (Map.Entry<String, String> skillZone : skillZones.entrySet()) {
                    options.add(new OptionModelImpl(skillZone.getValue(), skillZone.getKey()));
                }
            }
            skillZoneSelectModel = new SelectModelImpl(null, options);
        }
        return skillZoneSelectModel;
    }

    private SelectModel subPopulationSelectModel;

    public SelectModel getSubPopulationSelectModel() {
        if (subPopulationSelectModel == null) {
            List<OptionModel> options = new ArrayList<OptionModel>();
            Map<String, String> subPopulations = getPossibleValuesForFilter().getSubPopulations();
            if (subPopulations != null) {
                for (Map.Entry<String, String> skillZone : subPopulations.entrySet()) {
                    options.add(new OptionModelImpl(skillZone.getValue(), skillZone.getKey()));
                }
            }
            subPopulationSelectModel = new SelectModelImpl(null, options);
        }
        return subPopulationSelectModel;
    }

    public SelectModel getObservationTypeSelectModel() {
        ObservationType[] allowedObservationTypes = {
                                         ObservationType.FIELD_WORK_OBSERVATION,
                                         ObservationType.PHONE_CALL };
        EnumSelectModel selectModel = new EnumSelectModel(ObservationType.class,
                                            messages, allowedObservationTypes);
        return selectModel;
    }
}
