/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id: UserProfileForm.java 1426 2011-12-19 09:35:29Z bleny $
 * $HeadURL: http://svn.forge.codelutin.com/svn/wao/tags/wao-3.3.1/wao-ui/src/main/java/fr/ifremer/wao/ui/pages/UserProfileForm.java $
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoBusinessException.Type;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.components.Layout;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import org.apache.commons.lang3.StringUtils;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.BeanEditForm;
import org.apache.tapestry5.ioc.annotations.Inject;

/**
 * UserProfileForm
 *
 * Created: 10 nov. 2009
 *
 * @author fdesbois <fdesbois@codelutin.com>
 */
@RequiresAuthentication
@Import(stylesheet = "context:css/userProfile.css")
public class UserProfileForm {

    @Inject
    private ServiceUser serviceUser;

    @InjectComponent
    private Layout layout;

    @SessionState
    private ConnectedUser user;
    
    private WaoUser userEditable;

    @InjectComponent
    private BeanEditForm userForm;

    @Property
    private String password;

    @Property
    private String password2;

    public WaoUser getUserEditable() {
        if (userEditable == null) {
            userEditable = user.getUser();
        }
        return userEditable;
    }

    void onSuccessFromUserForm() throws WaoException {

        if (password != null && !password.equals(password2)) {
            userForm.recordError("Les deux password ne sont pas identiques, vérifiez la saisie !");
        } else {
            try {
                if (!StringUtils.isEmpty(password)) {
                    userEditable.setPassword(password);
                    userEditable.setPasswordChanged(true);
                }
                serviceUser.createUpdateUser(userEditable, false);
                layout.addInfo("Modifications enregistrées avec succès !");
            } catch (WaoBusinessException eee) {
                if (eee.getType().equals(Type.SMTP_NOT_FOUND)) {
                    layout.addInfo("Modifications enregistrées avec succès !");
                    layout.addInfo(eee.getMessage());
                } else {
                    userForm.recordError(eee.getMessage());
                }
            }
        }
    }


        
}
