/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id: BooleanImage.java 650 2010-10-03 15:14:48Z fdesbois $
 * $HeadURL: http://svn.forge.codelutin.com/svn/wao/tags/wao-3.2/wao-ui/src/main/java/fr/ifremer/wao/ui/components/BooleanImage.java $
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.wao.ui.components;

import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.annotations.Parameter;

/**
 * BooleanImage
 *
 * Created: 18 nov. 2009
 *
 * @author fdesbois <fdesbois@codelutin.com>
 */
public class BooleanImage {

    @Parameter(required = true)
    private Boolean value;

    @Parameter
    private boolean empty;

    @Parameter(defaultPrefix = BindingConstants.LITERAL)
    private String trueTitle;

    @Parameter(defaultPrefix = BindingConstants.LITERAL)
    private String falseTitle;

    @Parameter(defaultPrefix = BindingConstants.LITERAL)
    private String emptyTitle;

    public Boolean getValue() {
        return value;
    }

    public boolean isEmpty() {
        return empty;
    }

    public String getTrueTitle() {
        return trueTitle == null ? "yes" : trueTitle;
    }

    public String getFalseTitle() {
        return falseTitle == null ? "no" : falseTitle;
    }

    public String getEmptyTitle() {
        return emptyTitle == null ? "empty" : emptyTitle;
    }
}
