/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.services;

import fr.ifremer.wao.bean.ObsProgram;
import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.entity.Contact;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.PropertyConduit;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.services.BeanModelSource;

public class ContactModelFactory {
    protected UserRole userRole;
    protected ObsProgram obsProgram;
    protected boolean fullView;
    protected BeanModel<Contact> model;
    private PropertyConduit observationTypePropertyConduit;

    public ContactModelFactory(ObsProgram obsProgram, UserRole userRole, boolean fullView) {
        this.userRole = userRole;
        this.obsProgram = obsProgram;
        this.fullView = fullView;
    }

    protected void addNonSortableProperty(String property, PropertyConduit conduit) {
        this.model.add(property, conduit);
        this.model.get(property).sortable(false);
    }

    protected void initModel() {
        this.addNonSortableProperty("creationDate", null);
        this.addNonSortableProperty("mainObserver", this.getUserPropertyConduit());
        this.addNonSortableProperty("company", this.getCompanyPropertyConduit());
        this.addNonSortableProperty("sampleRow", this.getSampleRowPropertyConduit());
        this.addNonSortableProperty("program", this.getProgramPropertyConduit());
        this.addNonSortableProperty("professionCode", this.getProfessionCodePropertyConduit());
        this.addNonSortableProperty("professionLibelle", this.getProfessionLibellePropertyConduit());
        this.addNonSortableProperty("professionSpecies", this.getProfessionSpeciesPropertyConduit());
        this.addNonSortableProperty("expectedSamplingStrategy", this.getExpectedSamplingStrategyPropertyConduit());
        this.addNonSortableProperty("fishingZoneFacade", this.getFishingZoneFacadePropertyConduit());
        this.addNonSortableProperty("fishingZoneSector", this.getFishingZoneSectorPropertyConduit());
        this.addNonSortableProperty("fishingZoneDivision", this.getFishingZoneDivisionPropertyConduit());
        this.addNonSortableProperty("terrestrialLocation", this.getTerrestrialLocationPropertyConduit());
        this.addNonSortableProperty("boat", this.getBoatPropertyConduit());
        this.addNonSortableProperty("boatImmatriculation", this.getBoatImmatriculationPropertyConduit());
        this.addNonSortableProperty("boatDistrictCode", this.getBoatDistrictCodePropertyConduit());
        this.addNonSortableProperty("observationType", this.getObservationTypePropertyConduit());
        this.addNonSortableProperty("state", null);
        this.addNonSortableProperty("contactStateMotif", this.getContactStateMotifPropertyConduit());
        this.addNonSortableProperty("landingDate", this.getLandingDatePropertyConduit());
        this.addNonSortableProperty("observationBeginDate", null);
        this.addNonSortableProperty("observationEndDate", null);
        this.addNonSortableProperty("nbObservants", null);
        this.addNonSortableProperty("mammals", null);
        this.addNonSortableProperty("actualSamplingStrategy", this.getActualSamplingStrategyPropertyConduit());
        this.addNonSortableProperty("completeSampling", null);
        this.addNonSortableProperty("comment", null);
        this.addNonSortableProperty("dataInputDate", null);
        this.addNonSortableProperty("restitution", this.getRestitutionPropertyConduit());
        this.addNonSortableProperty("validation", null);
        this.addNonSortableProperty("commentCoordinator", this.getCommentCoordinatorPropertyConduit());
        this.addNonSortableProperty("commentAdmin", this.getCommentAdminPropertyConduit());
        this.addNonSortableProperty("dataReliability", this.getDataReliabilityPropertyConduit());
        this.addNonSortableProperty("obsDebCode", null);
        this.addNonSortableProperty("actions", null);
    }

    protected void filterModel() {
        if (this.obsProgram == ObsProgram.OBSMER) {
            this.model.exclude(new String[]{"terrestrialLocation"});
        } else {
            this.model.exclude(new String[]{"contactStateMotif", "mammals", "dataReliability", "restitution"});
        }
        if (this.obsProgram != ObsProgram.OBSVENTE) {
            this.model.exclude(new String[]{"expectedSamplingStrategy", "actualSamplingStrategy", "completeSampling"});
        }
        if (this.obsProgram == ObsProgram.OBSDEB) {
            this.model.exclude(new String[]{"professionLibelle", "professionSpecies", "fishingZoneFacade", "fishingZoneSector", "fishingZoneDivision", "professionCode", "program"});
        } else {
            this.model.exclude(new String[]{"landingDate", "observationType", "obsDebCode"});
        }
        if (this.userRole == UserRole.PROFESSIONAL) {
            this.model.exclude(new String[]{"comment", "commentCoordinator", "commentAdmin", "dataReliability", "actions"});
        } else {
            if (this.userRole != UserRole.ADMIN || !this.fullView) {
                this.model.exclude(new String[]{"observer", "company", "program", "professionCode", "professionLibelle", "professionSpecies", "fishingZoneFacade", "fishingZoneSector", "fishingZoneDivision", "boatImmatriculation", "boatDistrictCode"});
            }
            if (this.userRole != UserRole.ADMIN && this.userRole != UserRole.COORDINATOR) {
                this.model.exclude(new String[]{"dataReliability"});
            }
        }
    }

    public BeanModel<Contact> newModel(BeanModelSource beanModelSource, ComponentResources resources) {
        this.model = beanModelSource.createDisplayModel(Contact.class, resources.getMessages());
        this.model.include(new String[0]);
        this.initModel();
        this.filterModel();
        return this.model;
    }

    protected PropertyConduit getUserPropertyConduit() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected PropertyConduit getCompanyPropertyConduit() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected PropertyConduit getSampleRowPropertyConduit() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected PropertyConduit getBoatPropertyConduit() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected PropertyConduit getProgramPropertyConduit() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected PropertyConduit getProfessionCodePropertyConduit() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected PropertyConduit getProfessionLibellePropertyConduit() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected PropertyConduit getProfessionSpeciesPropertyConduit() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected PropertyConduit getFishingZoneFacadePropertyConduit() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected PropertyConduit getFishingZoneSectorPropertyConduit() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected PropertyConduit getFishingZoneDivisionPropertyConduit() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected PropertyConduit getBoatImmatriculationPropertyConduit() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected PropertyConduit getBoatDistrictCodePropertyConduit() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected PropertyConduit getCommentCoordinatorPropertyConduit() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected PropertyConduit getCommentAdminPropertyConduit() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected PropertyConduit getDataReliabilityPropertyConduit() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected PropertyConduit getActualSamplingStrategyPropertyConduit() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected PropertyConduit getExpectedSamplingStrategyPropertyConduit() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected PropertyConduit getTerrestrialLocationPropertyConduit() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected PropertyConduit getLandingDatePropertyConduit() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected PropertyConduit getObservationTypePropertyConduit() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected PropertyConduit getContactStateMotifPropertyConduit() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected PropertyConduit getRestitutionPropertyConduit() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

