/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id: Index.java 1446 2011-12-26 10:42:44Z bleny $
 * $HeadURL: http://svn.forge.codelutin.com/svn/wao/tags/wao-3.2.2/wao-ui/src/main/java/fr/ifremer/wao/ui/pages/Index.java $
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.entity.News;
import fr.ifremer.wao.service.ServiceNews;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import org.apache.tapestry5.Asset2;
import org.apache.tapestry5.PersistenceConstants;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Path;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.slf4j.Logger;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

/**
 * Index
 *
 * Created: 9 nov. 2009
 *
 * @author fdesbois <fdesbois@codelutin.com>
 */
@RequiresAuthentication
@Import(stylesheet = "context:css/news.css", library = "context:js/news.js")
public class Index {

    @Inject
    private ServiceNews serviceNews;

    @Inject
    private Logger log;

    @SessionState
    @Property
    private ConnectedUser user;

    @Persist
    private List<News> newsList;

    @Property
    private News news;

    @Persist(PersistenceConstants.FLASH)
    private String editedId;

    private DateFormat dateFormat;

    @Property
    private int rowIndex;

    @Property
    @Inject
    @Path("context:js/FCKConf.js")
    private Asset2 fckconf;

    @Inject
    private JavaScriptSupport javaScriptSupport;

    public void afterRender() {
        // Hide news details depends on an anchor named 'details' in news.getContent()
        javaScriptSupport.addScript("newsHider = new NewsHider();\n" +
                                "newsHider.hideAllNewsDetails();");
    }

    @Log
    void setupRender() throws WaoException {
        if (editedId == null || !"NEW".equals(editedId)) {
            newsList = null;
            getNewsList();
        }
    }

    public List<News> getNewsList() throws WaoException {
        if (newsList == null) {
            newsList = serviceNews.getNews(user);
        }
        return newsList;
    }

    public boolean canEditNews() {
        if (user.isReadOnly()) {
            return false;
        }
        boolean result = false;
        if (news != null) {
            // ADMIN news
            boolean adminEdit = news.isFromAdmin() && user.isAdmin();

            // COMPANY news
            boolean companyEdit = !news.isFromAdmin() && user.isCoordinator();

            result = adminEdit || companyEdit;
        } else {
            // In case of a new news
            result = user.isAdmin() || user.isCoordinator();
        }
        return result;
    }

    public String getHeaderStyle() {
        String result = "";
        if (!news.isFromAdmin()) {
            result = "company";    
        }
        return result;
    }

    public boolean isEditionMode() {
        return isCreateMode() || news.getTopiaId().equals(editedId);
    }

    public boolean isCreateMode() {
        return news.getTopiaId() == null;
    }

    public DateFormat getDateFormat() {
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        }
        return dateFormat;
    }

    private static final int NEWS_CONTENT_MAX_CHARS = 500;

    public boolean isMoreContentNeeded() {
        return news.getContent().length() > NEWS_CONTENT_MAX_CHARS;
    }

    public String getNewsContent() {
        String result = news.getContent();
        if (isMoreContentNeeded()) {
            result = result.substring(0, NEWS_CONTENT_MAX_CHARS);
        }
        return result;
    }

    public String getNewsMoreContent() {
        String content = news.getContent();
        String result = content.substring(NEWS_CONTENT_MAX_CHARS, content.length());
        return result;
    }

    void onActionFromAddNews() throws WaoException {
        news = serviceNews.newNews(user);
        // Create a new list with the new news in first position
        List<News> list = new ArrayList<News>();
        list.add(news);
        list.addAll(getNewsList());
        newsList = list;
        editedId = "NEW";
    }

    @Log
    void onActionFromEditNews(int rowIndex) throws WaoException {
        news = getNewsList().get(rowIndex);
        this.editedId = news.getTopiaId();
    }

    @Log
    void onActionFromDeleteNews(int rowIndex) throws WaoException {
        news = getNewsList().get(rowIndex);
        serviceNews.saveNews(news, true);
    }

    @Log
    void onActionFromCancelEdit() {
    }

    private News newsToSave;

    @Log
    void onSelectedFromSaveNews(int rowIndex) throws WaoException {
        if (log.isDebugEnabled()) {
            log.debug("rowIndex to save : " + rowIndex);
        }
        // XXX it seems we can't use attribute news
        newsToSave = getNewsList().get(rowIndex);
        if (log.isDebugEnabled()) {
            log.debug(newsToSave.toString());
            log.debug(newsToSave.getTitle());
        }
    }

    @Log
    void onSuccessFromNewsForm() throws WaoException {
        news = newsToSave;
        if (canEditNews()) {
            if (log.isDebugEnabled()) {
                log.debug(newsToSave.toString());
                log.debug(newsToSave.getTitle());
                log.debug(newsToSave.getContent());
            }
            //serviceNews.saveNews(news, false);
            serviceNews.saveNews(newsToSave, false);
        }
    }
        
}
