/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.ObsProgram;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.bean.SamplingFilterImpl;
import fr.ifremer.wao.bean.SamplingStrategy;
import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.bean.ValidationResult;
import fr.ifremer.wao.entity.Boat;
import fr.ifremer.wao.entity.Company;
import fr.ifremer.wao.entity.DCF5Code;
import fr.ifremer.wao.entity.FishingGearDCF;
import fr.ifremer.wao.entity.FishingZone;
import fr.ifremer.wao.entity.Profession;
import fr.ifremer.wao.entity.ProfessionImpl;
import fr.ifremer.wao.entity.SampleMonth;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.entity.SampleRowLog;
import fr.ifremer.wao.entity.TargetSpeciesDCF;
import fr.ifremer.wao.entity.TerrestrialDivision;
import fr.ifremer.wao.entity.TerrestrialLocation;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.service.ServiceBoat;
import fr.ifremer.wao.service.ServiceReferential;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.data.GenericSelectModel;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.data.WaoActivationContext;
import fr.ifremer.wao.ui.data.WaoPropertyChangeListener;
import fr.ifremer.wao.ui.pages.ObsDebSamplingPlan;
import fr.ifremer.wao.ui.pages.SamplingPlan;
import fr.ifremer.wao.ui.services.WaoManager;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.InjectPage;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.internal.OptionModelImpl;
import org.apache.tapestry5.internal.SelectModelImpl;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.services.BeanModelSource;
import org.nuiton.i18n.I18n;
import org.nuiton.util.PeriodDates;
import org.nuiton.util.StringUtil;
import org.slf4j.Logger;

@RequiresAuthentication(allowedRoles={UserRole.ADMIN, UserRole.COORDINATOR}, readOnlyAllowed=false)
@Import(stylesheet={"context:css/sampling.css"})
public class SampleRowForm {
    @Inject
    private Logger log;
    @Inject
    private ServiceSampling serviceSampling;
    @Inject
    private ServiceReferential serviceReferential;
    @Inject
    private ServiceUser serviceUser;
    @Inject
    private ServiceBoat serviceBoat;
    @Inject
    private Messages messages;
    @SessionState
    @Property
    private ConnectedUser user;
    @Inject
    private PropertyAccess propertyAccess;
    private boolean edited;
    private WaoActivationContext waoActivationContext;
    @Inject
    private Block obsDebBlock;
    @Inject
    private Block obsMerVenteBlock;
    @Persist
    private GenericSelectModel<SampleRow> professionSelectModel;
    @Property
    private String professionId;
    @Inject
    private BeanModelSource beanModelSource;
    @Inject
    private ComponentResources resources;
    private String dcf5codes;
    @Persist
    private GenericSelectModel<FishingZone> fishingZoneSelectModel;
    @Property
    private String fishingZoneId;
    @Property
    private FishingZone fishingZone;
    @Property
    private int indexFishingZone;
    @InjectComponent
    private Field fishingZoneSelect;
    private GenericSelectModel<TerrestrialLocation> terrestrialLocationSelectModel;
    @Property
    private String terrestrialLocationId;
    @Inject
    private WaoManager manager;
    @Persist
    private SelectModel programSelectModel;
    @Property
    private String programName;
    @Property
    private String programId;
    private PeriodDates period;
    @Persist
    private List<SampleMonth> sampleMonths;
    @Property
    private int monthIndex;
    @Property
    private SampleMonth sampleMonth;
    @InjectComponent
    private Field programPeriodBegin;
    @InjectComponent
    private Field programPeriodEnd;
    @InjectComponent
    private Field program;
    private boolean periodChanged;
    private String sampleRowId;
    @Persist
    private SampleRow sampleRow;
    private BeanModel<SampleRow> sampleRowModel;
    @InjectComponent
    private Form sampleRowForm;
    @InjectComponent
    private Field updateComment;
    @Persist
    private SampleRowLog sampleRowLog;
    @Property
    private String immatriculations;
    @Property
    private String companyId;
    private List<Boat> boats;
    private GenericSelectModel<Company> companySelectModel;
    private boolean cancel;
    @Persist
    private WaoPropertyChangeListener propertyChange;
    @InjectPage
    private SamplingPlan samplingPlan;
    @InjectPage
    private ObsDebSamplingPlan obsDebSamplingPlan;

    void onActivate(EventContext ec) {
        this.waoActivationContext = WaoActivationContext.newContextFromTapestry((EventContext)ec);
        this.sampleRowId = this.waoActivationContext.getSampleRowId();
    }

    String[] onPassivate() {
        this.waoActivationContext = WaoActivationContext.newEmptyContext();
        this.waoActivationContext.setSampleRowId(this.sampleRowId);
        return this.waoActivationContext.toStrings();
    }

    void setupRender() throws WaoException {
        this.sampleRow = null;
        this.getSampleRow();
        this.sampleMonths = null;
        this.getSampleMonths();
        this.sampleRowLog = null;
        this.getSampleRowLog();
        this.professionSelectModel = null;
        this.getProfessionSelectModel();
        this.programSelectModel = null;
        this.getProgramSelectModel();
        this.fishingZoneSelectModel = null;
        this.getFishingZoneSelectModel();
        this.companySelectModel = null;
        this.getCompanySelectModel();
        this.professionId = null;
        this.sampleRowForm.clearErrors();
        this.programId = !this.isCreateMode() ? this.getSampleRow().getProgramName() : null;
        Company company = this.getSampleRow().getCompany();
        if (company != null) {
            this.companyId = company.getTopiaId();
        }
        this.immatriculations = this.getSampleRow().getMainElligibleBoatsAsString();
        if (this.getSampleRow().getTerrestrialLocation() != null) {
            this.terrestrialLocationId = this.getSampleRow().getTerrestrialLocation().getTopiaId();
        }
    }

    public boolean showObsVente() {
        return this.user.getProfile().getObsProgram() == ObsProgram.OBSVENTE;
    }

    public Block getProgramBlock() {
        Block block = ObsProgram.OBSDEB.equals((Object)this.sampleRow.getObsProgram()) ? this.obsDebBlock : this.obsMerVenteBlock;
        return block;
    }

    public GenericSelectModel<SampleRow> getProfessionSelectModel() throws WaoException {
        if (this.professionSelectModel == null) {
            List professions = this.serviceSampling.getSampleRowsByFilter((SamplingFilter)new SamplingFilterImpl());
            this.professionSelectModel = new GenericSelectModel(professions, SampleRow.class, "professionDescription", "topiaId", this.propertyAccess);
        }
        return this.professionSelectModel;
    }

    public BeanModel<Profession> getProfessionModel() {
        BeanModel professionModel = this.beanModelSource.createDisplayModel(Profession.class, this.resources.getMessages());
        professionModel.exclude(new String[]{"topiaId"});
        professionModel.exclude(new String[]{"topiaCreateDate"});
        professionModel.exclude(new String[]{"topiaVersion"});
        return professionModel;
    }

    void onSelectedFromAddNewProfession() throws WaoException {
        ProfessionImpl profession = new ProfessionImpl();
        if (!StringUtils.isEmpty((CharSequence)this.professionId)) {
            SampleRow professionSelected = (SampleRow)this.getProfessionSelectModel().findObject(this.professionId);
            if (this.log.isDebugEnabled()) {
                this.log.debug("add new profession from : " + professionSelected);
            }
            profession = this.serviceSampling.getNewProfession(professionSelected.getProfession());
            this.getSampleRow().setdCF5Code(professionSelected.getdCF5Code());
            this.dcf5codes = null;
        }
        this.getSampleRow().setProfession((Profession)profession);
        this.edited = true;
    }

    public String getDcf5codes() {
        if (this.dcf5codes == null) {
            Collection codes = this.getSampleRow().getdCF5Code();
            this.dcf5codes = CollectionUtils.isEmpty((Collection)codes) ? "" : StringUtil.join((Iterable)codes, (String)", ", (boolean)true);
        }
        return this.dcf5codes;
    }

    public void setDcf5codes(String dcf5codes) {
        this.dcf5codes = dcf5codes;
    }

    public GenericSelectModel<FishingZone> getFishingZoneSelectModel() throws WaoException {
        if (this.fishingZoneSelectModel == null) {
            List zones = this.serviceReferential.getFishingZones();
            this.fishingZoneSelectModel = new GenericSelectModel(zones, FishingZone.class, "code", "topiaId", this.propertyAccess);
        }
        return this.fishingZoneSelectModel;
    }

    public List<FishingZone> getFishingZones() throws WaoException {
        return this.getSampleRow().getFishingZone();
    }

    void onSelectedFromAddFishingZone() throws WaoException {
        this.fishingZone = (FishingZone)this.getFishingZoneSelectModel().findObject(this.fishingZoneId);
        if (!this.getFishingZones().contains(this.fishingZone)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Add new fishingZone");
            }
            this.getFishingZones().add(this.fishingZone);
        }
        this.edited = true;
    }

    void onSelectedFromRemoveFishingZone(int index) throws WaoException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Remove fishingZone at position : " + index);
        }
        ArrayList fishingZones = new ArrayList(this.getSampleRow().getFishingZone());
        fishingZones.remove(index);
        this.getSampleRow().setFishingZone(fishingZones);
        this.edited = true;
    }

    public GenericSelectModel<TerrestrialLocation> getTerrestrialLocationSelectModel() {
        if (this.terrestrialLocationSelectModel == null) {
            List locations = this.serviceReferential.getAllTerrestrialDistricts((SamplingFilter)new SamplingFilterImpl());
            this.terrestrialLocationSelectModel = new GenericSelectModel(locations, TerrestrialLocation.class, "districtName", "topiaId", this.propertyAccess);
        }
        return this.terrestrialLocationSelectModel;
    }

    public SelectModel getProgramSelectModel() throws WaoException {
        if (this.programSelectModel == null) {
            ArrayList<OptionModelImpl> options = new ArrayList<OptionModelImpl>();
            for (String name : this.serviceSampling.getPrograms(null)) {
                options.add(new OptionModelImpl(name, (Object)name));
            }
            this.programSelectModel = new SelectModelImpl(null, options);
        }
        return this.programSelectModel;
    }

    public PeriodDates getPeriod() throws WaoException {
        if (this.period == null) {
            Date begin = this.getSampleRow().getPeriodBegin();
            Date end = this.getSampleRow().getPeriodEnd();
            this.period = new PeriodDates(begin, end);
        }
        return this.period;
    }

    public List<SampleMonth> getSampleMonths() throws WaoException {
        if (this.sampleMonths == null) {
            this.sampleMonths = new ArrayList();
            for (Date currMonth : this.getPeriod().getMonths()) {
                SampleMonth curr = this.getSampleRow().getSampleMonth(currMonth);
                if (curr != null) {
                    this.sampleMonths.add(curr);
                    continue;
                }
                if (!this.periodChanged) continue;
                if (curr == null) {
                    curr = this.serviceSampling.getNewSampleMonth(currMonth, this.getSampleRow());
                    curr.addPropertyChangeListener("expectedTidesValue", (PropertyChangeListener)this.propertyChange);
                }
                this.sampleMonths.add(curr);
            }
        }
        return this.sampleMonths;
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("MM/yyyy");
    }

    public String getMonthStyle() {
        String style = " ";
        Date current = this.manager.getCurrentDate();
        if (this.sampleMonth.isCurrentMonth()) {
            style = style + "selected";
        } else if (current.after(this.sampleMonth.getPeriodDate())) {
            style = style + "even";
        }
        return style;
    }

    @Log
    void onSelectedFromRefreshMonths() throws WaoException {
        this.getSampleRow().setPeriod(this.period);
        this.periodChanged = true;
        this.sampleMonths = null;
        this.getSampleMonths();
        this.saveProgram();
    }

    protected void saveProgram() throws WaoException {
        if (StringUtils.isNotEmpty((CharSequence)this.programName)) {
            this.getSampleRow().setProgramName(this.programName);
            this.programId = null;
        } else if (StringUtils.isNotEmpty((CharSequence)this.programId)) {
            this.getSampleRow().setProgramName(this.programId);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Program : " + this.getSampleRow().getProgramName());
        }
    }

    public String getExpectedDateFormat() {
        if (this.getSampleRow().getObservationType() == null) {
            throw new NullPointerException();
        }
        String expectedDateFormat = this.getSampleRow().isPhoneCall() ? "'semaine' w, yyyy" : "dd/MM/yyyy";
        return expectedDateFormat;
    }

    public List<WaoUser> getObservers() {
        List observers = this.serviceUser.getObservers(this.getSampleRow().getCompany(), true);
        return observers;
    }

    public List<TerrestrialDivision> getObservationUnits() {
        List observationUnits = this.serviceReferential.getAllObservationUnits();
        return observationUnits;
    }

    public List<Boat> getBoats() {
        List boats = this.serviceBoat.getAllActiveBoats();
        return boats;
    }

    public List<TerrestrialLocation> getRegionIfremers() {
        List regionIfremers = this.serviceReferential.getAllRegionIfremers();
        return regionIfremers;
    }

    public SampleRow getSampleRow() throws WaoException {
        if (this.sampleRow == null) {
            if (StringUtils.isEmpty((CharSequence)this.sampleRowId)) {
                this.sampleRow = this.serviceSampling.newSampleRow(this.user);
                if (this.sampleRow.getObsProgram() == ObsProgram.OBSDEB) {
                    this.sampleRow.setObservationType(this.waoActivationContext.getObservationType());
                }
            } else {
                this.sampleRow = this.serviceSampling.getSampleRow(this.sampleRowId);
                for (SampleMonth month : this.sampleRow.getSampleMonth()) {
                    month.addPropertyChangeListener("expectedTidesValue", (PropertyChangeListener)this.propertyChange);
                }
            }
            this.propertyChange = new WaoPropertyChangeListener();
        }
        return this.sampleRow;
    }

    public SampleRowLog getSampleRowLog() throws WaoException {
        if (this.sampleRowLog == null) {
            this.sampleRowLog = this.serviceSampling.getNewSampleRowLog(this.getSampleRow(), this.user);
        }
        return this.sampleRowLog;
    }

    public BeanModel<SampleRow> getSampleRowModel() {
        if (this.sampleRowModel == null) {
            this.sampleRowModel = this.beanModelSource.createEditModel(SampleRow.class, this.resources.getMessages());
            if (this.user.isObsDeb()) {
                if (this.getSampleRow().isFieldWorkObservation()) {
                    this.sampleRowModel.include(new String[]{"comment", "blankRow"});
                } else {
                    this.sampleRowModel.include(new String[]{"comment"});
                }
            } else {
                this.sampleRowModel.add("company", null);
                this.sampleRowModel.add("boats", null);
                if (this.user.getProfile().getObsProgram() == ObsProgram.OBSMER) {
                    this.sampleRowModel.include(new String[]{"code", "company", "nbObservants", "averageTideTime", "boats", "comment", "appliedCoverageRate"});
                }
                if (this.user.getProfile().getObsProgram() == ObsProgram.OBSVENTE) {
                    this.sampleRowModel.include(new String[]{"code", "company", "boats", "comment"});
                    this.sampleRowModel.add("samplingStrategy");
                }
            }
        }
        return this.sampleRowModel;
    }

    public GenericSelectModel<Company> getCompanySelectModel() throws WaoException {
        if (this.companySelectModel == null) {
            List companies = this.serviceUser.getCompanies(true);
            this.companySelectModel = new GenericSelectModel(companies, Company.class, "name", "topiaId", this.propertyAccess);
        }
        return this.companySelectModel;
    }

    public List<Company> getCompanies() throws WaoException {
        List companies = this.serviceUser.getCompanies(true);
        return companies;
    }

    public boolean isCreateMode() throws WaoException {
        return StringUtils.isEmpty((CharSequence)this.getSampleRow().getTopiaId());
    }

    void onSelectedFromCancelSave() {
        this.cancel = true;
    }

    void onSelectedFromSaveData() throws WaoException {
        this.saveProgram();
    }

    @Log
    void onValidateFormFromSampleRowForm() throws WaoException {
        this.sampleRowForm.clearErrors();
        if (ObsProgram.OBSDEB == this.getSampleRow().getObsProgram()) {
            ValidationResult validationResult = this.serviceSampling.validateSampleRow(this.getSampleRow());
            boolean commentLogIsExpected = !this.isCreateMode();
            boolean commentLogIsEmpty = StringUtils.isBlank((CharSequence)this.getSampleRowLog().getComment());
            if (commentLogIsExpected && commentLogIsEmpty) {
                this.sampleRowForm.recordError(this.messages.get(I18n.n_((String)"wao.ui.form.SampleRow.error.missingLogComment", (Object[])new Object[0])));
            }
            if (!validationResult.isSuccess()) {
                this.sampleRowForm.recordError(validationResult.getMessage());
            }
        } else {
            if (StringUtils.isNotEmpty((CharSequence)this.terrestrialLocationId)) {
                this.getSampleRow().setTerrestrialLocation((TerrestrialLocation)this.getTerrestrialLocationSelectModel().findObject(this.terrestrialLocationId));
            }
            ArrayList<SampleMonth> sampleMonths = new ArrayList<SampleMonth>();
            for (SampleMonth sampleMonth : this.getSampleMonths()) {
                if (sampleMonth.getExpectedTidesValue() == -1) continue;
                sampleMonths.add(sampleMonth);
            }
            this.getSampleRow().clearSampleMonth();
            this.getSampleRow().addAllSampleMonth(sampleMonths);
            try {
                if (!this.cancel && !this.edited) {
                    if (StringUtils.isEmpty((CharSequence)this.getSampleRow().getProgramName())) {
                        this.sampleRowForm.recordError(this.program, "Vous devez choisir un programme existant ou en cr\u00e9er un nouveau");
                    }
                    this.getSampleRow().setDCF5Code(this.getDcf5codes(), ", ");
                    if (CollectionUtils.isEmpty((Collection)this.getSampleRow().getdCF5Code())) {
                        this.sampleRowForm.recordError("Vous devez associer au moins un code DCF5");
                    } else {
                        SamplingFilterImpl noFilter = new SamplingFilterImpl();
                        LinkedList<String> existingFishingGearCodes = new LinkedList<String>();
                        for (FishingGearDCF dcfGear : this.serviceSampling.getDCFGears((SamplingFilter)noFilter)) {
                            existingFishingGearCodes.add(dcfGear.getCode());
                        }
                        LinkedList<String> existingTargetSpeciesCodes = new LinkedList<String>();
                        for (TargetSpeciesDCF dcfSpecies : this.serviceSampling.getDCFSpecies((SamplingFilter)noFilter)) {
                            existingTargetSpeciesCodes.add(dcfSpecies.getCode());
                        }
                        for (DCF5Code code : this.getSampleRow().getdCF5Code()) {
                            if (!existingFishingGearCodes.contains(code.getFishingGearCode())) {
                                this.sampleRowForm.recordError(code.getFishingGearCode() + " n'est pas un code d'engin valide");
                            }
                            if (StringUtils.isEmpty((CharSequence)code.getTargetSpeciesCode())) {
                                if (!StringUtils.isEmpty((CharSequence)this.getSampleRow().getProfession().getSpecies())) continue;
                                this.sampleRowForm.recordError("Le code DCF d'esp\u00e8ces cibles peut ne pas \u00eatre renseign\u00e9, mais dans ce cas il faut pr\u00e9ciser une description des esp\u00e8ces cibles");
                                continue;
                            }
                            if (existingTargetSpeciesCodes.contains(code.getTargetSpeciesCode())) continue;
                            this.sampleRowForm.recordError(code.getTargetSpeciesCode() + " n'est pas un code d'esp\u00e8ces cibles valide");
                        }
                    }
                    Date periodBegin = this.getSampleRow().getPeriodBegin();
                    Date periodEnd = this.getSampleRow().getPeriodEnd();
                    if (periodBegin == null) {
                        this.sampleRowForm.recordError(this.programPeriodBegin, "Vous ne pouvez pas rafra\u00eechir les mois avec une date de d\u00e9but de programme vide");
                    }
                    if (periodEnd == null) {
                        this.sampleRowForm.recordError(this.programPeriodEnd, "Vous ne pouvez pas rafra\u00eechir les mois avec une date de fin de programme vide");
                    }
                    if (periodBegin != null && periodEnd != null) {
                        Date firstDate;
                        SampleMonth firstMonth = (SampleMonth)this.getSampleMonths().get(0);
                        if (firstMonth != null && periodBegin.after(firstDate = firstMonth.getPeriodDate()) && firstMonth.getRealTidesValue() != 0) {
                            this.sampleRowForm.recordError(this.programPeriodBegin, "Vous ne pouvez pas r\u00e9duire la p\u00e9riode du programme. Il existe des enregistrements de mar\u00e9es r\u00e9els.");
                        }
                        for (SampleMonth month : this.getSampleMonths()) {
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("month : " + month.formatMonth() + " _ " + this.propertyChange.hasChanged(month.getTopiaId()));
                            }
                            if (!this.propertyChange.hasChanged(month.getTopiaId()) || month.getExpectedTidesValue() >= month.getRealTidesValue()) continue;
                            this.sampleRowForm.recordError("Il n'est pas possible de mettre moins de mar\u00e9es (" + month.getExpectedTidesValue() + ") " + "pour le mois " + this.getDateFormat().format(month.getPeriodDate()) + " qu'il y en a de r\u00e9els (" + month.getRealTidesValue() + ")");
                        }
                    }
                    if (!this.periodChanged) {
                        int nbZones;
                        if (!this.isCreateMode() && StringUtils.isEmpty((CharSequence)this.sampleRowLog.getComment())) {
                            this.sampleRowForm.recordError(this.updateComment, "Un commentaire est obligatoire lors d'une modification de la ligne");
                        }
                        if (CollectionUtils.isEmpty((Collection)this.getSampleRow().getdCF5Code())) {
                            this.sampleRowForm.recordError("Le m\u00e9tier doit obligatoirement avoir un Code DCF niveau 5");
                        }
                        if ((nbZones = this.getSampleRow().sizeFishingZone()) == 0) {
                            this.sampleRowForm.recordError(this.fishingZoneSelect, "Vous devez ajouter au moins une zone de p\u00eache \u00e0 la ligne");
                        }
                        this.boats = this.serviceBoat.getBoatsByImmatriculations(this.immatriculations);
                    } else if (this.isCreateMode()) {
                        String rowCode = this.serviceSampling.getNewSampleRowCode(periodBegin);
                        this.getSampleRow().setCode(rowCode);
                    }
                    if (this.sampleRow.getSamplingStrategy() == SamplingStrategy.SPECIFIC_STOCK && StringUtils.isEmpty((CharSequence)this.getSampleRow().getProfession().getSpecies())) {
                        this.sampleRowForm.recordError("Pour ce choix de strat\u00e9gie d'\u00e9chantillonnage, il faut pr\u00e9ciser les esp\u00e8ces cibles");
                    }
                }
            }
            catch (WaoBusinessException eee) {
                this.sampleRowForm.recordError(eee.getMessage());
                this.log.error("BUSINESS ERROR : " + eee.getType() + " depuis " + eee.getServiceName() + " : " + eee.getMessage());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("SampleMonths : " + this.getSampleMonths());
            }
        }
    }

    @Log
    Object onSuccessFromSampleRowForm() throws WaoException {
        if (this.cancel) {
            return this;
        }
        if (!this.edited && !this.periodChanged) {
            if (this.user.isAdmin() && !this.user.isObsDeb() && !this.getSampleRow().hasSampleMonthRealTideTime()) {
                Company company = (Company)this.getCompanySelectModel().findObject(this.companyId);
                this.getSampleRow().setCompany(company);
            }
            if (this.getSampleRow().getObsProgram() != ObsProgram.OBSDEB) {
                this.getSampleRow().setSampleMonth(this.getSampleMonths());
                this.getSampleRow().setDCF5Code(this.getDcf5codes(), ", ");
            }
            this.serviceSampling.createUpdateSampleRow(this.sampleRow, this.boats, this.getSampleRowLog(), this.user);
            if (this.user.isObsDeb()) {
                this.obsDebSamplingPlan.setObservationType(this.sampleRow.getObservationType());
                return this.obsDebSamplingPlan;
            }
            this.samplingPlan.setSelectedRowId(this.sampleRow.getTopiaId());
            return this.samplingPlan;
        }
        this.professionId = null;
        return this.sampleRowForm;
    }

    @Log
    Object onFailureFromSampleRowForm() {
        return this.sampleRowForm;
    }
}

