/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.wao.ui.data;

import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.WaoUtils;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.service.ServiceSampling;
import org.apache.tapestry5.grid.SortConstraint;

import java.util.List;
import java.util.Map;

public class SampleRowDataSource extends AbstractMappedGridDataSource<String, SampleRow> {

    protected SamplingFilter filter;

    protected ServiceSampling serviceSampling;

    public SampleRowDataSource(SamplingFilter filter, ServiceSampling serviceSampling) {
        this.filter = filter;
        this.serviceSampling = serviceSampling;
    }

    @Override
    protected Map<String, SampleRow> execute(int startIndex, int endIndex, SortConstraint orderBy) throws WaoException {
        filter.setStartIndex(startIndex);
        filter.setEndIndex(endIndex);
        List<SampleRow> sampleRows = serviceSampling.getSampleRowsByFilter(filter);
        Map<String, SampleRow> result = WaoUtils.projectPropertyUnique(sampleRows, SampleRow.TOPIA_ID);
        return result;
    }

    @Override
    protected int count() throws WaoException {
        int count = serviceSampling.countSampleRows(filter);
        return count;
    }

    @Override
    public Class<?> getRowType() {
        return SampleRow.class;
    }
}
