/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.components;

import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.BoatFilter;
import fr.ifremer.wao.bean.BoatFilterValues;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.service.ServiceBoat;
import fr.ifremer.wao.ui.components.FeedBack;
import fr.ifremer.wao.ui.components.FilterComponent;
import java.util.List;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.annotations.Inject;

public class BoatFilterComponent
extends FilterComponent<BoatFilter> {
    @SessionState
    @Property
    private ConnectedUser connectedUser;
    @InjectComponent
    private FeedBack filterFeedback;
    @Inject
    private ServiceBoat serviceBoat;
    @Persist
    private BoatFilterValues possibleValuesForFilter;

    protected boolean isAvailableDataForFiltersOnly() {
        return false;
    }

    public void resetFilter() {
        this.setFilter((SamplingFilter)this.serviceBoat.newBoatFilter(this.getUser()));
    }

    public void updateSearchFields() {
        this.updatePossibleValuesForFilter();
    }

    public BoatFilterValues getPossibleValuesForFilter() {
        return this.getPossibleValuesForFilter(false);
    }

    public BoatFilterValues updatePossibleValuesForFilter() {
        return this.getPossibleValuesForFilter(true);
    }

    protected BoatFilterValues getPossibleValuesForFilter(boolean update) {
        if (update || this.possibleValuesForFilter == null) {
            this.possibleValuesForFilter = this.serviceBoat.getPossibleValuesForFilter((BoatFilter)this.getFilter());
        }
        return this.possibleValuesForFilter;
    }

    public String[] getShipOwnerNamesContains(String input) {
        List results = this.serviceBoat.getShipOwnerNamesContains(input);
        return results.toArray(new String[results.size()]);
    }

    public String[] getBoatNamesStartWith(String input) {
        List results = this.serviceBoat.getBoatNamesStartWith(input);
        return results.toArray(new String[results.size()]);
    }

    public void setSampleRow(SampleRow sampleRow) {
        ((BoatFilter)this.getFilter()).setSampleRow(sampleRow);
    }

    public String[] onProvideCompletionsFromShipOwnerName(String input) {
        return this.getShipOwnerNamesContains(input);
    }

    public String[] onProvideCompletionsFromBoatName(String input) throws WaoException {
        return this.getBoatNamesStartWith(input);
    }
}

