/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import winstone.ClientSocketException;
import winstone.HostConfiguration;
import winstone.Launcher;
import winstone.Logger;
import winstone.RequestDispatcher;
import winstone.WebAppConfiguration;
import winstone.WinstoneOutputStream;
import winstone.WinstoneRequest;
import winstone.WinstoneResponseWriter;
import winstone.WinstoneSession;

public class WinstoneResponse
implements HttpServletResponse {
    private static final DateFormat HTTP_DF = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
    private static final DateFormat VERSION0_DF = new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss z", Locale.US);
    static final String CONTENT_LENGTH_HEADER = "Content-Length";
    static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String CONTENT_LANGUAGE_HEADER = "Content-Language";
    private static final String KEEP_ALIVE_HEADER = "Connection";
    private static final String KEEP_ALIVE_OPEN = "Keep-Alive";
    private static final String KEEP_ALIVE_CLOSE = "Close";
    private static final String DATE_HEADER = "Date";
    private static final String LOCATION_HEADER = "Location";
    private static final String OUT_COOKIE_HEADER1 = "Set-Cookie";
    private static final String X_POWERED_BY_HEADER = "X-Powered-By";
    private static final String X_POWERED_BY_HEADER_VALUE;
    private int statusCode = 200;
    private WinstoneRequest req;
    private WebAppConfiguration webAppConfig;
    private WinstoneOutputStream outputStream;
    private PrintWriter outputWriter;
    private List headers = new ArrayList();
    private String explicitEncoding = null;
    private String implicitEncoding;
    private List cookies = new ArrayList();
    private Locale locale = null;
    private String protocol = null;
    private String reqKeepAliveHeader = null;
    private Integer errorStatusCode;
    private static final String specialCharacters = "()<>@,;:\\\"/[]?={} \t";

    public void cleanUp() {
        this.req = null;
        this.webAppConfig = null;
        this.outputStream = null;
        this.outputWriter = null;
        this.headers.clear();
        this.cookies.clear();
        this.protocol = null;
        this.reqKeepAliveHeader = null;
        this.statusCode = 200;
        this.errorStatusCode = null;
        this.locale = null;
        this.explicitEncoding = null;
        this.implicitEncoding = null;
    }

    private String getEncodingFromLocale(Locale loc) {
        String localeString = loc.getLanguage() + "_" + loc.getCountry();
        Map encMap = this.webAppConfig.getLocaleEncodingMap();
        Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WinstoneResponse.LookForLocaleEncoding", new String[]{localeString, encMap + ""});
        String fullMatch = (String)encMap.get(localeString);
        if (fullMatch != null) {
            Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WinstoneResponse.FoundLocaleEncoding", fullMatch);
            return fullMatch;
        }
        localeString = loc.getLanguage();
        Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WinstoneResponse.LookForLocaleEncoding", new String[]{localeString, encMap + ""});
        String match = (String)encMap.get(localeString);
        if (match != null) {
            Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WinstoneResponse.FoundLocaleEncoding", match);
        }
        return match;
    }

    public void setErrorStatusCode(int statusCode) {
        this.errorStatusCode = new Integer(statusCode);
        this.statusCode = statusCode;
    }

    public WinstoneOutputStream getWinstoneOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(WinstoneOutputStream outData) {
        this.outputStream = outData;
    }

    public void setWebAppConfig(WebAppConfiguration webAppConfig) {
        this.webAppConfig = webAppConfig;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void extractRequestKeepAliveHeader(WinstoneRequest req) {
        this.reqKeepAliveHeader = req.getHeader(KEEP_ALIVE_HEADER);
    }

    public List getHeaders() {
        return this.headers;
    }

    public List getCookies() {
        return this.cookies;
    }

    public WinstoneRequest getRequest() {
        return this.req;
    }

    public void setRequest(WinstoneRequest req) {
        this.req = req;
    }

    public void startIncludeBuffer() {
        this.outputStream.startIncludeBuffer();
    }

    public void finishIncludeBuffer() throws IOException {
        if (this.isIncluding()) {
            if (this.outputWriter != null) {
                this.outputWriter.flush();
            }
            this.outputStream.finishIncludeBuffer();
        }
    }

    public void clearIncludeStackForForward() throws IOException {
        this.outputStream.clearIncludeStackForForward();
    }

    protected static String getCharsetFromContentTypeHeader(String type, StringBuffer remainder) {
        if (type == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(type, ";");
        String localEncoding = null;
        while (st.hasMoreTokens()) {
            String clause = st.nextToken().trim();
            if (clause.startsWith("charset=")) {
                localEncoding = clause.substring(8);
                continue;
            }
            if (remainder.length() > 0) {
                remainder.append(";");
            }
            remainder.append(clause);
        }
        if (localEncoding == null || !localEncoding.startsWith("\"") || !localEncoding.endsWith("\"")) {
            return localEncoding;
        }
        return localEncoding.substring(1, localEncoding.length() - 1);
    }

    public void validateHeaders() {
        String sessionId;
        String prefix;
        String lengthHeader = this.getHeader(CONTENT_LENGTH_HEADER);
        if (lengthHeader == null && this.statusCode >= 300) {
            int bodyBytes = this.outputStream.getOutputStreamLength();
            if (this.getBufferSize() > bodyBytes) {
                Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WinstoneResponse.ForcingContentLength", "" + bodyBytes);
                this.forceHeader(CONTENT_LENGTH_HEADER, "" + bodyBytes);
                lengthHeader = this.getHeader(CONTENT_LENGTH_HEADER);
            }
        }
        this.forceHeader(KEEP_ALIVE_HEADER, !this.closeAfterRequest() ? KEEP_ALIVE_OPEN : KEEP_ALIVE_CLOSE);
        String contentType = this.getHeader(CONTENT_TYPE_HEADER);
        if (this.statusCode != 302) {
            if (contentType == null) {
                this.forceHeader(CONTENT_TYPE_HEADER, "text/html;charset=" + this.getCharacterEncoding());
            } else if (contentType.startsWith("text/")) {
                StringBuffer remainder = new StringBuffer();
                WinstoneResponse.getCharsetFromContentTypeHeader(contentType, remainder);
                this.forceHeader(CONTENT_TYPE_HEADER, remainder.toString() + ";charset=" + this.getCharacterEncoding());
            }
        }
        if (this.getHeader(DATE_HEADER) == null) {
            this.forceHeader(DATE_HEADER, WinstoneResponse.formatHeaderDate(new Date()));
        }
        if (this.getHeader(X_POWERED_BY_HEADER) == null) {
            this.forceHeader(X_POWERED_BY_HEADER, X_POWERED_BY_HEADER_VALUE);
        }
        if (this.locale != null) {
            String lang = this.locale.getLanguage();
            if (this.locale.getCountry() != null && !this.locale.getCountry().equals("")) {
                lang = lang + "-" + this.locale.getCountry();
            }
            this.forceHeader(CONTENT_LANGUAGE_HEADER, lang);
        }
        if (this.req.getWebAppConfig() == null) {
            return;
        }
        HostConfiguration hostConfig = this.req.getHostGroup().getHostByName(this.req.getServerName());
        Iterator i = this.req.getCurrentSessionIds().keySet().iterator();
        while (i.hasNext()) {
            WinstoneSession session;
            prefix = (String)i.next();
            sessionId = (String)this.req.getCurrentSessionIds().get(prefix);
            WebAppConfiguration ownerContext = hostConfig.getWebAppByURI(prefix);
            if (ownerContext == null || (session = ownerContext.getSessionById(sessionId, true)) == null || !session.isNew()) continue;
            session.setIsNew(false);
            Cookie cookie = new Cookie("JSESSIONID", session.getId());
            cookie.setMaxAge(-1);
            cookie.setSecure(this.req.isSecure());
            cookie.setVersion(0);
            cookie.setPath(this.req.getWebAppConfig().getContextPath().equals("") ? "/" : this.req.getWebAppConfig().getContextPath());
            this.cookies.add(cookie);
        }
        i = this.req.getRequestedSessionIds().keySet().iterator();
        while (i.hasNext()) {
            prefix = (String)i.next();
            sessionId = (String)this.req.getRequestedSessionIds().get(prefix);
            if (this.req.getCurrentSessionIds().containsKey(prefix)) continue;
            Cookie cookie = new Cookie("JSESSIONID", sessionId);
            cookie.setMaxAge(0);
            cookie.setSecure(this.req.isSecure());
            cookie.setVersion(0);
            cookie.setPath(prefix.equals("") ? "/" : prefix);
            this.cookies.add(cookie);
        }
        Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WinstoneResponse.HeadersPreCommit", this.headers + "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeCookie(Cookie cookie) throws IOException {
        Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WinstoneResponse.WritingCookie", cookie + "");
        StringBuffer out = new StringBuffer();
        if (cookie.getVersion() >= 1) {
            out.append(OUT_COOKIE_HEADER1).append(": ");
        } else {
            out.append(OUT_COOKIE_HEADER1).append(": ");
        }
        if (cookie.getVersion() == 0) {
            out.append(cookie.getName()).append("=").append(cookie.getValue());
        } else {
            out.append(cookie.getName()).append("=");
            WinstoneResponse.quote(cookie.getValue(), out);
        }
        if (cookie.getVersion() >= 1) {
            out.append("; Version=1");
            if (cookie.getDomain() != null) {
                out.append("; Domain=");
                WinstoneResponse.quote(cookie.getDomain(), out);
            }
            if (cookie.getSecure()) {
                out.append("; Secure");
            }
            if (cookie.getMaxAge() >= 0) {
                out.append("; Max-Age=").append(cookie.getMaxAge());
            } else {
                out.append("; Discard");
            }
            if (cookie.getPath() != null) {
                out.append("; Path=");
                WinstoneResponse.quote(cookie.getPath(), out);
            }
        } else {
            if (cookie.getDomain() != null) {
                out.append("; Domain=");
                out.append(cookie.getDomain());
            }
            if (cookie.getMaxAge() > 0) {
                long expiryMS = System.currentTimeMillis() + 1000L * (long)cookie.getMaxAge();
                String expiryDate = null;
                DateFormat dateFormat = VERSION0_DF;
                synchronized (dateFormat) {
                    expiryDate = VERSION0_DF.format(new Date(expiryMS));
                }
                out.append("; Expires=").append(expiryDate);
            } else if (cookie.getMaxAge() == 0) {
                String expiryDate = null;
                DateFormat dateFormat = VERSION0_DF;
                synchronized (dateFormat) {
                    expiryDate = VERSION0_DF.format(new Date(5000L));
                }
                out.append("; Expires=").append(expiryDate);
            }
            if (cookie.getPath() != null) {
                out.append("; Path=").append(cookie.getPath());
            }
            if (cookie.getSecure()) {
                out.append("; Secure");
            }
        }
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String formatHeaderDate(Date dateIn) {
        String date = null;
        DateFormat dateFormat = HTTP_DF;
        synchronized (dateFormat) {
            date = HTTP_DF.format(dateIn);
        }
        return date;
    }

    protected static void quote(String value, StringBuffer out) {
        if (value.startsWith("\"") && value.endsWith("\"")) {
            out.append(value);
        } else {
            boolean containsSpecial = false;
            for (int n = 0; n < value.length(); ++n) {
                char thisChar = value.charAt(n);
                if (thisChar >= ' ' && thisChar < '\u007f' && specialCharacters.indexOf(thisChar) == -1) continue;
                containsSpecial = true;
                break;
            }
            if (containsSpecial) {
                out.append('\"').append(value).append('\"');
            } else {
                out.append(value);
            }
        }
    }

    public boolean closeAfterRequest() {
        boolean hasContentLength;
        String inKeepAliveHeader = this.reqKeepAliveHeader;
        String outKeepAliveHeader = this.getHeader(KEEP_ALIVE_HEADER);
        boolean bl = hasContentLength = this.getHeader(CONTENT_LENGTH_HEADER) != null;
        if (this.protocol.startsWith("HTTP/0")) {
            return true;
        }
        if (inKeepAliveHeader == null && outKeepAliveHeader == null) {
            return this.protocol.equals("HTTP/1.0") ? true : !hasContentLength;
        }
        if (outKeepAliveHeader != null) {
            return outKeepAliveHeader.equalsIgnoreCase(KEEP_ALIVE_CLOSE) || !hasContentLength;
        }
        if (inKeepAliveHeader != null) {
            return inKeepAliveHeader.equalsIgnoreCase(KEEP_ALIVE_CLOSE) || !hasContentLength;
        }
        return false;
    }

    public void flushBuffer() throws IOException {
        if (this.outputWriter != null) {
            this.outputWriter.flush();
        }
        try {
            this.outputStream.flush();
        }
        catch (ClientSocketException clientSocketException) {
            // empty catch block
        }
    }

    public void setBufferSize(int size) {
        this.outputStream.setBufferSize(size);
    }

    public int getBufferSize() {
        return this.outputStream.getBufferSize();
    }

    public String getCharacterEncoding() {
        String enc = this.getCurrentEncoding();
        return enc == null ? "ISO-8859-1" : enc;
    }

    public void setCharacterEncoding(String encoding) {
        if (this.outputWriter == null && !this.isCommitted()) {
            Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WinstoneResponse.SettingEncoding", encoding);
            this.explicitEncoding = encoding;
            this.correctContentTypeHeaderEncoding(encoding);
        }
    }

    private void correctContentTypeHeaderEncoding(String encoding) {
        String contentType = this.getContentType();
        if (contentType != null) {
            StringBuffer remainderHeader = new StringBuffer();
            WinstoneResponse.getCharsetFromContentTypeHeader(contentType, remainderHeader);
            if (remainderHeader.length() != 0) {
                this.forceHeader(CONTENT_TYPE_HEADER, remainderHeader + ";charset=" + encoding);
            }
        }
    }

    public String getContentType() {
        return this.getHeader(CONTENT_TYPE_HEADER);
    }

    public void setContentType(String type) {
        this.setHeader(CONTENT_TYPE_HEADER, type);
    }

    public Locale getLocale() {
        return this.locale == null ? Locale.getDefault() : this.locale;
    }

    private boolean isIncluding() {
        return this.outputStream.isIncluding();
    }

    public void setLocale(Locale loc) {
        if (this.isIncluding()) {
            return;
        }
        if (this.isCommitted()) {
            Logger.log(Logger.WARNING, Launcher.RESOURCES, "WinstoneResponse.SetLocaleTooLate");
        } else {
            String localeEncoding;
            if (this.outputWriter == null && this.explicitEncoding == null && (localeEncoding = this.getEncodingFromLocale(loc)) != null) {
                this.implicitEncoding = localeEncoding;
                this.correctContentTypeHeaderEncoding(localeEncoding);
            }
            this.locale = loc;
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WinstoneResponse.GetOutputStream");
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WinstoneResponse.GetWriter");
        if (this.outputWriter != null) {
            return this.outputWriter;
        }
        this.outputWriter = new WinstoneResponseWriter(this.outputStream, this);
        return this.outputWriter;
    }

    public boolean isCommitted() {
        return this.outputStream.isCommitted();
    }

    public void reset() {
        if (!this.isIncluding()) {
            this.resetBuffer();
            this.statusCode = 200;
            this.headers.clear();
            this.cookies.clear();
        }
    }

    public void resetBuffer() {
        if (!this.isIncluding()) {
            if (this.isCommitted()) {
                throw new IllegalStateException(Launcher.RESOURCES.getString("WinstoneResponse.ResponseCommitted"));
            }
            this.outputStream.setDisregardMode(true);
            if (this.outputWriter != null) {
                this.outputWriter.flush();
            }
            this.outputStream.setDisregardMode(false);
            this.outputStream.reset();
        }
    }

    public void setContentLength(int len) {
        this.setIntHeader(CONTENT_LENGTH_HEADER, len);
    }

    public void addCookie(Cookie cookie) {
        if (!this.isIncluding()) {
            this.cookies.add(cookie);
        }
    }

    public boolean containsHeader(String name) {
        for (int n = 0; n < this.headers.size(); ++n) {
            if (!((String)this.headers.get(n)).startsWith(name)) continue;
            return true;
        }
        return false;
    }

    public void addDateHeader(String name, long date) {
        this.addHeader(name, WinstoneResponse.formatHeaderDate(new Date(date)));
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, "" + value);
    }

    public void addHeader(String name, String value) {
        if (this.isIncluding()) {
            Logger.log(Logger.DEBUG, Launcher.RESOURCES, "WinstoneResponse.HeaderInInclude", new String[]{name, value});
        } else if (this.isCommitted()) {
            Logger.log(Logger.DEBUG, Launcher.RESOURCES, "WinstoneResponse.HeaderAfterCommitted", new String[]{name, value});
        } else if (value != null) {
            if (name.equals(CONTENT_TYPE_HEADER)) {
                StringBuffer remainderHeader = new StringBuffer();
                String headerEncoding = WinstoneResponse.getCharsetFromContentTypeHeader(value, remainderHeader);
                if (this.outputWriter != null) {
                    value = remainderHeader + ";charset=" + this.getCharacterEncoding();
                } else if (headerEncoding != null) {
                    this.explicitEncoding = headerEncoding;
                }
            }
            this.headers.add(name + ": " + value);
        }
    }

    public void setDateHeader(String name, long date) {
        this.setHeader(name, WinstoneResponse.formatHeaderDate(new Date(date)));
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, "" + value);
    }

    public void setHeader(String name, String value) {
        if (this.isIncluding()) {
            Logger.log(Logger.DEBUG, Launcher.RESOURCES, "WinstoneResponse.HeaderInInclude", new String[]{name, value});
        } else if (this.isCommitted()) {
            Logger.log(Logger.DEBUG, Launcher.RESOURCES, "WinstoneResponse.HeaderAfterCommitted", new String[]{name, value});
        } else {
            boolean found = false;
            for (int n = 0; n < this.headers.size(); ++n) {
                String header = (String)this.headers.get(n);
                if (!header.startsWith(name + ": ")) continue;
                if (found) {
                    this.headers.remove(n);
                    continue;
                }
                if (name.equals(CONTENT_TYPE_HEADER) && value != null) {
                    StringBuffer remainderHeader = new StringBuffer();
                    String headerEncoding = WinstoneResponse.getCharsetFromContentTypeHeader(value, remainderHeader);
                    if (this.outputWriter != null) {
                        value = remainderHeader + ";charset=" + this.getCharacterEncoding();
                    } else if (headerEncoding != null) {
                        this.explicitEncoding = headerEncoding;
                    }
                }
                if (value != null) {
                    this.headers.set(n, name + ": " + value);
                } else {
                    this.headers.remove(n);
                }
                found = true;
            }
            if (!found) {
                this.addHeader(name, value);
            }
        }
    }

    private void forceHeader(String name, String value) {
        boolean found = false;
        for (int n = 0; n < this.headers.size(); ++n) {
            String header = (String)this.headers.get(n);
            if (!header.startsWith(name + ": ")) continue;
            found = true;
            this.headers.set(n, name + ": " + value);
        }
        if (!found) {
            this.headers.add(name + ": " + value);
        }
    }

    private String getCurrentEncoding() {
        if (this.explicitEncoding != null) {
            return this.explicitEncoding;
        }
        if (this.implicitEncoding != null) {
            return this.implicitEncoding;
        }
        if (this.req != null && this.req.getCharacterEncoding() != null) {
            try {
                "0".getBytes(this.req.getCharacterEncoding());
                return this.req.getCharacterEncoding();
            }
            catch (UnsupportedEncodingException err) {
                return null;
            }
        }
        return null;
    }

    public String getHeader(String name) {
        for (int n = 0; n < this.headers.size(); ++n) {
            String header = (String)this.headers.get(n);
            if (!header.startsWith(name + ": ")) continue;
            return header.substring(name.length() + 2);
        }
        return null;
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public String encodeURL(String url) {
        return url;
    }

    public int getStatus() {
        return this.statusCode;
    }

    public Integer getErrorStatusCode() {
        return this.errorStatusCode;
    }

    public void setStatus(int sc) {
        if (!this.isIncluding() && this.errorStatusCode == null) {
            this.statusCode = sc;
        }
    }

    public void sendRedirect(String location) throws IOException {
        if (this.isIncluding()) {
            Logger.log(Logger.ERROR, Launcher.RESOURCES, "IncludeResponse.Redirect", location);
            return;
        }
        if (this.isCommitted()) {
            throw new IllegalStateException(Launcher.RESOURCES.getString("WinstoneOutputStream.AlreadyCommitted"));
        }
        this.resetBuffer();
        StringBuffer fullLocation = new StringBuffer();
        if (location.startsWith("http://") || location.startsWith("https://")) {
            fullLocation.append(location);
        } else {
            if (location.trim().equals(".")) {
                location = "";
            }
            fullLocation.append(this.req.getScheme()).append("://");
            fullLocation.append(this.req.getServerName());
            if (!(this.req.getServerPort() == 80 && this.req.getScheme().equals("http") || this.req.getServerPort() == 443 && this.req.getScheme().equals("https"))) {
                fullLocation.append(':').append(this.req.getServerPort());
            }
            if (location.startsWith("/")) {
                fullLocation.append(location);
            } else {
                fullLocation.append(this.req.getRequestURI());
                int questionPos = fullLocation.toString().indexOf("?");
                if (questionPos != -1) {
                    fullLocation.delete(questionPos, fullLocation.length());
                }
                fullLocation.delete(fullLocation.toString().lastIndexOf("/") + 1, fullLocation.length());
                fullLocation.append(location);
            }
        }
        if (this.req != null) {
            this.req.discardRequestBody();
        }
        this.statusCode = 302;
        this.setHeader(LOCATION_HEADER, fullLocation.toString());
        this.setContentLength(0);
        this.getWriter().flush();
    }

    public void sendError(int sc) throws IOException {
        this.sendError(sc, null);
    }

    public void sendError(int sc, String msg) throws IOException {
        RequestDispatcher rd;
        if (this.isIncluding()) {
            Logger.log(Logger.ERROR, Launcher.RESOURCES, "IncludeResponse.Error", new String[]{"" + sc, msg});
            return;
        }
        Logger.log(Logger.DEBUG, Launcher.RESOURCES, "WinstoneResponse.SendingError", new String[]{"" + sc, msg});
        if (this.webAppConfig != null && this.req != null && (rd = this.webAppConfig.getErrorDispatcherByCode(this.req.getRequestURI(), sc, msg, null)) != null) {
            try {
                rd.forward(this.req, this);
                return;
            }
            catch (IllegalStateException err) {
                throw err;
            }
            catch (IOException err) {
                throw err;
            }
            catch (Throwable err) {
                Logger.log(Logger.WARNING, Launcher.RESOURCES, "WinstoneResponse.ErrorInErrorPage", new String[]{rd.getName(), sc + ""}, err);
                return;
            }
        }
        if (this.errorStatusCode == null) {
            this.statusCode = sc;
        }
        String output = Launcher.RESOURCES.getString("WinstoneResponse.ErrorPage", new String[]{sc + "", msg == null ? "" : msg, "", Launcher.RESOURCES.getString("ServerVersion"), "" + new Date()});
        this.setContentLength(output.getBytes(this.getCharacterEncoding()).length);
        PrintWriter out = this.getWriter();
        ((Writer)out).write(output);
        ((Writer)out).flush();
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public void setStatus(int sc, String sm) {
        this.setStatus(sc);
    }

    static {
        HTTP_DF.setTimeZone(TimeZone.getTimeZone("GMT"));
        VERSION0_DF.setTimeZone(TimeZone.getTimeZone("GMT"));
        X_POWERED_BY_HEADER_VALUE = Launcher.RESOURCES.getString("PoweredByHeader");
    }
}

