/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.ObsProgram;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.ui.components.SamplingFilterComponent;
import fr.ifremer.wao.ui.data.ImportEngine;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.data.SampleRowDataSource;
import fr.ifremer.wao.ui.services.SampleRowModelFactory;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.grid.GridDataSource;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.BeanModelSource;

@RequiresAuthentication(allowedPrograms={ObsProgram.OBSDEB})
public class ObsDebSamplingPlan {
    @Inject
    private BeanModelSource beanModelSource;
    @Inject
    private ComponentResources resources;
    @Inject
    private ServiceSampling serviceSampling;
    private DateFormat dateFormat;
    @SessionState
    @Property
    private ConnectedUser connectedUser;
    @Persist
    private Boolean showFilters;
    @Persist
    private Boolean showImportExport;
    @InjectComponent
    private SamplingFilterComponent samplingFilter;
    private GridDataSource sampleRows;
    @Property
    private SampleRow sampleRow;
    private BeanModel<SampleRow> obsdebSamplingPlanModel;

    public DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat("dd/MM/YYYY");
        }
        return this.dateFormat;
    }

    public ServiceSampling getServiceSampling() {
        return this.serviceSampling;
    }

    public boolean getShowFilters() {
        if (this.showFilters == null) {
            this.showFilters = this.samplingFilter.getFilter().isPeriodFilteredOnly();
        }
        return this.showFilters;
    }

    public boolean getShowImportExport() {
        if (this.showImportExport == null) {
            this.showImportExport = false;
        }
        return this.showImportExport;
    }

    public Zone onActionFromShowFilters() {
        this.showFilters = !this.getShowFilters();
        return null;
    }

    public Zone onActionFromShowImportExport() {
        this.showImportExport = !this.getShowImportExport();
        return null;
    }

    public GridDataSource getSampleRows() {
        if (this.sampleRows == null) {
            this.sampleRows = new SampleRowDataSource(this.samplingFilter.getFilter(), this.serviceSampling);
        }
        return this.sampleRows;
    }

    public BeanModel<SampleRow> getObsdebSamplingPlanModel() {
        if (this.obsdebSamplingPlanModel == null) {
            SampleRowModelFactory sampleRowModelFactory = new SampleRowModelFactory(this.beanModelSource, this.resources, this.connectedUser);
            this.obsdebSamplingPlanModel = sampleRowModelFactory.newModel();
        }
        return this.obsdebSamplingPlanModel;
    }

    public boolean canEditSampleRow() {
        boolean canEditSampleRow = this.connectedUser.isAdmin() || this.connectedUser.isCoordinator();
        return canEditSampleRow;
    }

    public ImportEngine getSamplingPlanImportEngine() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    StreamResponse onActionFromExportSamplingPlan() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ ConnectedUser access$000(ObsDebSamplingPlan x0) {
        return x0.connectedUser;
    }

    static /* synthetic */ ServiceSampling access$100(ObsDebSamplingPlan x0) {
        return x0.serviceSampling;
    }

    static /* synthetic */ SamplingFilterComponent access$200(ObsDebSamplingPlan x0) {
        return x0.samplingFilter;
    }
}

