/*
 * Decompiled with CFR 0.152.
 */
package winstone.auth;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import winstone.Launcher;
import winstone.Logger;
import winstone.WinstoneException;
import winstone.WinstoneInputStream;
import winstone.WinstoneRequest;
import winstone.auth.RetryRequestParams;

public class RetryRequestWrapper
extends HttpServletRequestWrapper {
    protected static final DateFormat headerDF = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
    private static final String METHOD_HEAD = "GET";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_POST = "POST";
    private static final String POST_PARAMETERS = "application/x-www-form-urlencoded";
    private RetryRequestParams oldRequest;
    private String encoding;
    private Map parsedParams;
    private ServletInputStream inData;

    public RetryRequestWrapper(HttpServletRequest request, RetryRequestParams oldRequest) throws IOException {
        super(request);
        this.oldRequest = oldRequest;
        this.encoding = this.oldRequest.getEncoding();
    }

    private boolean hasBeenForwarded() {
        return super.getAttribute("javax.servlet.forward.request_uri") != null;
    }

    public String getScheme() {
        if (this.hasBeenForwarded()) {
            return super.getScheme();
        }
        return this.oldRequest.getScheme();
    }

    public String getMethod() {
        if (this.hasBeenForwarded()) {
            return super.getMethod();
        }
        return this.oldRequest.getMethod();
    }

    public String getContextPath() {
        if (this.hasBeenForwarded()) {
            return super.getContextPath();
        }
        return this.oldRequest.getContextPath();
    }

    public String getServletPath() {
        if (this.hasBeenForwarded()) {
            return super.getServletPath();
        }
        return this.oldRequest.getServletPath();
    }

    public String getPathInfo() {
        if (this.hasBeenForwarded()) {
            return super.getPathInfo();
        }
        return this.oldRequest.getPathInfo();
    }

    public String getQueryString() {
        if (this.hasBeenForwarded()) {
            return super.getQueryString();
        }
        return this.oldRequest.getQueryString();
    }

    public String getRequestURI() {
        if (this.hasBeenForwarded()) {
            return super.getRequestURI();
        }
        String contextPath = this.oldRequest.getContextPath();
        String servletPath = this.oldRequest.getServletPath();
        String pathInfo = this.oldRequest.getPathInfo();
        String queryString = this.oldRequest.getQueryString();
        return contextPath + servletPath + (pathInfo == null ? "" : pathInfo) + (queryString == null ? "" : "?" + queryString);
    }

    public String getCharacterEncoding() {
        if (this.hasBeenForwarded()) {
            return super.getCharacterEncoding();
        }
        return this.oldRequest.getEncoding();
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        if (this.hasBeenForwarded()) {
            super.setCharacterEncoding(encoding);
        } else {
            this.encoding = encoding;
        }
    }

    public int getContentLength() {
        if (this.hasBeenForwarded()) {
            return super.getContentLength();
        }
        return this.oldRequest.getContentLength();
    }

    public String getContentType() {
        if (this.hasBeenForwarded()) {
            return super.getContentType();
        }
        return this.oldRequest.getContentType();
    }

    public Locale getLocale() {
        if (this.hasBeenForwarded()) {
            return super.getLocale();
        }
        return this.oldRequest.getLocale();
    }

    public Enumeration getLocales() {
        if (this.hasBeenForwarded()) {
            return super.getLocales();
        }
        return this.oldRequest.getLocales().elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDateHeader(String name) {
        if (this.hasBeenForwarded()) {
            return super.getDateHeader(name);
        }
        String dateHeader = this.getHeader(name);
        if (dateHeader == null) {
            return -1L;
        }
        try {
            DateFormat dateFormat = headerDF;
            synchronized (dateFormat) {
                return headerDF.parse(dateHeader).getTime();
            }
        }
        catch (ParseException err) {
            throw new IllegalArgumentException("Illegal date format: " + dateHeader);
        }
    }

    public int getIntHeader(String name) {
        if (this.hasBeenForwarded()) {
            return super.getIntHeader(name);
        }
        String header = this.getHeader(name);
        return header == null ? -1 : Integer.parseInt(header);
    }

    public String getHeader(String name) {
        if (this.hasBeenForwarded()) {
            return super.getHeader(name);
        }
        Enumeration e = this.getHeaders(name);
        return e != null && e.hasMoreElements() ? (String)e.nextElement() : null;
    }

    public Enumeration getHeaderNames() {
        if (this.hasBeenForwarded()) {
            return super.getHeaderNames();
        }
        return Collections.enumeration(this.oldRequest.getHeaders().keySet());
    }

    public Enumeration getHeaders(String name) {
        if (this.hasBeenForwarded()) {
            return super.getHeaders(name);
        }
        Vector result = (Vector)this.oldRequest.getHeaders().get(name.toLowerCase());
        return result == null ? null : result.elements();
    }

    public String getParameter(String name) {
        if (this.hasBeenForwarded()) {
            return super.getParameter(name);
        }
        this.parseRequestParameters();
        Object param = this.parsedParams.get(name);
        if (param == null) {
            return null;
        }
        if (param instanceof String) {
            return (String)param;
        }
        if (param instanceof String[]) {
            return ((String[])param)[0];
        }
        return param.toString();
    }

    public Enumeration getParameterNames() {
        if (this.hasBeenForwarded()) {
            return super.getParameterNames();
        }
        this.parseRequestParameters();
        return Collections.enumeration(this.parsedParams.keySet());
    }

    public String[] getParameterValues(String name) {
        if (this.hasBeenForwarded()) {
            return super.getParameterValues(name);
        }
        this.parseRequestParameters();
        Object param = this.parsedParams.get(name);
        if (param == null) {
            return null;
        }
        if (param instanceof String) {
            return new String[]{(String)param};
        }
        if (param instanceof String[]) {
            return (String[])param;
        }
        throw new WinstoneException(Launcher.RESOURCES.getString("WinstoneRequest.UnknownParameterType", name + " - " + param.getClass()));
    }

    public Map getParameterMap() {
        if (this.hasBeenForwarded()) {
            return super.getParameterMap();
        }
        Hashtable<String, String[]> paramMap = new Hashtable<String, String[]>();
        Enumeration names = this.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            paramMap.put(name, this.getParameterValues(name));
        }
        return paramMap;
    }

    public BufferedReader getReader() throws IOException {
        if (this.hasBeenForwarded()) {
            return super.getReader();
        }
        if (this.getCharacterEncoding() != null) {
            return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this.encoding));
        }
        return new BufferedReader(new InputStreamReader(this.getInputStream()));
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.hasBeenForwarded()) {
            return super.getInputStream();
        }
        if (this.parsedParams != null) {
            Logger.log(Logger.WARNING, Launcher.RESOURCES, "WinstoneRequest.BothMethods");
        }
        if (this.inData == null) {
            this.inData = new WinstoneInputStream(this.oldRequest.getBodyContent());
        }
        return this.inData;
    }

    private void parseRequestParameters() {
        if (this.inData != null) {
            Logger.log(Logger.WARNING, Launcher.RESOURCES, "WinstoneRequest.BothMethods");
        }
        if (this.parsedParams == null) {
            String contentType = this.oldRequest.getContentType();
            String queryString = this.oldRequest.getQueryString();
            String method = this.oldRequest.getMethod();
            HashMap workingParameters = new HashMap();
            try {
                if ((method.equals("GET") || method.equals("GET") || method.equals(METHOD_POST)) && queryString != null) {
                    WinstoneRequest.extractParameters(queryString, this.encoding, workingParameters, false);
                }
                if (method.equals(METHOD_POST) && contentType != null && (contentType.equals(POST_PARAMETERS) || contentType.startsWith("application/x-www-form-urlencoded;"))) {
                    String paramLine = this.encoding == null ? new String(this.oldRequest.getBodyContent()) : new String(this.oldRequest.getBodyContent(), this.encoding);
                    WinstoneRequest.extractParameters(paramLine.trim(), this.encoding, workingParameters, false);
                }
                this.parsedParams = workingParameters;
            }
            catch (UnsupportedEncodingException err) {
                Logger.log(Logger.ERROR, Launcher.RESOURCES, "WinstoneRequest.ErrorBodyParameters", err);
                this.parsedParams = null;
            }
        }
    }

    static {
        headerDF.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

