/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id: ExceptionReport.java 650 2010-10-03 15:14:48Z fdesbois $
 * $HeadURL: svn+ssh://bleny@labs.libre-entreprise.org/svnroot/suiviobsmer/tags/wao-2.1.2/wao-ui/src/main/java/fr/ifremer/wao/ui/pages/ExceptionReport.java $
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.ui.components.Layout;
import fr.ifremer.wao.ui.services.WaoManager;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.ExceptionReporter;
import org.slf4j.Logger;

/**
 * ExceptionReport
 *
 * Created: 5 janv. 2010
 *
 * @author fdesbois <fdesbois@codelutin.com>
 */
public class ExceptionReport implements ExceptionReporter {

    @InjectComponent
    private Layout layout;

    @Inject
    private Logger log;

    @Inject
    private Messages messages;

    @Inject
    private WaoManager manager;

    @Property
    private Throwable exception;

    @Override
    public void reportException(Throwable eee) {
        exception = getWaoException(eee);
        if (exception != null) {
            String[] errors =
                   manager.getErrorMessages(
                                    (WaoException)exception, messages, log);
            layout.addError(errors);
        // Show other errors only in dev environment
        } else if (manager.isDevEnvironment()) {
            log.error("Unexpected exception", eee);
            layout.addError("Erreur : " +
                    eee.getClass().getSimpleName() + " : " + eee.getMessage());
        } else {
            layout.addError("Une erreur inattendue vient de se produire. " +
                    "Veuillez recharger la page. Contactez un administrateur " +
                    "si ce message continue de s'afficher.");
        }
    }

    protected Throwable getWaoException(Throwable eee) {
        if (eee == null) {
            return eee;
        }
        if (eee instanceof WaoException) {
            return eee;
        }
        return getWaoException(eee.getCause());
    }
        
}
