/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.base;

import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.bean.SamplingFilterImpl;
import fr.ifremer.wao.entity.Company;
import fr.ifremer.wao.entity.FishingGearDCF;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.entity.TargetSpeciesDCF;
import fr.ifremer.wao.entity.TerrestrialLocation;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.service.ServiceBoat;
import fr.ifremer.wao.service.ServiceReferential;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.base.FilterManager;
import fr.ifremer.wao.ui.data.GenericSelectModel;
import fr.ifremer.wao.ui.data.TapestryUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry5.OptionModel;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.internal.OptionModelImpl;
import org.apache.tapestry5.internal.SelectModelImpl;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.slf4j.Logger;

@Deprecated
public abstract class AbstractFilteredPage {
    @Inject
    private Logger log;
    @SessionState
    private ConnectedUser user;
    @Inject
    private PropertyAccess propertyAccess;
    @Inject
    private ServiceReferential serviceReferential;
    @Inject
    private ServiceSampling serviceSampling;
    @Inject
    private ServiceBoat serviceBoat;
    @Inject
    private ServiceUser serviceUser;
    @Persist
    private FilterManager filterManager;
    @Persist
    private boolean observerSelect;
    @Persist
    private boolean programSelect;
    @Persist
    private GenericSelectModel<SampleRow> sampleRowSelectModel;
    @Persist
    private GenericSelectModel<TerrestrialLocation> terrestrialLocationSelectModel;
    @Persist
    private GenericSelectModel<Company> companySelectModel;
    @Persist
    private GenericSelectModel<WaoUser> observerSelectModel;
    @Persist
    private GenericSelectModel<FishingGearDCF> dcfGearSelectModel;
    @Persist
    private GenericSelectModel<TargetSpeciesDCF> dcfSpeciesSelectModel;
    @Persist
    private SelectModel facadeSelectModel;
    @Persist
    private SelectModel sectorSelectModel;
    @Persist
    private SelectModel programSelectModel;
    @Persist
    private String companyId;
    @Persist
    private String observerId;
    @Persist
    private String fishingGearDCFId;
    @Persist
    private String targetSpeciesDCFId;
    @Persist
    private String terrestrialDistrictId;
    private boolean edited;
    @Persist
    private String sampleRowId;

    public boolean isObserverSelect() {
        return this.observerSelect;
    }

    public boolean isProgramSelect() {
        return this.programSelect;
    }

    public String getSampleRowId() {
        return this.sampleRowId;
    }

    public void setSampleRowId(String sampleRowId) {
        this.sampleRowId = sampleRowId;
        SampleRow sampleRow = (SampleRow)TapestryUtil.getEntityFromModel((GenericSelectModel)this.getSampleRowSelectModel(), (String)sampleRowId);
        this.getFilter().setSampleRow(sampleRow);
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
        Company company = (Company)TapestryUtil.getEntityFromModel((GenericSelectModel)this.getCompanySelectModel(), (String)companyId);
        this.getFilter().setCompany(company);
    }

    public String getObserverId() {
        return this.observerId;
    }

    public void setObserverId(String observerId) {
        this.observerId = observerId;
        WaoUser observer = (WaoUser)TapestryUtil.getEntityFromModel((GenericSelectModel)this.getObserverSelectModel(), (String)observerId);
        this.getFilter().setObserver(observer);
    }

    public String getFishingGearDCFId() {
        return this.fishingGearDCFId;
    }

    public void setFishingGearDCFId(String fishingGearDCFId) {
        this.fishingGearDCFId = fishingGearDCFId;
        FishingGearDCF fishingGearDCF = (FishingGearDCF)TapestryUtil.getEntityFromModel((GenericSelectModel)this.getDcfGearSelectModel(), (String)fishingGearDCFId);
        this.getFilter().setFishingGearDCF(fishingGearDCF);
    }

    public String getTargetSpeciesDCFId() {
        return this.targetSpeciesDCFId;
    }

    public void setTargetSpeciesDCFId(String targetSpeciesDCFId) {
        this.targetSpeciesDCFId = targetSpeciesDCFId;
        TargetSpeciesDCF targetSpeciesDCF = (TargetSpeciesDCF)TapestryUtil.getEntityFromModel((GenericSelectModel)this.getDcfSpeciesSelectModel(), (String)targetSpeciesDCFId);
        this.getFilter().setTargetSpeciesDCF(targetSpeciesDCF);
    }

    public String getTerrestrialDistrictId() {
        return this.terrestrialDistrictId;
    }

    public void setTerrestrialDistrictId(String terrestrialDistrictId) {
        this.terrestrialDistrictId = terrestrialDistrictId;
        TerrestrialLocation terrestrialDistrict = (TerrestrialLocation)TapestryUtil.getEntityFromModel((GenericSelectModel)this.getTerrestrialDistrictSelectModel(), (String)terrestrialDistrictId);
        this.getFilter().setTerrestrialDistrict(terrestrialDistrict);
    }

    public void onSelectedFromAddSampleRowCode() {
        if (this.getSampleRowId() != null) {
            SampleRow sampleRow;
            ArrayList<SampleRow> rows = this.getFilter().getSampleRows();
            if (rows == null) {
                rows = new ArrayList<SampleRow>();
                this.getFilter().setSampleRows(rows);
            }
            if (!rows.contains(sampleRow = (SampleRow)this.getSampleRowSelectModel().findObject(this.getSampleRowId()))) {
                rows.add(sampleRow);
            }
        }
    }

    public void onSelectedFromRemoveSampleRowCode() {
        if (this.getSampleRowId() != null) {
            this.getFilter().getSampleRows().remove(this.getSampleRowSelectModel().findObject(this.getSampleRowId()));
        }
    }

    public void initCompanyFilter() {
        if (this.user.isCoordinatorOrObserver()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Company filtered : " + this.user.getCompany().getName());
            }
            this.getFilter().setCompany(this.user.getCompany());
        }
    }

    public void initSelectFilters(boolean companySelect, boolean observerSelect, boolean programSelect) throws WaoException {
        this.observerSelect = observerSelect;
        this.programSelect = programSelect;
        if (this.getFilter().getSampleRow() != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("SampleRow filtered : " + this.getFilter().getSampleRow());
            }
            this.setSampleRowId(this.getFilter().getSampleRow().getTopiaId());
        }
        if (this.user.isAdmin() && companySelect) {
            this.resetCompanySelectModel();
            if (this.getFilter().getCompany() != null) {
                this.setCompanyId(this.getFilter().getCompany().getTopiaId());
            }
        }
        if (observerSelect) {
            this.resetObserverSelectModel();
            this.getObserverSelectModel();
            if (this.getFilter().getObserver() != null) {
                this.setObserverId(this.getFilter().getObserver().getTopiaId());
            }
        }
        if (programSelect) {
            this.resetProgramSelectModel();
            this.getProgramSelectModel();
        }
        this.resetFacadeSelectModel();
        this.resetSectorSelectModel();
        this.resetSampleRowSelectModel();
        this.initCompagnyFilter();
    }

    public void initCompagnyFilter() {
        if (this.user.isCoordinatorOrObserver()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Company filtered : " + this.user.getCompany().getName());
            }
            this.getFilter().setCompany(this.user.getCompany());
        }
    }

    public void resetCompanySelectModel() throws WaoException {
        this.companySelectModel = null;
        this.companyId = null;
    }

    public void resetSampleRowSelectModel() throws WaoException {
        this.sampleRowSelectModel = null;
        this.getFilter().setSampleRow(null);
    }

    public void resetObserverSelectModel() {
        this.observerSelectModel = null;
        this.observerId = null;
    }

    public void resetTerrestrialDistrictModel() {
        this.terrestrialLocationSelectModel = null;
        this.terrestrialDistrictId = null;
    }

    public void resetTargetSpeciesDCFModel() {
        this.dcfSpeciesSelectModel = null;
        this.targetSpeciesDCFId = null;
    }

    public void resetFishingGearDCFModel() {
        this.dcfGearSelectModel = null;
        this.fishingGearDCFId = null;
    }

    public void resetFacadeSelectModel() throws WaoException {
        this.facadeSelectModel = null;
    }

    public void resetSectorSelectModel() throws WaoException {
        this.sectorSelectModel = null;
    }

    public void resetProgramSelectModel() {
        this.programSelectModel = null;
    }

    public void resetModels() {
        this.resetCompanySelectModel();
        this.resetFacadeSelectModel();
        this.resetObserverSelectModel();
        this.resetProgramSelectModel();
        this.resetSampleRowSelectModel();
        this.resetSectorSelectModel();
        this.resetTerrestrialDistrictModel();
        this.resetTargetSpeciesDCFModel();
        this.resetFishingGearDCFModel();
    }

    public GenericSelectModel<SampleRow> getSampleRowSelectModel() throws WaoException {
        if (this.sampleRowSelectModel == null) {
            List rowsFiltered = this.getFilter().getSampleRows();
            this.getFilter().setSampleRows(null);
            List sampleRows = this.serviceSampling.getSampleRowsByFilter(this.getFilter());
            this.getFilter().setSampleRows(rowsFiltered);
            this.sampleRowSelectModel = new GenericSelectModel(sampleRows, SampleRow.class, "code", "topiaId", this.propertyAccess);
        }
        return this.sampleRowSelectModel;
    }

    public SelectModel getFacadeSelectModel() throws WaoException {
        if (this.facadeSelectModel == null) {
            List options = this.getOptionModels(this.serviceReferential.getFacades(this.getFilter()));
            this.facadeSelectModel = new SelectModelImpl(null, options);
        }
        return this.facadeSelectModel;
    }

    public SelectModel getSectorSelectModel() throws WaoException {
        if (this.sectorSelectModel == null) {
            List options = this.getOptionModels(this.serviceReferential.getSectors(this.getFilter()));
            this.sectorSelectModel = new SelectModelImpl(null, options);
        }
        return this.sectorSelectModel;
    }

    public GenericSelectModel<Company> getCompanySelectModel() throws WaoException {
        if (this.companySelectModel == null) {
            List companies = this.serviceUser.getCompanies(this.isAvailableDataForFiltersOnly());
            this.companySelectModel = new GenericSelectModel(companies, Company.class, "name", "topiaId", this.propertyAccess);
        }
        return this.companySelectModel;
    }

    public GenericSelectModel<WaoUser> getObserverSelectModel() throws WaoException {
        if (this.observerSelectModel == null) {
            List observers = this.serviceUser.getObservers(this.getFilter().getCompany(), this.isAvailableDataForFiltersOnly());
            this.observerSelectModel = new GenericSelectModel(observers, WaoUser.class, "fullName", "topiaId", this.propertyAccess);
        }
        return this.observerSelectModel;
    }

    public SelectModel getProgramSelectModel() throws WaoException {
        if (this.programSelectModel == null) {
            List options = this.getOptionModels(this.serviceSampling.getPrograms(this.getFilter().getCompany()));
            this.programSelectModel = new SelectModelImpl(null, options);
        }
        return this.programSelectModel;
    }

    public GenericSelectModel<FishingGearDCF> getDcfGearSelectModel() throws WaoException {
        if (this.dcfGearSelectModel == null) {
            FishingGearDCF keptFishingGearDCF = this.getFilter().getFishingGearDCF();
            this.getFilter().setFishingGearDCF(null);
            List fishingGearDCFs = this.serviceSampling.getDCFGears(this.getFilter());
            this.getFilter().setFishingGearDCF(keptFishingGearDCF);
            this.dcfGearSelectModel = new GenericSelectModel(fishingGearDCFs, FishingGearDCF.class, "fullDescription", "topiaId", this.propertyAccess);
        }
        return this.dcfGearSelectModel;
    }

    public GenericSelectModel<TargetSpeciesDCF> getDcfSpeciesSelectModel() throws WaoException {
        if (this.dcfSpeciesSelectModel == null) {
            TargetSpeciesDCF keptTargetSpeciesDCF = this.getFilter().getTargetSpeciesDCF();
            this.getFilter().setTargetSpeciesDCF(null);
            List targetSpeciesDCFs = this.serviceSampling.getDCFSpecies(this.getFilter());
            this.getFilter().setTargetSpeciesDCF(keptTargetSpeciesDCF);
            this.dcfSpeciesSelectModel = new GenericSelectModel(targetSpeciesDCFs, TargetSpeciesDCF.class, "fullDescription", "topiaId", this.propertyAccess);
        }
        return this.dcfSpeciesSelectModel;
    }

    public GenericSelectModel<TerrestrialLocation> getTerrestrialDistrictSelectModel() throws WaoException {
        if (this.terrestrialLocationSelectModel == null) {
            List districts = this.serviceReferential.getAllTerrestrialDistricts((SamplingFilter)new SamplingFilterImpl());
            this.terrestrialLocationSelectModel = new GenericSelectModel(districts, TerrestrialLocation.class, "description", "topiaId", this.propertyAccess);
        }
        return this.terrestrialLocationSelectModel;
    }

    protected List<OptionModel> getOptionModels(List<String> names) {
        ArrayList<OptionModel> options = new ArrayList<OptionModel>();
        for (String name : names) {
            options.add((OptionModel)new OptionModelImpl(name, (Object)name));
        }
        return options;
    }

    protected abstract SamplingFilter getFilter() throws WaoException;

    protected abstract boolean isAvailableDataForFiltersOnly();

    protected abstract void resetFilter();

    public String[] onProvideCompletionsFromBoatName(String input) throws WaoException {
        List results = this.serviceBoat.getBoatNamesStartWith(input);
        return results.toArray(new String[results.size()]);
    }

    public void onSelectedFromSearch() throws WaoException {
        String targetSpeciesDCFId;
        String fishingGearDCFId;
        if (this.log.isDebugEnabled()) {
            this.log.debug("REFRESH FILTERS DATA");
            this.log.debug("observerSelect : " + this.isObserverSelect());
        }
        if (this.user.isAdmin()) {
            Company company = (Company)this.getCompanySelectModel().findObject(this.getCompanyId());
            this.getFilter().setCompany(company);
        } else {
            this.getFilter().setCompany(this.user.getCompany());
        }
        if (this.isObserverSelect()) {
            WaoUser observer = (WaoUser)this.getObserverSelectModel().findObject(this.getObserverId());
            if (this.log.isDebugEnabled()) {
                this.log.debug("Observer selected : " + (observer != null ? observer.getFullName() : "null"));
            }
            this.getFilter().setObserver(observer);
        }
        if ((fishingGearDCFId = this.getFishingGearDCFId()) != null) {
            FishingGearDCF fishingGearDCF = (FishingGearDCF)this.getDcfGearSelectModel().findObject(fishingGearDCFId);
            this.getFilter().setFishingGearDCF(fishingGearDCF);
        }
        if ((targetSpeciesDCFId = this.getTargetSpeciesDCFId()) != null) {
            TargetSpeciesDCF targetSpeciesDCF = (TargetSpeciesDCF)this.getDcfSpeciesSelectModel().findObject(targetSpeciesDCFId);
            this.getFilter().setTargetSpeciesDCF(targetSpeciesDCF);
        }
        this.updateLocation(this.getTerrestrialDistrictId());
    }

    public void updateLocation(String terrestrialDistrictId) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("in filters : terrestrialDistrictId = " + terrestrialDistrictId);
        }
        TerrestrialLocation district = (TerrestrialLocation)this.getTerrestrialDistrictSelectModel().findObject(terrestrialDistrictId);
        this.getFilter().setTerrestrialDistrict(district);
    }

    public void onSelectedFromRefreshByCompany() throws WaoException {
        this.getFilter().setProgramName(null);
        this.onSelectedFromRefreshByProgram();
        if (this.isObserverSelect()) {
            this.getFilter().setObserver(null);
            this.resetObserverSelectModel();
            this.getObserverSelectModel();
        }
        if (this.isProgramSelect()) {
            this.resetProgramSelectModel();
            this.getProgramSelectModel();
        }
        this.edited = true;
    }

    public void onSelectedFromRefreshByProgram() throws WaoException {
        this.getFilter().setFacadeName(null);
        this.onSelectedFromRefreshByFacade();
        this.resetFacadeSelectModel();
    }

    public void onSelectedFromRefreshByFacade() throws WaoException {
        this.getFilter().setSectorName(null);
        this.onSelectedFromRefreshBySector();
        this.resetSectorSelectModel();
    }

    public void onSelectedFromRefreshBySector() throws WaoException {
        this.onSelectedFromSearch();
        this.getFilter().setSampleRow(null);
        this.resetSampleRowSelectModel();
        this.edited = true;
    }

    protected boolean isEdited() {
        return this.edited;
    }
}

