/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id: Boats.java 1082 2011-03-22 10:30:29Z sletellier $
 * $HeadURL: svn+ssh://tchemit@labs.libre-entreprise.org/svnroot/suiviobsmer/tags/wao-2.1.1/wao-ui/src/main/java/fr/ifremer/wao/ui/pages/Boats.java $
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.BoatFilter;
import fr.ifremer.wao.bean.BoatFilterImpl;
import fr.ifremer.wao.bean.CompanyBoatInfos;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.entity.Boat;
import fr.ifremer.wao.entity.BoatInfos;
import fr.ifremer.wao.entity.Company;
import fr.ifremer.wao.entity.Contact;
import fr.ifremer.wao.entity.ElligibleBoat;
import fr.ifremer.wao.entity.Profession;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.service.ServiceBoat;
import fr.ifremer.wao.service.ServiceContact;
import fr.ifremer.wao.service.ServiceReferential;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.base.AbstractFilteredPage;
import fr.ifremer.wao.ui.components.FeedBack;
import fr.ifremer.wao.ui.components.Layout;
import fr.ifremer.wao.ui.data.BoatDataSource;
import fr.ifremer.wao.ui.data.ExportStreamResponse;
import fr.ifremer.wao.ui.data.GenericSelectModel;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.services.WaoManager;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.PersistenceConstants;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.InjectPage;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.slf4j.Logger;

import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

/**
 * Boats
 *
 * Created: 9 nov. 2009
 *
 * @author fdesbois <fdesbois@codelutin.com>
 */
@RequiresAuthentication(allowedRoles = {UserRole.ADMIN, UserRole.COORDINATOR, UserRole.OBSERVER, UserRole.PROFESSIONAL})
@Import(stylesheet = "context:css/boats.css")
public class Boats extends AbstractFilteredPage {

    @Inject
    private Logger log;

    @InjectComponent
    private Layout layout;

    @SessionState
    @Property
    private ConnectedUser user;

    @Inject
    private ServiceReferential serviceReferential;

    @Inject
    private ServiceSampling serviceSampling;

    @Inject
    private ServiceBoat serviceBoat;

    @Inject
    private ServiceContact serviceContact;

    @Inject
    private PropertyAccess propertyAccess;

    @Property
    private String sampleRowContextId;

    /** Selected boat immatriculation for showing boatInfos */
    @Persist(PersistenceConstants.FLASH)
    private Integer boatSelectedImmatriculation;

    public Integer getBoatSelectedImmatriculation() {
        return boatSelectedImmatriculation;
    }

    public void setBoatSelectedImmatriculation(Integer boatSelectedImmatriculation) {
        this.boatSelectedImmatriculation = boatSelectedImmatriculation;
    }

    @InjectComponent
    private FeedBack filterFeedback;

    void setupRender() throws WaoException {

        if (boatSelectedImmatriculation != null && getBoatSelected() == null) {
            layout.addFatal("L'immatriculation " + boatSelectedImmatriculation +
                    " ne correspond à aucun navire affichable. " +
                    "Veuillez à enlever cette immatriculation de l'url puis" +
                    " rechargez la page.");
            boatSelectedImmatriculation = null;
        }

        sampleRow = null;
        getSampleRow();

        // Manage sampleRow from context
        if (isSampleRowExists()) {
            // Filters will be set and displayed
            getFilter().setSampleRow(sampleRow);
            filtersHidden = false;
            boats = null;
            filterFeedback.addInfo("Vous êtes en cours de sélection d'un navire pour la ligne du plan " + sampleRow.getCode());
            professionId = getSampleRow().getProfession().getTopiaId();
        }

        // Initialize filters using AbstractFilteredPage superclass
        initSelectFilters(false, false, false);
        // The company of connected user will be contributed to abstractFilteredPage
        // TODO sletellier remove it ? : up in initSelectFilters
//        initCompanyFilter();

        companyBoatInfos = null;
    }

    void onActivate(EventContext ec) {
        sampleRowContextId = ec.get(String.class, 0);
        if (ec.getCount() > 1) {
            boatSelectedImmatriculation = ec.get(Integer.class, 1);
        }
//        boatSelectedImmatriculation = ec.get(Integer.class, 1);
    }

//    Object[] onPassivate() {
//        return new Object[] { sampleRowContextId, boatSelectedImmatriculation };
//    }

    String onPassivate() {
        return sampleRowContextId;
    }

    /**************************** Import Forms ********************************/

//    /** Csv file for boats import */
//    @Property
//    private UploadedFile boatsCsvFile;
//
//    /** Csv file for activityCalendar import, can be a Gzip file */
//    @Property
//    private UploadedFile activityCalendarsCsvFile;
//
//    private InputStream activityCalendarLogFile;
//
//    private InputStream activityCalendarLogAccessFile;
//
//    protected static final String GZIP_MIMETYPE = "application/x-gzip";
//
//    public boolean canImportReferentials() {
//        return user.isAdmin() && !user.isReadOnly();
//    }
//
//    @Log
//    void onSuccessFromImportBoatsForm() {
//        if (canImportReferentials()) {
//            try {
//                int[] result = serviceBoat.importBoatCsv(
//                        boatsCsvFile.getStream());
//                // Suppress persitant list of boats
//                boats = null;
//                layout.addInfo(result[0] + " navires importés dont " +
//                        result[1] + " nouveaux");
//            } catch (WaoBusinessException eee) {
//                layout.addError(eee.getMessage());
//            }
//        }
//    }
//
//    InputStream getActivityCalendarLogFile() throws FileNotFoundException {
//        if (activityCalendarLogFile == null) {
//            activityCalendarLogFile = serviceBoat.getActivityCalendarLogFile();
//        }
//        return activityCalendarLogFile;
//    }
//
//    public boolean isLogFileExists() {
//        try {
//            getActivityCalendarLogFile();
//            return true;
//        } catch (FileNotFoundException eee) {
//            if (log.isInfoEnabled()) {
//                log.info("Aucun fichier de log existant pour les calendriers d'activité");
//            }
//            return false;
//        }
//    }
//
//    InputStream getActivityCalendarLogAccessFile() throws FileNotFoundException {
//        if (activityCalendarLogAccessFile == null) {
//            activityCalendarLogAccessFile =
//                    serviceBoat.getActivityCalendarLogAccessFile();
//        }
//        return activityCalendarLogAccessFile;
//    }
//
//    public boolean isLogAccessFileExists() {
//        try {
//            getActivityCalendarLogAccessFile();
//            return true;
//        } catch (FileNotFoundException eee) {
//            if (log.isInfoEnabled()) {
//                log.info("Aucun fichier de log existant pour les accès " +
//                        "utilisateurs aux calendriers d'activité");
//            }
//            return false;
//        }
//    }
//
//    @Log
//    void onSuccessFromImportActivityCalendarsForm()
//            throws WaoException, IOException {
//        if (canImportReferentials()) {
//            InputStream input = activityCalendarsCsvFile.getStream();
//            if (log.isDebugEnabled()) {
//                log.debug("Content type : " +
//                        activityCalendarsCsvFile.getContentType());
//            }
//            if (activityCalendarsCsvFile.getContentType().
//                    equals(GZIP_MIMETYPE)) {
//                if (log.isDebugEnabled()) {
//                    log.debug("Gzip file");
//                }
//                input = new GZIPInputStream(input);
//            }
//            serviceBoat.importActivityCalendarCsv(input);
//            companyBoatInfos = null;
//        }
//    }
//
//    public StreamResponse onActionFromShowActivityCalendarLogFile() {
//        return new StreamResponse() {
//
//            @Override
//            public String getContentType() {
//                return "text/plain;charset=utf-8";
//            }
//
//            @Override
//            public InputStream getStream() throws IOException {
//                return getActivityCalendarLogFile();
//            }
//
//            @Override
//            public void prepareResponse(Response response) {
//            }
//        };
//    }
//
//    public StreamResponse onActionFromShowActivityCalendarLogAccessFile() {
//        return new StreamResponse() {
//
//            @Override
//            public String getContentType() {
//                return "text/plain;charset=utf-8";
//            }
//
//            @Override
//            public InputStream getStream() throws IOException {
//                return getActivityCalendarLogAccessFile();
//            }
//
//            @Override
//            public void prepareResponse(Response response) {
//            }
//        };
//    }

    /**************************** Filters Form *****************************************/

    /** Filters to apply on boats list */
    @Persist
    private BoatFilter boatFilter;

    /** Current sampleRow from context */
    @Persist
    private SampleRow sampleRow;

    /** Profession select */
    @Persist
    private GenericSelectModel<Profession> professionSelectModel;

    @Property
    private String professionId;

    /** Used to manage view of filters zone */
    @Persist
    private boolean filtersHidden;

    @InjectComponent
    private Zone filtersZone;

    /**
     * Filters to apply on boats list. Method used by AbstractFilteredPage superclass. 
     *
     * @return the current BoatFilter to apply
     * @throws WaoException
     * @see AbstractFilteredPage
     */
    @Override
    public SamplingFilter getFilter() throws WaoException {
        return getBoatFilter();
    }

    public BoatFilter getBoatFilter() throws WaoException {
        if (boatFilter == null) {
            if (log.isDebugEnabled()) {
                log.debug("Create filter");
            }
            boatFilter = new BoatFilterImpl();
            // Only rows which are not finished nearly one month
            boatFilter.setNbMonthFinishedFromToday(-1);
            boatFilter.setObsProgram(user.getProfile().getObsProgram());
        }
        return boatFilter;
    }

    @Override
    protected boolean isAvailableDataForFiltersOnly() {
        return true;
    }

    @Override
    protected void resetFilter() {
        this.boatFilter = null;
    }

    /**
     * Retrieve sampleRow from business with id from url context. The sampleRowId from context is set by SamplingPlan page.
     * When the sampleRow is not null, the filters are disabled to optimize searching boats for this row.
     *
     * @return the sampleRow from business
     * @throws WaoException
     */
    public SampleRow getSampleRow() throws WaoException {
        if (sampleRow == null && !StringUtils.isEmpty(sampleRowContextId)) {
            sampleRow = serviceSampling.getSampleRow(sampleRowContextId);
        }
        return sampleRow;
    }

    public boolean isSampleRowExists() throws WaoException {
        return getSampleRow() != null;
    }

//    public GenericSelectModel<Profession> getProfessionSelectModel() throws WaoException {
//        if (professionSelectModel == null) {
//            List<Profession> professions = serviceReferential.getProfessions();
//            professionSelectModel = new GenericSelectModel<Profession>(professions, Profession.class,
//                "code", "topiaId", propertyAccess);
//        }
//        return professionSelectModel;
//    }

    public boolean isFiltersHidden() {
        return filtersHidden;
    }

    public String getHiddenStyle() {
        return isFiltersHidden() ? "hidden" : "";
    }

    Block onActionFromShowFilters() {
        filtersHidden = false;
        return filtersZone.getBody();
    }

    Block onActionFromHideFilters() {
        filtersHidden = true;
        return filtersZone.getBody();
    }

    public String[] onProvideCompletionsFromShipOwnerName(String input) {
        List<String> results = serviceBoat.getShipOwnerNamesContains(input);
        return results.toArray(new String[results.size()]);
    }

    /**
     * EVENT_SELECTED :: reset submit button for filtersForm. Reset filters and sampleRow from context.
     */
    void onSelectedFromReset() {
        // Suppress persistant boat filter and sampleRowId in url context.
        boatFilter = null;
        sampleRowContextId = null;
    }

    /**
     * EVENT_SELECTED :: search sumit button for filtersForm. Get profession from selectModel to add it in filters.
     * Other filters are managed by AbstractFilteredPage superclass.
     *
     * @throws WaoException for business errors
     * @see AbstractFilteredPage#onSelectedFromSearch() 
     */
    @Override
    public void onSelectedFromSearch() throws WaoException {
        super.onSelectedFromSearch();
        if (log.isDebugEnabled()) {
            log.debug("FILTER : facadeName=" + boatFilter.getFacadeName());
            log.debug("FILTER : sectorName=" + boatFilter.getSectorName());
            log.debug("FILTER : sampleRow=" + boatFilter.getSampleRow());
//            log.debug("FILTER : profession=" + boatFilter.getProfession());
            log.debug("FILTER : boatName=" + boatFilter.getBoatName());
            log.debug("FILTER : boatImmatriculation=" + boatFilter.getBoatImmatriculation());
            log.debug("FILTER : boatDistrictCode=" + boatFilter.getBoatDistrictCode());
            log.debug("FILTER : company=" + boatFilter.getCompany());
        }
//        Profession profession = getProfessionSelectModel().findObject(professionId);
//        boatFilter.setProfession(profession);
    }

    /**
     * EVENT_SUCCESS :: for filtersForm. Reset persitant data to have new data using filters selected.
     *
     * @return the filtersZone if it's a refresh data for select, or the page otherwise
     * @throws WaoException for business errors
     */
    Object onSuccessFromFiltersForm() throws WaoException {
        if (isEdited()) {
            return filtersZone.getBody();
        }
        // Suppress persistant boats list to get new one with filter
        boats = null;
        // Suppress persistant immatriculation for boat selected
        boatSelectedImmatriculation = null;
        // Suppress persistant boat informations for boat selected
        companyBoatInfos = null;
        return this;
    }

    /**************************** Boats List *****************************************/

    /** DataSource containing the boats */
    @Persist
    private BoatDataSource boats;

    /** Current boat in the Grid */
    @Property
    private Boat boat;

    /** Used to change style a line on two */
    private boolean even = true;

    /** Used to refresh boats Grid */
    @InjectComponent
    private Zone boatsZone;

    /**
     * Get dataSource which contains current boats to show on the page. Depends on filters sets by user.
     * BoatDataSource uses serviceBoat to retrieve boats with filters.
     *
     * @return the BoatDataSource which contains the boats map
     * @throws WaoException
     * @see BoatDataSource
     */
    public BoatDataSource getBoats() throws WaoException {
        if (boats == null) {
            boats = new BoatDataSource(getBoatFilter(), serviceBoat);
        }
        return boats;
    }

    /**
     * Initialized row CSS style depends on selection in the list. The style is also changed a line on two.
     *
     * @return the CSS style class to used for the current row in the Grid
     */
    public String getRowStyle() {
        String result = "";
        even = !even;        
        if (boatSelectedImmatriculation != null &&
                boat.getImmatriculation() == boatSelectedImmatriculation) {
            result = "selected";
        } else if (!boat.getActive()) {
            result = "refused";
        } else {
            result = even ? "even" : "odd";
        }
        return result;
    }

    public String getBoatInactive() {
        return !boat.getActive() ? "(inactif)" : "";
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("dd/MM/yyyy");
    }
    
    public boolean canCreateNewContactFromList() throws WaoException {
        if (!user.isAdmin() && !user.isProfessional() && !user.isReadOnly() && isSampleRowExists()) {
            return boat.canCreateContact(user.getProfile().getObsProgram(), user.getCompany());
        }
        return false;
    }

    StreamResponse onActionFromExportShowBoats() {
        return new ExportStreamResponse("wao-navires") {

            @Override
            public InputStream getStream() throws IOException {
                InputStream result = null;
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Filter sampleRow : " + getFilter().getSampleRow());
                    }
                    result = serviceBoat.exportBoatCsv(getBoatFilter());
                } catch (WaoException eee) {
                    throw new IOException(eee);
                }
                return result;
            }
        };
    }

    Block onActionFromShowBoatInfos(Integer boatImma) throws WaoException {
        boatSelectedImmatriculation = boatImma;
        // Suppress persistant boat informations
        companyBoatInfos = null;

        if (log.isDebugEnabled()) {
            log.debug("Show infos for boat : " + boatImma);
        }

        if (user.isAdmin() && getCompany() != null) {
            companySelectedId = getCompany().getTopiaId();
        }
        return boatsZone.getBody();
    }

    /**************************** Boat selected Infos *************************/

    @Persist
    private CompanyBoatInfos companyBoatInfos;

    @InjectComponent
    private Zone boatInfosZone;

    @Inject
    private Block displayBoatInfos;

    @Inject
    private Block editBoatInfos;

    @Property
    private ElligibleBoat elligibleBoat;

    @Property
    private String boatInfosSampleRowId;

    private boolean boatInfosEditable;

    private Date boardingFromDate;

    private GenericSelectModel<Company> companies;

    @Inject
    private ServiceUser serviceUser;

    @Property
    @Persist(PersistenceConstants.FLASH)
    private String companySelectedId;

    private Company company;

    /*@Persist
    private WaoPropertyChangeListener propertyChange;*/

    /** /////////////////////// GLOBAL TO THE BLOCK /////////////////////// **/

    @Inject
    private WaoManager manager;

    public boolean isActivityCalendarImportRun() {
        return manager.isActivityCalendarImportRun();
    }

    public Block getActiveBoatInfosBlock() {
        if (boatInfosEditable) {
            return editBoatInfos;
        }
        return displayBoatInfos;
    }

    public CompanyBoatInfos getCompanyBoatInfos() throws WaoException {
        if (companyBoatInfos == null && boatSelectedImmatriculation != null && getCompany() != null) {        
            companyBoatInfos = serviceBoat.getCompanyBoatInfos(user.getProfile().getObsProgram(),
                                boatSelectedImmatriculation, getCompany());
        }
        return companyBoatInfos;
    }

    /**
     * Retrieve companies select model for admin user. Only active companies
     * will be used for this model.
     *
     * @return the GenericSelectModel<Company>
     * @throws WaoException
     */
    public GenericSelectModel<Company> getCompanies() throws WaoException {
        if (companies == null) {
            List<Company> results = serviceUser.getCompanies(true);
            companies = new GenericSelectModel<Company>(results, Company.class, "name","topiaId",propertyAccess);
        }
        return companies;
    }

    /**
     * Get the current company. The user one if it's not an admin or the
     * selected one otherwise.
     *
     * @return the current Company
     * @throws WaoException
     */
    public Company getCompany() throws WaoException {
        if (company == null) {
            if (StringUtils.isNotEmpty(companySelectedId)) {
                company = getCompanies().findObject(companySelectedId);
            } else if (!user.isAdmin()) {
                company = user.getCompany();
            }
        }
        return company;
    }

    /**
     * Used to get the selected boat.
     *
     * @return the selected boat from the grid
     * @throws WaoException
     */
    public Boat getBoatSelected() throws WaoException {
        if (log.isDebugEnabled()) {
            log.debug("selected imma : " + boatSelectedImmatriculation);
            log.debug("exist boat ? : " + getBoats().contains(boatSelectedImmatriculation));
        }
        return getBoats().get(boatSelectedImmatriculation);
    }

    /**
     * Date for calculate boardings done for the selected boat. All boardings (number of contacts) will be calculated from this date.
     * Initialized as 12 months from today, but can be set by user.
     *
     * @return the Date used to calculate boardings done on the selected boat
     */
    public Date getBoardingFromDate() {
        if (boardingFromDate == null) {
            Calendar calendar = new GregorianCalendar();
            calendar.add(Calendar.MONTH, -12);
            boardingFromDate = calendar.getTime();
        }
        return boardingFromDate;
    }

    /**
     * Used by Tapestry to set the boardingFromDate from calculateBoardings form.
     *
     * @param boardingFromDate used to calculate boardings done on the selected boat
     */
    public void setBoardingFromDate(Date boardingFromDate) {
        this.boardingFromDate = boardingFromDate;
    }

    public BoatInfos getBoatInfos() throws WaoException {
        if (getCompanyBoatInfos() == null) {
            return null;
        }
        return getCompanyBoatInfos().getBoatInfos();
    }

    /**
     * Get CSS style class to apply on lastContact depends on its state.
     *
     * @return the CSS style to apply on contact block
     * @throws WaoException
     * @see WaoManager#getContactStyle(Contact, boolean)
     */
    public String getlastContactStyle() throws WaoException {
        Contact contact = getCompanyBoatInfos().getLastContact();
        return manager.getContactStyle(contact, user.isAdmin());
    }

    /** /////////////////////// FOR EACH ELLIGIBLEBOAT ROW ///////////////// **/

    public String getElligibleRowInfos() {
        return manager.getTooltipSampleRow(elligibleBoat.getSampleRow());
    }

    public boolean isElligibleBoatCompanyActiveFalse() {
        return BooleanUtils.isFalse(elligibleBoat.getCompanyActive());
    }

    public boolean canCreateNewContactFromElligibleBoat() throws WaoException {
        if (!user.isAdmin() && !user.isReadOnly() &&
                !isElligibleBoatCompanyActiveFalse()) {
            Boat currentBoat = getBoatInfos().getBoat();
            return currentBoat.canCreateContact(user.getProfile().getObsProgram(), user.getCompany());
        }
        return false;
    }

    /**
     * This method detect if the sampleRow from current elligibleBoat is finished.
     * This condition is necessary for confirm message dialog, only this condition
     * is needed to display the dialog message to be sure user is aware about
     * this sampleRow state.
     *
     * @return true if the sampleRow from current elligibleBoat is finished
     */
    public boolean isSampleRowFinished() {
        boolean result = elligibleBoat.getSampleRow().isFinished(0);
        return result;
    }

    public String getElligibleRowStyle() {
        boolean condition1 = elligibleBoat.getCompanyActive() == null && !elligibleBoat.getGlobalActive();
        return condition1 || isElligibleBoatCompanyActiveFalse() ? "line-through" : "";
    }

    /** /////////////////////// ACTIONS //////////////////////////////////// **/

    /**
     * Only user with no readOnly rights can edit BoatInfos.
     *
     * @return true if BoatInfos can be edited
     */
    public boolean canEditBoatInfos() {
        return !user.isReadOnly();
    }

    void onSuccess() throws WaoException {
        if (getBoatInfos() != null) {
            boatSelectedImmatriculation = getBoatInfos().getBoat().getImmatriculation();
        }
    }

    Block onSuccessFromCompanySelectForm() throws WaoException {
        companyBoatInfos = null;
        getCompanyBoatInfos();        
        return boatInfosZone.getBody();
    }

    Block onActionFromEditBoatInfos() throws WaoException {
        if (canEditBoatInfos()) {
            boatInfosEditable = true;
            // WARNING :: Reset sampleRow select for edition mode, no limit for
            // showing sampleRows instead of filters
            getFilter().setNbMonthFinishedFromToday(null);
            resetSampleRowSelectModel();
            getFilter().setNbMonthFinishedFromToday(-1);
        }
        return boatInfosZone.getBody();
    }

    Block onActionFromCancelEditBoatInfos() throws WaoException {
        /*if (propertyChange.isChanged()) {
            if (log.isDebugEnabled()) {
                log.debug("Change property");
            }
        }*/
        
        // Set boatSelectedImmatriculation for boatInfos to reinitialize it (next getBoatInfos() call)
        boatSelectedImmatriculation = getBoatInfos().getBoat().getImmatriculation();
        // Suppress boatInfos to get the one from serviceBoat (not updated yet)
        companyBoatInfos = null;
        return boatInfosZone.getBody();
    }

    void onSelectedFromAddBoatInfosSampleRow() throws WaoException {
        // We stay in edition mode
        boatInfosEditable = true;
        if (StringUtils.isNotEmpty(boatInfosSampleRowId)) {
            SampleRow row = getSampleRowSelectModel().findObject(boatInfosSampleRowId);
            companyBoatInfos.setNewElligibleBoat(row);
        }
    }

    void onSelectedFromRemoveBoatInfosSampleRow(String sampleRowCode) throws WaoException {
        boatInfosEditable = true;
        companyBoatInfos.removeElligibleBoat(sampleRowCode);
    }

    void onSelectedFromActiveBoatInfosSampleRow(String sampleRowCode) throws WaoException {
        boatInfosEditable = true;
        companyBoatInfos.activeElligibleBoat(sampleRowCode);
    }

    Block onSuccessFromBoatInfosForm() throws WaoException {
        if (!boatInfosEditable && canEditBoatInfos()) {
            // Save data
            serviceBoat.createUpdateCompanyBoatInfos(companyBoatInfos);
        }
        //boatSelectedImmatriculation = getBoatInfos().getBoat().getImmatriculation();
        return boatInfosZone.getBody();
    }

    Block onSuccessFromCalculateBoardings() throws WaoException {
        //boatSelectedImmatriculation = getBoatInfos().getBoat().getImmatriculation();
        return boatInfosZone.getBody();
    }

    /**************************** Create new contact **************************/

    @InjectPage
    private Contacts contacts;

    Object onActionFromAddNewContactFromBoat(int boatImmatriculation) throws WaoException {
        // Get selected sampleRow
        sampleRow = getSampleRow();
        // Get boat from list
        boat = getBoats().get(boatImmatriculation);
        //contacts.createNewContact(boat, sampleRow);
        Contact newContact = serviceContact.getNewContact(user, sampleRow, boat);
        contacts.setContactSelectedId(newContact.getTopiaId());
        return contacts;
    }

    Object onActionFromAddNewContactFromSampleRow(String sampleRowCode) throws WaoException {
        // Get sampleRow from elligibleBoat list
        ElligibleBoat elligible = getCompanyBoatInfos().getElligibleBoat(sampleRowCode);
        sampleRow = elligible.getSampleRow();
        Contact newContact = serviceContact.getNewContact(user, sampleRow, getBoatSelected());
        // contacts.createNewContact(getBoatSelected(), sampleRow);
        contacts.setContactSelectedId(newContact.getTopiaId());
        return contacts;
    }

    /**************************** Go to last ActivityCalendar *****************/

//    @InjectPage
//    private BoatActivityCalendar calendarPage;

    @Inject
    private PageRenderLinkSource renderLink;

    public boolean hasActivityCalendar() throws WaoException {
        return getBoatSelected() != null &&
                getBoatSelected().sizeActivityCalendar() != 0;
    }

    Link onActionFromShowLastActivityCalendar() throws WaoException {
        Link result = renderLink.createPageRenderLinkWithContext(
                BoatActivityCalendar.class,
                getBoatSelected().getImmatriculation());
        return result;
//        calendarPage.setBoat(getBoatSelected());
//        return calendarPage;
    }

    /*************************************** I18N ****************************/

    @Inject
    private Messages messages;

    public String getLabelForEnum(Enum value) {
        return messages.get(value.getDeclaringClass().getSimpleName() + "." + value.name());
    }
}
