/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.wao.ui.base;

import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.bean.SamplingFilterImpl;
import fr.ifremer.wao.service.ServiceSampling;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.corelib.components.Form;
import org.nuiton.util.PeriodDates;

import java.util.Calendar;
import java.util.GregorianCalendar;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class SamplingPlanFilterManager extends FilterManager<SamplingFilter> {

    @Persist
    protected SamplingFilter filter;

    @InjectComponent
    private Form filtersForm;

    public SamplingPlanFilterManager(ConnectedUser user,
                                     ServiceSampling serviceSampling) {

        super(user, serviceSampling);
    }

    @Override
    public SamplingFilter getFilter() {
        return filter;
    }

    @Override
    protected boolean isAvailableDataForFiltersOnly() {
        return false;
    }

    @Override
    public void resetFilter() {

        filter = new SamplingFilterImpl();
        // Initialize period
        PeriodDates period = PeriodDates.createMonthsPeriodFromToday(11);

        GregorianCalendar initialFromDate = new GregorianCalendar();
        // in the firsts months of a new year go from now to 6 months before
        // in the rest of the year, just start at the beginning of the current year
        if (initialFromDate.get(Calendar.MONTH) < 3) {
            initialFromDate.add(Calendar.MONTH, -6);
        } else {
            initialFromDate.set(Calendar.DAY_OF_YEAR, 1);
        }
        period.setFromDate(initialFromDate.getTime());
        filter.setPeriod(period);
        filter.setObsProgram(user.getProfile().getObsProgram());
        filter.setEstimatedTides(true);

        initCompagnyFilter();
    }
}
