/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id: ChartUtils.java 650 2010-10-03 15:14:48Z fdesbois $
 * $HeadURL: svn+ssh://bleny@labs.libre-entreprise.org/svnroot/suiviobsmer/tags/wao-2.0/wao-ui/src/main/java/fr/ifremer/wao/ui/data/ChartUtils.java $
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.wao.ui.data;

import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import org.jfree.chart.renderer.category.AreaRenderer;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleInsets;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

/**
 * ChartUtils
 *
 * Created: 13 janv. 2010
 *
 * @author fdesbois <fdesbois@codelutin.com>
 */
public class ChartUtils {

    public enum ChartType  {
        BAR(BarRenderer.class, false), LINE(LineAndShapeRenderer.class, true), AREA(AreaRenderer.class, true);

        protected Class<? extends AbstractCategoryItemRenderer> rendererClass;

        protected boolean noCategoryMargin;

        ChartType(Class<? extends AbstractCategoryItemRenderer> rendererClass, boolean noCategoryMargin) {
            this.rendererClass = rendererClass;
            this.noCategoryMargin = noCategoryMargin;
        }

        public AbstractCategoryItemRenderer createRenderer() {
            try {
                return rendererClass.newInstance();
            } catch (Exception eee) {
                // will never happens
                throw new RuntimeException(eee);
            }
        }
    }


    public static JFreeChart createCategoryChart(String title, String axisName, String categoryName, ChartType type,
            Map<String, Map<?, Integer>> input)  {
        DateFormat format = new SimpleDateFormat("MM/yyyy");
        boolean dateType = false;

        DefaultCategoryDataset dataset = new DefaultCategoryDataset();

        // Fill data in dataset
        for (Map.Entry<String, Map<?, Integer>> map : input.entrySet()) {
            for (Map.Entry<?, Integer> data : map.getValue().entrySet()) {
                Object dataKey = data.getKey();
                String columnKey = "";
                if (Date.class.isAssignableFrom(dataKey.getClass())) {
                    columnKey = format.format((Date)dataKey);
                    dateType = true;
                } else {
                    columnKey = dataKey.toString();
                }
                dataset.setValue(data.getValue(), map.getKey(), columnKey);
            }
        }

        // Axises
        CategoryAxis categoryAxis = new CategoryAxis(categoryName);
        if (dateType) {
            categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        }
        if (type.noCategoryMargin) {
            categoryAxis.setCategoryMargin(0);
        }
        ValueAxis valueAxis = new NumberAxis(axisName);
        valueAxis.setUpperMargin(0.15);

        // Renderer for Category
        AbstractCategoryItemRenderer renderer = type.createRenderer();
        // Show labels on each element
        renderer.setBaseItemLabelGenerator(new StandardCategoryItemLabelGenerator());
        renderer.setBaseItemLabelsVisible(Boolean.TRUE);

        CategoryPlot plot = new CategoryPlot(dataset, categoryAxis, valueAxis, renderer);
        plot.setOrientation(PlotOrientation.VERTICAL);
        plot.setAxisOffset(RectangleInsets.ZERO_INSETS);
        return new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, plot, true);
    }
}
