/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.entity.Company;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.data.GenericSelectModel;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.pages.KmlLoader;
import java.io.IOException;
import java.util.List;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.slf4j.Logger;

@RequiresAuthentication(value={UserRole.ADMIN, UserRole.COORDINATOR, UserRole.OBSERVER})
public class Cartography {
    @SessionState
    @Property
    private ConnectedUser user;
    @Inject
    private Logger logger;
    @Inject
    private PageRenderLinkSource pageRender;
    @Inject
    private PropertyAccess propertyAccess;
    @Inject
    private ServiceUser serviceUser;
    @Persist
    private GenericSelectModel<Company> companySelectModel;
    @Property
    private String companyId;
    @Persist
    private Company company;
    private String url;

    void setupRender() {
        if (this.logger.isDebugEnabled()) {
            String companyName = this.getCompany() != null ? this.getCompany().getName() : null;
            this.logger.debug("Company selected : " + companyName);
        }
        if (this.getCompany() != null) {
            this.companyId = this.getCompany().getTopiaId();
        }
    }

    public Company getCompany() {
        if (this.company == null && !this.user.isAdmin() && !this.user.isGuest()) {
            this.company = this.user.getCompany();
        }
        return this.company;
    }

    public GenericSelectModel<Company> getCompanySelectModel() throws WaoException {
        if (this.companySelectModel == null) {
            List companies = this.serviceUser.getCompanies(true);
            this.companySelectModel = new GenericSelectModel(companies, Company.class, "name", "topiaId", this.propertyAccess);
        }
        return this.companySelectModel;
    }

    public String getUrl() throws IOException {
        if (this.url == null) {
            Link link = this.pageRender.createPageRenderLinkWithContext(KmlLoader.class, new Object[]{KmlLoader.StrategyValues.CONTACTS, this.companyId});
            this.url = link.toURI();
        }
        return this.url;
    }

    public String getTitle() {
        return "Contacts";
    }

    public String getPageTitle() {
        String title = "R\u00e9partition des contacts par quartier des navires";
        if (this.company != null) {
            title = title + " pour la soci\u00e9t\u00e9 " + this.company.getName();
        }
        return title;
    }

    void onSuccessFromFilters() {
        if (!this.user.isAdmin()) {
            throw new WaoException("Vous n'avez pas les droits n\u00e9cessaires pour filtrer sur une soci\u00e9t\u00e9", null, new Object[0]);
        }
        this.company = (Company)this.companySelectModel.findObject(this.companyId);
    }
}

