/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.components;

import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.ui.components.FeedBack;
import fr.ifremer.wao.ui.pages.Index;
import fr.ifremer.wao.ui.services.ServiceAuthentication;
import fr.ifremer.wao.ui.services.WaoManager;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.Request;
import org.slf4j.Logger;

public class Layout {
    @Inject
    private WaoManager manager;
    @Parameter(required=true, defaultPrefix="literal")
    @Property
    private String pageTitle;
    @Parameter(required=true, defaultPrefix="literal")
    @Property
    private String contentId;
    @InjectComponent
    private FeedBack contentFeedback;
    @Inject
    private Request request;
    @Inject
    private Logger logger;
    @Inject
    private Messages messages;
    @Inject
    private ServiceAuthentication serviceAuthentication;
    private boolean fatal = false;

    boolean afterRender() {
        if (this.fatal && this.contentFeedback.hasErrors() && !this.contentFeedback.hasBeeanReloaded()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("[ FATAL ] Reload the page to display errors");
            }
            this.contentFeedback.reload();
            return false;
        }
        this.contentFeedback.clearErrors();
        this.fatal = false;
        return true;
    }

    public boolean isDevEnvironment() {
        return this.manager.isDevEnvironment();
    }

    public boolean isCurrentUserExists() {
        return this.serviceAuthentication.existConnectedUser();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public ConnectedUser getCurrentUser() {
        return this.serviceAuthentication.getConnectedUser();
    }

    public FeedBack getFeedBack() {
        return this.contentFeedback;
    }

    public String getAdminClass() {
        return !this.isAdministrationHidden() ? " admin" : "";
    }

    public String getSamplingSelected() {
        return this.contentId.equals("so-sampling") ? "selected" : "";
    }

    public String getBoatsSelected() {
        return this.contentId.equals("so-boats") ? "selected" : "";
    }

    public String getContactsSelected() {
        return this.contentId.equals("so-contacts") ? "selected" : "";
    }

    public String getSynthesisSelected() {
        return this.contentId.equals("so-synthesis") ? "selected" : "";
    }

    public String getAdminSelected() {
        return this.contentId.equals("so-admin") ? "selected" : "";
    }

    public boolean isAdministrationHidden() {
        return !this.getCurrentUser().isAdmin() && !this.getCurrentUser().isCoordinator();
    }

    public String getAccessText() {
        String text = this.getCurrentUser().getRole().getLabel();
        if (this.getCurrentUser().isReadOnly()) {
            text = text + " lecture seule";
        }
        return text;
    }

    public boolean displayBody() {
        return !this.fatal;
    }

    public void addInfo(String message) {
        this.contentFeedback.addInfo(message);
    }

    public void addError(String ... message) {
        this.contentFeedback.addError(message);
    }

    public void addFatal(String message) {
        this.contentFeedback.addError(new String[]{message});
        this.fatal = true;
    }

    @Log
    Object onActionFromExit() {
        this.serviceAuthentication.setConnectedUser(null);
        this.request.getSession(false).invalidate();
        return Index.class;
    }
}

