/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id: ContactDataSource.java 650 2010-10-03 15:14:48Z fdesbois $
 * $HeadURL: svn+ssh://tchemit@labs.libre-entreprise.org/svnroot/suiviobsmer/tags/wao-1.5.3/wao-ui/src/main/java/fr/ifremer/wao/ui/data/ContactDataSource.java $
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.wao.ui.data;

import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.ContactFilter;
import fr.ifremer.wao.entity.Contact;
import fr.ifremer.wao.service.ServiceContact;
import org.apache.tapestry5.grid.SortConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * ContactDataSource
 *
 * Created: 18 janv. 2010
 *
 * @author fdesbois <fdesbois@codelutin.com>
 */
public class ContactDataSource extends AbstractMappedGridDataSource<String, Contact> {

    private static Logger log = LoggerFactory.getLogger(ContactDataSource.class);

    private ContactFilter filter;

    private ServiceContact serviceContact;

    public ContactDataSource(ContactFilter filter, ServiceContact service) {
        this.filter = filter;
        serviceContact = service;
    }

    @Override
    public Class<?> getRowType() {
        return Contact.class;
    }
    
    @Override
    protected Map<String, Contact> execute(int startIndex, int endIndex, SortConstraint orderBy) throws WaoException {
        filter.setStartIndex(startIndex);
        filter.setEndIndex(endIndex);
        return serviceContact.getContacts(filter);
    }

    @Override
    protected int count() throws WaoException {
        return serviceContact.getNbContacts(filter);
    }

}
